#include <QApplication>
#include <QLineEdit>

#include "gemc_MainGui.h"
#include "icons.h"

#include <iostream>
#include <string>
using namespace std;

gemcMainWidget::gemcMainWidget(G4RunManager *RM, G4VisManager *VM, G4UImanager* UIM) 
{
 runManager = RM;
 visManager = VM;
 UImanager  = UIM;
 DTree      = NULL;

 setGeometry(100, 100, 700, 500);
 //setMaximumSize(700, 300);
 //setMinimumSize(700, 300);
 setFont( QFont( "lucida", 8) );

 // %%%%%%%
 // Buttons
 // %%%%%%%
 QWidget *MButtonW = new QWidget(this);
 MButtonW->setGeometry(10, 10, 180, 320);

 VMainButtons = new QVBoxLayout();
 string buttons[8] = {
                      "Run Control",
                      "Physics List Manager",
                      "Materials Manager",
                      "Beam On",
                      "Hit Manager",
                      "Geometry Manager",
                      "Verbosity Manager",
                      "Exit"
                     };

 for(int i=0; i<8; i++)
 {
    MainButtons[i] = new QPushButton(buttons[i].c_str(), this);
    VMainButtons->addWidget(MainButtons[i]);
 }

 MButtonW ->setLayout(VMainButtons);
 MButtonW->show();

 connect(MainButtons[7], SIGNAL(clicked()), qApp, SLOT(quit()));
 connect(MainButtons[5], SIGNAL(clicked()), this, SLOT(Build_DTree()));
 connect(MainButtons[3], SIGNAL(clicked()), this, SLOT(beamOn()));



 // %%%%%%%%%%%%%%%
 // Transformation
 // %%%%%%%%%%%%%%%
 theta_hall = phi_hall = 0;  // initial angles
 zoom_value = 1; //initial zoom

 QGroupBox *mainGroup = new QGroupBox(this);
 mainGroup->setFixedWidth(320);
 mainGroup->setFixedHeight(450);
 mainGroup->setTitle("Transformations");

 string slider_names[3] = {
                           "Theta",
                           "Phi",
                           "Zoom"
                          };

 int slider_mins[3] = {0,    0,   -30};
 int slider_maxs[3] = {180,  360,  150};

 for(int l=0; l<3; l++)
 {
    TransfGro[l] = new QGroupBox(mainGroup);
    TransfGro[l]->setTitle(slider_names[l].c_str());
    TransfLay[l] = new QVBoxLayout(TransfGro[l]);
    TransfSli[l] = new QSlider(Qt::Horizontal, TransfGro[l]);
    TransfSli[l]->setTickInterval(1);
    TransfSli[l]->setRange(slider_mins[l], slider_maxs[l]);
    TransfLay[l]->addWidget(TransfSli[l]);
 }

 Theta_V = new QLCDNumber(this);
 Theta_V->setFont(QFont("Helvetica", 32, QFont::Bold));
 Theta_V->setMaximumSize(45, 45);
 Theta_V->setSegmentStyle(QLCDNumber::Flat);
 Phi_V = new QLCDNumber(this);
 Phi_V->setMaximumSize(45, 45);
 Phi_V->setSegmentStyle(QLCDNumber::Flat);


 // Theta Combo
 for(int t=0; t<=180; t+=30) 
 {
  char tmp[100];
  sprintf(tmp, "%d", t);
  ThetaSet.push_back(tmp);
 }
 ThetaCombo = new QComboBox;
 for(int i=0; i<ThetaSet.size(); i++)  ThetaCombo->addItem(tr(ThetaSet[i].c_str()));
 ThetaCombo->setMaximumSize(60, 45);


 // Phi Combo
 for(int t=0; t<=360; t+=30) 
 {
  char tmp[100];
  sprintf(tmp, "%d", t);
  PhiSet.push_back(tmp);
 }
 PhiCombo = new QComboBox;
 for(int i=0; i<PhiSet.size(); i++) PhiCombo->addItem(tr(PhiSet[i].c_str()));
 PhiCombo->setMaximumSize(60, 45);


 // Panning Buttons
 TransfGro[3] = new QGroupBox(mainGroup);
// TransfGro[3]->setFixedWidth(270);
 TransfGro[3]->setTitle("Panning");

 PanButtons[0] = new QPushButton("Up",    this);
 PanButtons[1] = new QPushButton("Left",  this);
 PanButtons[2] = new QPushButton("Right", this);
 PanButtons[3] = new QPushButton("Down",  this);
 for(int b=0; b<4; b++)
    PanButtons[b]->setAutoRepeat ( TRUE );
 PanFactorSl = new QSlider(Qt::Horizontal, TransfGro[3]);
 PanFactorSl->setRange(0, 25);
 PanFactorSl->setValue(4);

 QGridLayout *panlayout = new QGridLayout;
 panlayout->addWidget(PanButtons[0],0,1,1,1);
 panlayout->addWidget(PanButtons[1],1,0,1,1);
 panlayout->addWidget(PanButtons[2],1,2,1,1);
 panlayout->addWidget(PanButtons[3],2,1,1,1);
 panlayout->addWidget(PanFactorSl,  1,1,1,1);

 TransfGro[3]->setLayout(panlayout);

 // Manual command box
 TransfGro[4] = new QGroupBox(mainGroup);
 TransfGro[4]->setTitle("G4 UI Command Line");
 TransfLay[4] = new QVBoxLayout(TransfGro[4]);
 ManualCommandQLineEdit = new QLineEdit();
 ManualCommandQLineEdit->setMaxLength(100);
 ManualCommandBox = new QComboBox();
 ManualCommandBox->setProperty("minimumContentsLength", 50);
 ManualCommandBox->setLineEdit(ManualCommandQLineEdit);
 TransfLay[4]->addWidget(ManualCommandBox);


 // Build the grid
 // Layout constructor:
 // addWidget ( QWidget * widget, int fromRow, int fromColumn, int rowSpan, int columnSpan, Qt::Alignment alignment = 0 )
 QGridLayout *layout = new QGridLayout;

 layout->addWidget(TransfGro[0], 0, 0, 1, 1);  
 layout->addWidget(Theta_V,      0, 1, 1, 1);  
 layout->addWidget(ThetaCombo,   0, 2, 1, 1);  

 layout->addWidget(TransfGro[1], 1, 0, 1, 1);  
 layout->addWidget(Phi_V,        1, 1, 1, 1);  
 layout->addWidget(PhiCombo,     1, 2, 1, 1);  


 layout->addWidget(TransfGro[3], 2, 0, 2, 2);  


 layout->addWidget(TransfGro[2], 4, 0, 1, 3);  

 layout->addWidget(TransfGro[4], 5, 0, 1, 3);  

 mainGroup->setLayout(layout);

 // Timer to udate angles
 timer = new QTimer(this);
//  connect(timer, SIGNAL(timeout()), this, SLOT(update_angles()));
//  timer->start(100);

 // Sliders
 connect ( TransfSli[0] , SIGNAL( valueChanged        (int) ),     this, SLOT( change_theta(int) ) );
 connect ( TransfSli[0] , SIGNAL( valueChanged        (int) ),  Theta_V, SLOT( display(int)      ) );
 connect ( ThetaCombo   , SIGNAL( currentIndexChanged (int) ),     this, SLOT( set_theta(int)    ) );

 connect ( TransfSli[1] , SIGNAL( valueChanged(int) ),             this, SLOT( change_phi(int)   ) );
 connect ( TransfSli[1] , SIGNAL( valueChanged(int) ),            Phi_V, SLOT( display(int)      ) );
 connect ( PhiCombo     , SIGNAL( currentIndexChanged (int) ),     this, SLOT( set_phi(int)      ) );


 connect ( TransfSli[2] , SIGNAL( valueChanged(int) ),  this, SLOT( zoom(int) ) );

 // Panning Buttons
 connect(PanButtons[0], SIGNAL(pressed()), this, SLOT( clickpan_up() ) );
 connect(PanButtons[1], SIGNAL(pressed()), this, SLOT( clickpan_left() ) );
 connect(PanButtons[2], SIGNAL(pressed()), this, SLOT( clickpan_right() ) );
 connect(PanButtons[3], SIGNAL(pressed()), this, SLOT( clickpan_down() ) );

 // Command box
 connect ( ManualCommandQLineEdit, SIGNAL( returnPressed() ),    this, SLOT( RunManualCommand() ) );

 // Overall Layout
 QHBoxLayout *viewLayout = new QHBoxLayout(this);
 viewLayout->addWidget(MButtonW);
 viewLayout->addWidget(mainGroup);



}

void gemcMainWidget::Build_DTree()
{
 string hd_msg = gemcOpt.args["LOG_MSG"].args;
 double VERB   = gemcOpt.args["GEO_VERBOSITY"].arg ;

 if(DTree != NULL)
 {
   delete DTree;
   if(VERB>3)
      cout << hd_msg << " Detector Widget Tree Already Present." << endl;
 }
  DTree = new detector_tree(Hall_Map, gemcOpt, runManager, visManager, UImanager, *MMats); 
  DTree->show();
}


gemcMainWidget::~gemcMainWidget()
{
 string hd_msg = gemcOpt.args["LOG_MSG"].args;

 if(DTree != NULL)
   delete DTree;

 for(int i=0; i<8; i++)
   delete MainButtons[i];
 for(int i=0; i<4; i++)
   delete PanButtons[i];

 cout << endl;
 delete VMainButtons;
 delete runManager;
 cout << hd_msg << " Run Manager deleted." << endl;
 delete visManager;
 cout << hd_msg << " Vis Manager deleted." << endl;

 cout << endl;
}



