#ifndef gemc_MAINGUI_H
#define gemc_MAINGUI_H

// %%%%%%%%%%
// Qt headers
// %%%%%%%%%%
#include <QComboBox>
#include <QGroupBox>
#include <QLCDNumber>
#include <QLineEdit>
#include <QObject>
#include <QPushButton>
#include <QSlider>
#include <QVBoxLayout>
#include <QWidget>

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4Material.hh"
#include "G4RunManager.hh"
#include "G4VisManager.hh"
#include "G4UImanager.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "detector_tree.h"
#include "usage.h"

// %%%%%%%%%%%%%%%%
// Class definition
// %%%%%%%%%%%%%%%%
class gemcMainWidget : public QWidget
{
 // metaobject required for non-qt slots
 Q_OBJECT

 public:
   gemcMainWidget(G4RunManager*, G4VisManager*, G4UImanager*);
  ~gemcMainWidget();

   map<string, detector> *Hall_Map;
   map<string, G4Material*> *MMats;
   gemc_opts gemcOpt;

 private:
   QLineEdit *ManualCommandQLineEdit;
   QComboBox *ManualCommandBox;
   QPushButton *MainButtons[8];
   QPushButton *PanButtons[4];
   QVBoxLayout *VMainButtons;

   // The timer will periodically update theta_hall, phi_hall if they're changed with the mouse
   QTimer *timer ;

   // Transformations
   int theta_hall, phi_hall;     
   double zoom_value;

   QGroupBox   *TransfGro[5];
   QVBoxLayout *TransfLay[5];
   QSlider     *TransfSli[3];
   QSlider     *PanFactorSl;

   QLCDNumber  *Theta_V;        
   QLCDNumber  *Phi_V;          

   QComboBox *ThetaCombo;       
   QComboBox *PhiCombo;         
   vector<string> ThetaSet;     
   vector<string> PhiSet;       


   // passing G4 managers to QT so we can delete them when QT quits
   // and can access directly the UImanager
   G4RunManager *runManager;
   G4VisManager *visManager;
   G4UImanager  *UImanager;

   detector_tree *DTree;

 private slots:

   // Command Box
   void RunManualCommand();

   // Transformations
   void clickpan_left();
   void clickpan_right();
   void clickpan_up();
   void clickpan_down();
   void change_theta(int);
   void set_theta(int);
   void change_phi(int);
   void set_phi(int);
   void zoom(int);
   void beamOn();

   void update_angles();

   // Tree
   void  Build_DTree();
};

#endif



