// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "run_conditions.h"

run_conditions::run_conditions(gemc_opts gemcOpt)
{
 string hd_msg    = gemcOpt.args["LOG_MSG"].args + " gcard: >> " ;

 string file = gemcOpt.args["gcard"].args;
 if(file=="no") return;

 QFile gcard(file.c_str());

 if (!domDocument.setContent(&gcard))
 {
     gcard.close();
     cout << hd_msg << " gcard format is wrong - check XML syntax. Exiting." << endl;
     return;
 }
 gcard.close();

 QDomElement docElem = domDocument.documentElement(); 
 QDomNode n;


 n = docElem.firstChild();  
 while(!n.isNull())
 {
    QDomElement e = n.toElement();                    
    if(!e.isNull())                                   
       if(e.tagName().toStdString() == "sqltable")    
       {
          string table_name = e.attributeNode("name").value().toStdString();  
          gTab_Vec.push_back(table_name);
       }
    n = n.nextSibling();
 }


 n = docElem.firstChild(); 
 while(!n.isNull())
 {
    QDomElement e = n.toElement();                    
    if(!e.isNull())                                   
       if(e.tagName().toStdString() == "detector")    
       {
          gcard_detector gdet;
          gdet.set_position("0*cm",  "0*cm",  "0*cm");   
          gdet.set_rotation("0*deg", "0*deg", "0*deg");  

          string det_name = e.attributeNode("name").value().toStdString();  

          QDomNode nn = e.firstChild();               
          while(!nn.isNull())
          {
             QDomElement ee = nn.toElement();
             if(!ee.isNull())
             {
                if(ee.tagName().toStdString() == "position")  
                {
                   gdet.set_position(ee.attributeNode("x").value().toStdString(),
                                     ee.attributeNode("y").value().toStdString(),
                                     ee.attributeNode("z").value().toStdString());
                }
                if(ee.tagName().toStdString() == "rotation")  
                {
                   gdet.set_rotation(ee.attributeNode("x").value().toStdString(),
                                     ee.attributeNode("y").value().toStdString(),
                                     ee.attributeNode("z").value().toStdString());
                }
             }

             nn = nn.nextSibling();
          }
          gDet_Map[det_name] = gdet;

       }

    n = n.nextSibling();
 }

 cout << hd_msg << "  Importing SQL tables: " << endl << endl;
 for(int i=0; i<gTab_Vec.size(); i++)
    cout << "                       \"" << gTab_Vec[i] << "\"" << endl ;
 cout << endl;
}

run_conditions::~run_conditions(){}


void gcard_detector::set_position(string X, string Y, string Z)
{
 pos.setX(get_number(X));
 pos.setY(get_number(Y));
 pos.setZ(get_number(Z));
}

void gcard_detector::set_rotation(string X, string Y, string Z)
{
 rot = G4RotationMatrix(G4ThreeVector(1, 0, 0),
                        G4ThreeVector(0, 1, 0),
                        G4ThreeVector(0, 0, 1));

 rot.rotateX(get_number(X));
 rot.rotateY(get_number(Y));
 rot.rotateZ(get_number(Z));
}


