






#ifndef run_conditions_H
#define run_conditions_H

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4ThreeVector.hh"
#include "G4RotationMatrix.hh"

// %%%%%%%%%%
// Qt headers
// %%%%%%%%%%
#include <QDomDocument>
#include <QtGui>

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "usage.h"

// %%%%%%%%%%%
// C++ headers
// %%%%%%%%%%%
#include <iostream>
using namespace std;

double get_number(string);   

class gcard_detector
{
 private:
   G4ThreeVector pos;
   G4RotationMatrix rot;

 public:
   gcard_detector(){;}
  ~gcard_detector(){;}

   void set_position(string X, string Y, string Z);
   void set_rotation(string X, string Y, string Z);
   G4ThreeVector    get_position(){return pos;}
   G4RotationMatrix get_rotation(){return rot;}

};



class run_conditions
{
 public:

   run_conditions(gemc_opts);
  ~run_conditions();

   map<string, gcard_detector> gDet_Map;   
   vector<string>              gTab_Vec;   

 private:
   QDomDocument domDocument;

};


#endif






