// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "usage.h"

// %%%%%%%%%%%
// C++ headers
// %%%%%%%%%%%
#include <cstdio>
#include <set>
#include <cstdlib>

gemc_opts::gemc_opts()
{
 // #########
 // Generator
 // #########

 args["BEAM_P"].args  = "e-, 11*GeV, 0*deg, 0*deg";
 args["BEAM_P"].help  = "Beam particle, momentum, angles (in respect of z-axis). \n";
 args["BEAM_P"].help += "            Example: -BEAM_P=\"e-, 6*GeV, 15*deg, 20*deg\" sets 6 GeV electrons 15 degrees in theta, 20 degrees in phi. \n";
 args["BEAM_P"].help += "            Use -BEAM_P=\"show_all\" to print the list of G4 supported particles.\n";
 args["BEAM_P"].name  = "Beam particle, Energy, Theta, Phi";
 args["BEAM_P"].type  = 1;
 args["BEAM_P"].ctgr  = "generator";

 args["SPREAD_P"].args  = "0*GeV, 0*deg, 0*deg";
 args["SPREAD_P"].help  = "Spread beam energy and angles (in respect of z-axis). \n";
 args["SPREAD_P"].help += "            Example: -SPREAD_P=\"0*GeV, 10*deg, 20*deg\" spreads 10 degrees in theta, 20 degrees in phi. \n";
 args["SPREAD_P"].name  = "delta_Energy, delta_Theta, delta_phi";
 args["SPREAD_P"].type  = 1;
 args["SPREAD_P"].ctgr  = "generator";

 args["BEAM_V"].args = "(0, 0, 0)cm";
 args["BEAM_V"].help = "Beam Vertex. Example: -BEAM_V=\"(0, 0, -20)cm\". ";
 args["BEAM_V"].name = "Beam Vertex";
 args["BEAM_V"].type = 1;
 args["BEAM_V"].ctgr = "generator";

 args["SPREAD_V"].args = "(0, 0, 0)cm";
 args["SPREAD_V"].help = "Spread Beam Vertex (cartesian coordinates). Example: -BEAM_V=\"(10, 10, 10)cm\". ";
 args["SPREAD_V"].name = "Vertex Spread";
 args["SPREAD_V"].type = 1;
 args["SPREAD_V"].ctgr = "generator";

 args["N"].arg  = 0;
 args["N"].help = "Number of events to be simulated.";
 args["N"].name = "Number of events to be simulated";
 args["N"].type = 0;
 args["N"].ctgr = "generator";

 args["INPUT_GEN_FILE"].args = "gemc_internal";
 args["INPUT_GEN_FILE"].help = "Generator Input. Current availables file formats:\n";
 args["INPUT_GEN_FILE"].help += "           LUND. \n";
 args["INPUT_GEN_FILE"].help += "           Example: -INPUT_GEN_FILE=\"LUND, input.dat\"\n";
 args["INPUT_GEN_FILE"].name = "Generator Input File";
 args["INPUT_GEN_FILE"].type = 1;
 args["INPUT_GEN_FILE"].ctgr = "generator";

 args["NGENP"].arg  = 1;
 args["NGENP"].help = "Number of Generated Particles to save in the Output.";
 args["NGENP"].name = "Number of Generated Particles to save in the Output";
 args["NGENP"].type = 0;
 args["NGENP"].ctgr = "generator";






 // ###############
 // Luminosity Beam
 // ###############

 args["LUMI_P"].args  = "e-, 11*GeV, 0*deg, 0*deg";
 args["LUMI_P"].help  = "Luminosity Beam particle, momentum, angles (in respect of z-axis). \n";
 args["LUMI_P"].help += "            Example: -LUMI_P=\"proton, 1*GeV, 25*deg, 2*deg\" sets 1 GeV protons, 25 degrees in theta, 2 degrees in phi. \n";
 args["LUMI_P"].help += "            Use -LUMI_P=\"show_all\" to print the list of G4 supported particles.\n";
 args["LUMI_P"].name  = "Luminosity Beam particle, Energy, Theta, Phi";
 args["LUMI_P"].type  = 1;
 args["LUMI_P"].ctgr = "luminosity";

 args["LUMI_V"].args = "(0, 0, 0)cm";
 args["LUMI_V"].help = "Luminosity Beam Vertex. Example: -LUMI_V=\"(0, 0, -20)cm\". ";
 args["LUMI_V"].name = "Luminosity Beam Vertex";
 args["LUMI_V"].type = 1;
 args["LUMI_V"].ctgr = "luminosity";

 args["LUMI_EVENT"].args = "0, 0*ns, 2*ns";
 args["LUMI_EVENT"].help = "Luminosity Beam Parameters: number of Particles/Event, Time Window, Time Between Bunches\n";
 args["LUMI_EVENT"].help += "            Example: -LUMI_EVENT=\"10000, 120*ns, 2*ns\" simulate 10K particles per event distributed over 120 ns, at 2ns intervals. \n";
 args["LUMI_EVENT"].name = "Luminosity Beam Parameters";
 args["LUMI_EVENT"].type = 1;
 args["LUMI_EVENT"].ctgr = "luminosity";






 // ##############
 // MySQL Database
 // ##############

 args["DATABASE"].args = "clas12_geometry";
 args["DATABASE"].help = "Select mysql Database.";
 args["DATABASE"].name = "Select mysql Database";
 args["DATABASE"].type = 1;
 args["DATABASE"].ctgr = "mysql";

 args["BANK_DATABASE"].args = "clas12_banks";
 args["BANK_DATABASE"].help = "Select mysql Bank Database.";
 args["BANK_DATABASE"].name = "Select mysql Bank Database";
 args["BANK_DATABASE"].type = 1;
 args["BANK_DATABASE"].ctgr = "mysql";

 args["GT"].args = "BST";
 args["GT"].help = "Selects Geometry table. This option is overwritten with the gemc read card.";
 args["GT"].name = "Geometry table";
 args["GT"].type = 1;
 args["GT"].ctgr = "mysql";








 // #########
 // Verbosity
 // #########

 args["G4P_VERBOSITY"].arg  = 1;
 args["G4P_VERBOSITY"].help = "Controls Physical Volumes Construction Log Output.";
 args["G4P_VERBOSITY"].name = "Logical Volume Verbosity";
 args["G4P_VERBOSITY"].type = 0;
 args["G4P_VERBOSITY"].ctgr = "verbosity";

 args["GEO_VERBOSITY"].arg  = 1;
 args["GEO_VERBOSITY"].help = "Controls Geometry Construction Log Output.";
 args["GEO_VERBOSITY"].name = "Geometry Verbosity";
 args["GEO_VERBOSITY"].type = 0;
 args["GEO_VERBOSITY"].ctgr = "verbosity";

 args["GUI_VERBOSITY"].arg  = 1;
 args["GUI_VERBOSITY"].help = "Controls GUI Construction Log Output.";
 args["GUI_VERBOSITY"].name = "GUI Verbosity";
 args["GUI_VERBOSITY"].type = 0;
 args["GUI_VERBOSITY"].ctgr = "verbosity";

 args["HIT_VERBOSITY"].arg  = 1;
 args["HIT_VERBOSITY"].help = "Controls Hits Log Output. ";
 args["HIT_VERBOSITY"].name = "Hit Verbosity";
 args["HIT_VERBOSITY"].type = 0;
 args["HIT_VERBOSITY"].ctgr = "verbosity";

 args["LOG_MSG"].args = "  >>> gemc";
 args["LOG_MSG"].help = "Log Messages Header.";
 args["LOG_MSG"].name = "Log Messages Header";
 args["LOG_MSG"].type = 1;
 args["LOG_MSG"].ctgr = "verbosity";

 args["CATCH"].args = "Maurizio";
 args["CATCH"].help = "Catch volumes matching the given string.";
 args["CATCH"].name = "Volume catcher";
 args["CATCH"].type = 1;
 args["CATCH"].ctgr = "verbosity";

 args["MGN_VERBOSITY"].arg  = 1;
 args["MGN_VERBOSITY"].help = "Controls Magnetic Fields Log Output.";
 args["MGN_VERBOSITY"].name = "Magnetic Fields Verbosity";
 args["MGN_VERBOSITY"].type = 0;
 args["MGN_VERBOSITY"].ctgr = "verbosity";

 args["PRINT_EVENT"].arg  = 1000;
 args["PRINT_EVENT"].help = "-PRINT_EVENT=N: Print Event Number every N events.";
 args["PRINT_EVENT"].name = "Print Event Modulus";
 args["PRINT_EVENT"].type = 0;
 args["PRINT_EVENT"].ctgr = "verbosity";

 args["OUT_VERBOSITY"].arg  = 1;
 args["OUT_VERBOSITY"].help = "Controls Bank Log Output.";
 args["OUT_VERBOSITY"].name = "Bank Output Verbosity";
 args["OUT_VERBOSITY"].type = 0;
 args["OUT_VERBOSITY"].ctgr = "verbosity";

 args["PHY_VERBOSITY"].arg  = 1;
 args["PHY_VERBOSITY"].help = "Controls Physics List Log Output.";
 args["PHY_VERBOSITY"].name = "Physics List Verbosity";
 args["PHY_VERBOSITY"].type = 0;
 args["PHY_VERBOSITY"].ctgr = "verbosity";

 args["GEN_VERBOSITY"].arg  = 0;
 args["GEN_VERBOSITY"].help = "Controls Geant4 Generator Verbosity.";
 args["GEN_VERBOSITY"].name = "Geant4 Generator Verbosity";
 args["GEN_VERBOSITY"].type = 0;
 args["GEN_VERBOSITY"].ctgr = "verbosity";

 args["G4TRACK_VERBOSITY"].arg  = 0;
 args["G4TRACK_VERBOSITY"].help = "Controls Geant4 Track Verbosity.";
 args["G4TRACK_VERBOSITY"].name = "Geant4 Track Verbosity";
 args["G4TRACK_VERBOSITY"].type = 0;
 args["G4TRACK_VERBOSITY"].ctgr = "verbosity";












 // ###########
 // Run Control
 // ###########

 args["EXEC_MACRO"].args = "no";
 args["EXEC_MACRO"].help = "Executes commands in macro file.";
 args["EXEC_MACRO"].name = "Executes commands in macro file";
 args["EXEC_MACRO"].type = 1;
 args["EXEC_MACRO"].ctgr = "control";

 args["CHECK_OVERLAPS"].arg  = 0;
 args["CHECK_OVERLAPS"].help = "Checks Overlapping Volumes at Construction time.";
 args["CHECK_OVERLAPS"].name = "Checks Overlapping Volumes at Construction time";
 args["CHECK_OVERLAPS"].type = 0;
 args["CHECK_OVERLAPS"].ctgr = "control";

 args["USE_QT"].arg  = 1;
 args["USE_QT"].help = "Use/Don't Use the QT GUI. If set to 2, use OGLIX.";
 args["USE_QT"].name = "QT Gui";
 args["USE_QT"].type = 0;
 args["USE_QT"].ctgr = "control";

 args["RANDOM"].args = "TIME";
 args["RANDOM"].help = "Random Engine Initialization. The argument (seed) can be an integer or the string TIME.";
 args["RANDOM"].name = "Random Engine Initialization";
 args["RANDOM"].type = 1;
 args["RANDOM"].ctgr = "control";

 args["gcard"].args = "no";
 args["gcard"].help = "gemc card file.";
 args["gcard"].name = "gemc card file";
 args["gcard"].type = 1;
 args["gcard"].ctgr = "control";

 args["EVN"].arg  = 1;
 args["EVN"].help = "Initial Event Number.";
 args["EVN"].name = "Initial Event Number";
 args["EVN"].type = 0;
 args["EVN"].ctgr = "control";












 // ######
 // Output
 // ######

 args["OUTPUT"].args = "no, output";
 args["OUTPUT"].help = "Type of output, output filename.";
 args["OUTPUT"].name = "Type of output, output filename. Supported output: evio, txt. Example: -OUTPUT=\"evio, out.ev\"";
 args["OUTPUT"].type = 1;
 args["OUTPUT"].ctgr = "output";











 // #######
 // Physics
 // #######

 args["OPT_PH"].arg  = 0;
 args["OPT_PH"].help = "Activate Optical Physics Processes in gemc Physics List.";
 args["OPT_PH"].name = "Optical Physics";
 args["OPT_PH"].type = 0;
 args["OPT_PH"].ctgr = "physics";

 args["USE_PHYSICSL"].args = "gemc";
 args["USE_PHYSICSL"].help =  "Physics List. Avaliable choices: \n\n";
 args["USE_PHYSICSL"].help += "            * gemc: comprehensive physics list. Optical Physics may be activated with OPT_PH=1 \n\n";
 args["USE_PHYSICSL"].help += "            The following is a list of other physics lists. More infos can be found here:\n\n";
 args["USE_PHYSICSL"].help += "            http://geant4.cern.ch/support/proc_mod_catalog/physics_lists/referencePL.shtml\n\n";
 args["USE_PHYSICSL"].help += "            * LHEP: This is the main LHEP based physics list, using exclusively parameterised modeling. \n";
 args["USE_PHYSICSL"].help += "            * LHEP_BERT: Like LHEP, but using Geant4 Bertini cascade for primary protons, neutrons, \n";
 args["USE_PHYSICSL"].help += "               pions and Kaons below ~10GeV.  \n";
 args["USE_PHYSICSL"].help += "            * LHEP_BERT_HP: Like LHEP_BERT with the addition to use the data driven high precision.\n";
 args["USE_PHYSICSL"].help += "               neutron package (NeutronHP) to transport neutrons below 20 MeV down to thermal energies.\n";
 args["USE_PHYSICSL"].help += "            * QGSP:  String model based physics list. \n";
 args["USE_PHYSICSL"].help += "            * QGSP_BERT: Like QGSP, but using Geant4 Bertini cascade for primary protons, neutrons, \n";
 args["USE_PHYSICSL"].help += "               pions and Kaons below ~10GeV.  \n";
 args["USE_PHYSICSL"].help += "            * QGSP_BERT_HP: Like QGSP_BERT with the addition to use the data driven high precision.\n";
 args["USE_PHYSICSL"].help += "               neutron package (NeutronHP) to transport neutrons below 20 MeV down to thermal energies.\n";
 args["USE_PHYSICSL"].help += "            * QGSP_BIC: Like QGSP, but using Geant4 Binary cascade for primary protons and neutrons \n";
 args["USE_PHYSICSL"].help += "               with energies below ~10GeV.  \n";
 args["USE_PHYSICSL"].help += "            * QGSP_BIC_HP: Like QGSP_BIC with the addition to use the data driven high precision.\n";
 args["USE_PHYSICSL"].help += "               neutron package (NeutronHP) to transport neutrons below 20 MeV down to thermal energies.\n";
 args["USE_PHYSICSL"].name = "Choice of Physics List";
 args["USE_PHYSICSL"].type = 1;
 args["USE_PHYSICSL"].ctgr = "physics";

 args["HALL_MATERIAL"].args = "Vacuum";
 args["HALL_MATERIAL"].help = "Composition of the Experimental Hall. \n";
 args["HALL_MATERIAL"].help += "            Air normal simulation\n";
 args["HALL_MATERIAL"].help += "            Air_Opt Simulation with Optical Physics (default)\n";
 args["HALL_MATERIAL"].help += "            Vacuum\n";
 args["HALL_MATERIAL"].name = "Composition of the Experimental Hall";
 args["HALL_MATERIAL"].type = 1;
 args["HALL_MATERIAL"].ctgr = "physics";

 args["HALL_FIELD"].args = "no";
 args["HALL_FIELD"].help = "Magnetic Field of the Hall. \n";
 args["HALL_FIELD"].name = "Magnetic Field of the Hall";
 args["HALL_FIELD"].type = 1;
 args["HALL_FIELD"].ctgr = "physics";









 // #######
 // General
 // #######

 args["SERVICE"].arg  = 0;
 args["SERVICE"].help = "Runs gemc as a service.";
 args["SERVICE"].name = "Runs gemc as a service";
 args["SERVICE"].type = 0;
 args["SERVICE"].ctgr = "general";


}

gemc_opts::~gemc_opts(){}

int gemc_opts::Set(int argc, char **argv)
{
 string arg;
 string com;
 string opt;
 cout << endl;
 string comp;

 map<string, opts>::iterator itm;

 set<string> category;

 // Filling Categories
 for(itm = args.begin(); itm != args.end(); itm++)
    if(category.find(itm->second.ctgr) == category.end()) category.insert(itm->second.ctgr);



 // -help-all
 for(int i=1; i<argc; i++)
 {
    arg = argv[i];
    com = "-help-all";
    if(arg == com)
    {
       cout <<  "    Usage: -Option=<option>" << endl << endl;
       cout <<  "    Options:" <<  endl << endl ;

       for(itm = args.begin(); itm != args.end(); itm++)
          cout <<  "   > Option " <<  itm->first << ": " << itm->second.help << endl;

       cout << endl << endl;
       exit(0);
    }
 }


 // -help
 set<string> :: iterator itcat;
 for(int i=1; i<argc; i++)
 {
    arg = argv[i];
    com = "-help";
    if(arg == com)
    {
       cout <<  endl << endl;
       cout <<  "    Help Options:" <<  endl << endl ;
       cout <<  "   >  -help-all:  all available options. " <<  endl << endl;
       for(itcat = category.begin(); itcat != category.end(); itcat++)
       {

          cout <<  "   >  -help-" << *itcat << "     ";
          cout.width(15);
          cout << *itcat << " options." << endl;
       }
       cout << endl << endl;
       exit(0);
    }
 }


 // -help-option
 for(int i=1; i<argc; i++)
 {
    arg = argv[i];
    for(itcat = category.begin(); itcat != category.end(); itcat++)
    {
       com = "-help-" + *itcat;
       if(arg == com)
       {
          cout << endl << endl <<  "   ## " << *itcat << " ## " << endl << endl;
          cout << "    Usage: -Option=<option>" << endl << endl;
          for(itm = args.begin(); itm != args.end(); itm++)
             if(itm->second.ctgr == *itcat) cout <<  "   > " <<  itm->first << ": " << itm->second.help << endl;
          cout << endl << endl;
          exit(0);
       }
    }
 }


 for(int i=1; i<argc; i++)
 {
    arg = argv[i];
    map<string, opts>::iterator itm; 
    for(itm = args.begin(); itm != args.end(); itm++)
    {
       com = "-" + itm->first + "=";
       comp.assign(arg, 0, arg.find("=") + 1);
       if(comp == com)
       {
          opt.assign(arg, com.size(), arg.size()-com.size());
          itm->second.args = opt;
          itm->second.arg  = atof(opt.c_str());
          cout <<  " >>> Options: " << itm->second.name << " set to: " ;
          if(itm->second.type) cout << itm->second.args;
          else cout << itm->second.arg  ;
          cout << endl;
       }
    }
 }

 cout << endl;

 return 1;
}





