// %%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%
#include "FST_hitprocess.h"
#include "fst_strip.h"

PH_output FST_HitProcess :: ProcessHit(MHit* aHit, gemc_opts Opt)
{
 string hd_msg   = Opt.args["LOG_MSG"].args + " FST Hit Process " ;
 double VERB     = Opt.args["HIT_VERBOSITY"].arg;
 
 PH_output out;
 out.identity = aHit->GetId();
     
 HCname = "FST Hit Process";
 
 // %%%%%%%%%%%%%%%%%%%
 // Raw hit information
 // %%%%%%%%%%%%%%%%%%%
 int nsteps = aHit->GetPos().size();
 
 // Get Total Energy deposited
 double Etot = 0;
 vector<G4double> Edep = aHit->GetEdep();
 for(int s=0; s<nsteps; s++) Etot = Etot + Edep[s];
 
 // average global, local positions of the hit
 double x, y, z;
 double lx, ly, lz;
 x = y = z = lx = ly = lz = 0;
 vector<G4ThreeVector> pos  = aHit->GetPos();
 vector<G4ThreeVector> Lpos = aHit->GetLPos();
 
 if(Etot>0)
 for(int s=0; s<nsteps; s++)
 {   
    x  = x  +  pos[s].x()*Edep[s]/Etot;
    y  = y  +  pos[s].y()*Edep[s]/Etot;
    z  = z  +  pos[s].z()*Edep[s]/Etot;
    lx = lx + Lpos[s].x()*Edep[s]/Etot;
    ly = ly + Lpos[s].y()*Edep[s]/Etot;
    lz = lz + Lpos[s].z()*Edep[s]/Etot;
 }
 else
 {
   x  = pos[0].x();
   y  = pos[0].y();
   z  = pos[0].z();
   lx = Lpos[0].x();
   ly = Lpos[0].y();
   lz = Lpos[0].z();
 }   

 
 // average time
 double time = 0;
 vector<G4double> times = aHit->GetTime();
 for(int s=0; s<nsteps; s++) time = time + times[s]/nsteps;

 // Energy of the track
 double Ene = aHit->GetE();
 
 out.raws.push_back(Etot);
 out.raws.push_back(x);
 out.raws.push_back(y);
 out.raws.push_back(z);
 out.raws.push_back(lx);
 out.raws.push_back(ly);
 out.raws.push_back(lz);
 out.raws.push_back(time);
 out.raws.push_back((double) aHit->GetPID());
 out.raws.push_back(aHit->GetVert().getX());
 out.raws.push_back(aHit->GetVert().getY());
 out.raws.push_back(aHit->GetVert().getZ());
 out.raws.push_back(Ene);
 out.raws.push_back((double) aHit->GetmPID());
 out.raws.push_back(aHit->GetmVert().getX());
 out.raws.push_back(aHit->GetmVert().getY());
 out.raws.push_back(aHit->GetmVert().getZ());
 

 // %%%%%%%%%%%%%%%%%%%%%%%%%%
 // Digitization
 // FST ID:
 // layer, type, sector, strip
 // %%%%%%%%%%%%%%%%%%%%%%%%%% 
 int layer  = 2*out.identity[0].id + out.identity[1].id - 2 ;
 int sector = out.identity[2].id;
 int strip  = out.identity[3].id;
 
 if(VERB>4)
 cout <<  hd_msg << " layer: " << layer << "  sector: " << sector 
      << "  Strip: " << strip << " x=" << x << " y=" << y << " z=" << z << endl; 

 out.dgtz.push_back(layer);
 out.dgtz.push_back(sector);
 out.dgtz.push_back(strip); 

 return out;
}



vector<identifier>  FST_HitProcess :: ProcessID(vector<identifier> id, G4Step* aStep, detector Detector)
{
 double x, y, z;
 G4ThreeVector   xyz    = aStep->GetPostStepPoint()->GetPosition();
 x = xyz.x()/mm; 
 y = xyz.y()/mm; 
 z = xyz.z()/mm; 
 
 vector<identifier> yid = id;  
 class fst_strip fsts;
 fsts.fill_infos();  
 
 int layer  = 2*yid[0].id + yid[1].id - 2 ;
 int sector = yid[2].id;
 
 yid[3].id = fsts.FindStrip(layer-1, sector-1, x, y, z);
 
 return yid;
}










