




#ifndef MHit_H
#define MHit_H 1

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4ThreeVector.hh"
#include "G4VHit.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "detector.h"

// %%%%%%%%%%%
// C++ headers
// %%%%%%%%%%%
#include <iostream>
using namespace std;

// %%%%%%%%%%%%%%%%
// Class definition
// %%%%%%%%%%%%%%%%
class MHit : public G4VHit
{

 public:
   MHit();
   virtual ~MHit();
   const MHit& operator=(const MHit&){return *this;}

   void Draw();

 private:
    vector<G4ThreeVector>   pos;    
    vector<G4ThreeVector>  Lpos;    
    vector<double>         edep;    
    vector<double>         time;    
    G4ThreeVector           mom;    
    double                    E;    
    G4ThreeVector          vert;    
    int                     PID;    
    vector<int>         trackID;    
    vector<identifier> identity;    
    detector           Detector;    
    int                    mPID;    
    int                mtrackID;    
    G4ThreeVector         mvert;    
    double              minEdep;    

 public:
   inline void SetPos(G4ThreeVector xyz)       { pos.push_back(xyz); }
   inline vector<G4ThreeVector> GetPos()       { return pos; }
   inline G4ThreeVector GetLastPos()           { if(pos.size()) return pos[pos.size()-1];  }

   inline void SetLPos(G4ThreeVector xyz)      { Lpos.push_back(xyz); }
   inline vector<G4ThreeVector> GetLPos()      { return Lpos; }

   inline void SetEdep(double depe)            { edep.push_back(depe); }
   inline vector<double> GetEdep()             { return edep; }

   inline void SetTime(double ctime)           { time.push_back(ctime); }
   inline vector<double> GetTime()             { return  time; }

   inline void SetMom(G4ThreeVector pxyz)      { mom = pxyz; }
   inline G4ThreeVector GetMom()               { return mom; }

   inline void SetE(double ene)                { E = ene; }
   inline double GetE()                        { return E; }

   inline void SetVert(G4ThreeVector ver)      { vert = ver; }
   inline G4ThreeVector GetVert()              { return  vert; }

   inline void SetPID(string pid)              { PID = mc_number_scheme(pid); }
   inline int GetPID()                         { return PID; }

   inline void SetTrackId(int tid)             { trackID.push_back(tid); }
   inline vector<int> GetTrackId()             { return trackID; }

   inline void SetmPID(string mpid)            { mPID = mc_number_scheme(mpid); }
   inline int GetmPID()                        { return mPID; }

   inline void SetmTrackId(int tid)            { mtrackID = tid; }
   inline int GetmTrackId()                    { return mtrackID; }

   inline void SetmVert(G4ThreeVector ver)     { mvert = ver; }
   inline G4ThreeVector GetmVert()             { return  mvert; }

   inline vector<identifier> GetId()           { return identity; }
   inline void SetId(vector<identifier> iden)  { identity = iden; }

   inline void SetDetector(detector det)       {Detector = det;}
   inline detector GetDetector()               {return Detector;}

   inline void SetThreshold(double E)          { minEdep = E; }
   inline double GetThreshold()                { return minEdep; }

   int mc_number_scheme(string);

};


#include "G4THitsCollection.hh"
typedef G4THitsCollection<MHit> MHitCollection;

#endif
