






#ifndef MPHBASECLASS_H
#define MPHBASECLASS_H 1

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "detector.h"
#include "MHit.h"
#include "usage.h"

class PH_output
{
 public:
   vector<double>     raws;        
   vector<int>        dgtz;        
   vector<identifier> identity;    
};

class MPHBaseClass
{
 public:
   virtual PH_output ProcessHit(MHit*, gemc_opts) = 0;                                 
   virtual vector<identifier> ProcessID(vector<identifier>, G4Step*, detector) = 0;    
   string HCname;                                                                      
};

typedef MPHBaseClass *(*MPHB_Factory)();                       

MPHBaseClass *GetMPHClass (map<string, MPHB_Factory>, string); 


#endif
