




#ifndef detector_H
#define detector_H 1

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4Colour.hh"
#include "G4FieldManager.hh"
#include "G4LogicalVolume.hh"
#include "G4Material.hh"
#include "G4PVPlacement.hh"
#include "G4ThreeVector.hh"
#include "G4VisAttributes.hh"
#include "G4VSensitiveDetector.hh"
#include "G4VSolid.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "usage.h"
#include "identifier.h"
#include "run_conditions.h"


class detector
{

 public:
   detector();
  ~detector(){};

   string                 name;   
   string               mother;   
   string          description;   

   G4ThreeVector           pos;   
   G4RotationMatrix        rot;   

   G4VisAttributes       VAtts;   

   string                 type;   
   vector<double>   dimensions;   

   string             material;   
   string             magfield;   

   int                   ncopy;   
   bool                  pMany;   

   int                   exist;   
   int                 visible;   
   int                   style;   

   string          sensitivity;   
   string              hitType;   
   vector<identifier> identity;   

   int                 scanned;   

 private:
   G4VSolid*                     SolidV;   
   G4LogicalVolume*              LogicV;   
   G4VPhysicalVolume*         PhysicalV;   

 public:
   int create_solid(gemc_opts, map<string, detector>*);                             
   int create_logical_volume(map<string, G4Material*>*, gemc_opts);                 
   int create_physical_volumes(gemc_opts, G4LogicalVolume*);                        
   void setSensitivity(G4VSensitiveDetector *SD){LogicV->SetSensitiveDetector(SD);} 

   G4VSolid          *GetSolid()   { return SolidV;}                                
   G4LogicalVolume   *GetLogical() { return LogicV;}                                
   G4VPhysicalVolume *GetPhysical(){ return PhysicalV;}                             
   void SetLogical(G4LogicalVolume *LV){LogicV = LV;}                               
   void SetTranslation(G4ThreeVector TR){PhysicalV->SetTranslation(TR);}            
   void RemoveDaughter(G4VPhysicalVolume* PV){LogicV->RemoveDaughter(PV);}          
   void AssignMFM(G4FieldManager* MFM){LogicV->SetFieldManager(MFM, true);}         

   void SetUserLimits(G4UserLimits* L) { LogicV->SetUserLimits(L);}

   friend ostream &operator<<(ostream &stream, detector);                           
   bool operator== (const detector& D) const;                                       
};


// All these functions defined here but maybe should be moved somewhere else for consistency.
vector< vector<string> > dimensionstype(string);                  
double get_number(string);                                        
string TrimSpaces(string in);                                     
map<string, detector> read_detector(gemc_opts, run_conditions);   
map<string, G4Material*> DefineMaterials();                       
vector<int> set_IDshifts(vector<int>);                            


#endif

