#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <QGLWidget>

 class GLWidget : public QGLWidget
 {
/*      Q_OBJECT */

 public:
     GLWidget(QWidget *parent = 0);
     ~GLWidget();
     void initializeGL();
     void initialize();
     void resizeGL(int width, int height);
     void paintGL();

/*      QSize minimumSizeHint() const; */
/*      QSize sizeHint() const; */

 protected:
     void setXRotation(int angle);
     void setYRotation(int angle);
     void setZRotation(int angle);

/*  signals: */
/*      void xRotationChanged(int angle); */
/*      void yRotationChanged(int angle); */
/*      void zRotationChanged(int angle); */

     void mousePressEvent(QMouseEvent*);
     void mouseMoveEvent(QMouseEvent*);
     void normalizeAngle(int *angle);

 private:
     GLuint makeObject();
     void quad(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2,
               GLdouble x3, GLdouble y3, GLdouble x4, GLdouble y4);
     void extrude(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);

     GLuint object;
     int xRot;
     int yRot;
     int zRot;
     float reelXRot;
     float realYRot;
     float realZRot;
     QPoint lastPos;
     QColor trolltechGreen;
     QColor trolltechPurple;
 };

 #endif
