//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4Polyline.cc,v 1.11 2006/06/29 19:07:08 gunter Exp $
// GEANT4 tag $Name: HEAD $
//
// 
// John Allison  July 1995

#include "G4Polyline.hh"

G4Polyline::G4Polyline () {}

G4Polyline::~G4Polyline () {}

G4Polyline& G4Polyline::transform (const G4Transform3D& transformation) {
  for (iterator i = begin(); i != end(); ++i) i->transform(transformation);
  return *this;
}

std::ostream& operator << (std::ostream& os, const G4Polyline& line) {
  os << "G4Polyline: ";
  os << '\n' << (const G4Visible&) line;
  os << '\n' << (const G4Point3DList&) line;
  return os;
}
