//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4NucleiPropertiesTableB.cc,v 1.9 2006/06/29 19:25:44 gunter Exp $
// GEANT4 tag $Name: HEAD $
//
// -------------------------------------------------------------------
//      GEANT 4 class implementation file 
//
//      File name:     G4NucleiPropertiesTable.cc 
//
//      Authors:       Vicente Lara (Vicente.Lara@cern.ch)
//                     Christian V"olcker (Christian.Volcker@cern.ch),
//
//      Creation date: November 1997
//
//      Modifications: 
// -------------------------------------------------------------------
// Migrate into particles category by H.Kurashige (17 Nov. 98)
// Add shortTable initialization by H.Kurashige (12 Dec. 03)

#include "G4NucleiPropertiesTable.hh"


// Class G4NucleiPropertiesTable 


//+------------------------------------------------------------+
//| Table of Z (number of protons) and A (number of nucleons)  |
//|        indexArray[0][ ] --> Z                              |
//|        indexArray[1][ ] --> A                              |
//+------------------------------------------------------------+
G4int G4NucleiPropertiesTable::indexArray[2][G4NucleiPropertiesTable::nEntries] = {
  // ---------- Z ----------
  {
  0,   1,   1,   1,   2,   1,   2,   3,   1,   2,   3, 
  4,   1,   2,   3,   4,   2,   3,   4,   5,   2,   3, 
  4,   5,   6,   2,   3,   4,   5,   6,   2,   3,   4, 
  5,   6,   7,   3,   4,   5,   6,   7,   3,   4,   5, 
  6,   7,   8,   4,   5,   6,   7,   8,   4,   5,   6, 
  7,   8,   9,   5,   6,   7,   8,   9,   5,   6,   7, 
  8,   9,  10,   5,   6,   7,   8,   9,  10,   5,   6, 
  7,   8,   9,  10,  11,   5,   6,   7,   8,   9,  10, 
 11,   6,   7,   8,   9,  10,  11,  12,   6,   7,   8, 
  9,  10,  11,  12,  13,   6,   7,   8,   9,  10,  11, 
 12,  13,  14,   7,   8,   9,  10,  11,  12,  13,  14, 
  7,   8,   9,  10,  11,  12,  13,  14,  15,   8,   9, 
 10,  11,  12,  13,  14,  15,   8,   9,  10,  11,  12, 
 13,  14,  15,  16,   9,  10,  11,  12,  13,  14,  15, 
 16,   9,  10,  11,  12,  13,  14,  15,  16,  17,   9, 
 10,  11,  12,  13,  14,  15,  16,  17,  10,  11,  12, 
 13,  14,  15,  16,  17,  18,  10,  11,  12,  13,  14, 
 15,  16,  17,  18,  10,  11,  12,  13,  14,  15,  16, 
 17,  18,  19,  11,  12,  13,  14,  15,  16,  17,  18, 
 19,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20, 
 11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  12, 
 13,  14,  15,  16,  17,  18,  19,  20,  21,  12,  13, 
 14,  15,  16,  17,  18,  19,  20,  21,  13,  14,  15, 
 16,  17,  18,  19,  20,  21,  22,  13,  14,  15,  16, 
 17,  18,  19,  20,  21,  22,  14,  15,  16,  17,  18, 
 19,  20,  21,  22,  23,  14,  15,  16,  17,  18,  19, 
 20,  21,  22,  23,  14,  15,  16,  17,  18,  19,  20, 
 21,  22,  23,  24,  15,  16,  17,  18,  19,  20,  21, 
 22,  23,  24,  15,  16,  17,  18,  19,  20,  21,  22, 
 23,  24,  25,  15,  16,  17,  18,  19,  20,  21,  22, 
 23,  24,  25,  26,  15,  16,  17,  18,  19,  20,  21, 
 22,  23,  24,  25,  26,  16,  17,  18,  19,  20,  21, 
 22,  23,  24,  25,  26,  16,  17,  18,  19,  20,  21, 
 22,  23,  24,  25,  26,  27,  16,  17,  18,  19,  20, 
 21,  22,  23,  24,  25,  26,  27,  17,  18,  19,  20, 
 21,  22,  23,  24,  25,  26,  27,  28,  17,  18,  19, 
 20,  21,  22,  23,  24,  25,  26,  27,  28,  18,  19, 
 20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  18, 
 19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29, 
 19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29, 
 30,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28, 
 29,  30,  20,  21,  22,  23,  24,  25,  26,  27,  28, 
 29,  30,  31,  20,  21,  22,  23,  24,  25,  26,  27, 
 28,  29,  30,  31,  21,  22,  23,  24,  25,  26,  27, 
 28,  29,  30,  31,  32,  21,  22,  23,  24,  25,  26, 
 27,  28,  29,  30,  31,  32,  22,  23,  24,  25,  26, 
 27,  28,  29,  30,  31,  32,  33,  22,  23,  24,  25, 
 26,  27,  28,  29,  30,  31,  32,  33,  23,  24,  25, 
 26,  27,  28,  29,  30,  31,  32,  33,  23,  24,  25, 
 26,  27,  28,  29,  30,  31,  32,  33,  24,  25,  26, 
 27,  28,  29,  30,  31,  32,  33,  24,  25,  26,  27, 
 28,  29,  30,  31,  32,  33,  34,  25,  26,  27,  28, 
 29,  30,  31,  32,  33,  34,  25,  26,  27,  28,  29, 
 30,  31,  32,  33,  34,  35,  26,  27,  28,  29,  30, 
 31,  32,  33,  34,  35,  26,  27,  28,  29,  30,  31, 
 32,  33,  34,  35,  36,  27,  28,  29,  30,  31,  32, 
 33,  34,  35,  36,  27,  28,  29,  30,  31,  32,  33, 
 34,  35,  36,  37,  27,  28,  29,  30,  31,  32,  33, 
 34,  35,  36,  37,  28,  29,  30,  31,  32,  33,  34, 
 35,  36,  37,  38,  28,  29,  30,  31,  32,  33,  34, 
 35,  36,  37,  38,  28,  29,  30,  31,  32,  33,  34, 
 35,  36,  37,  38,  28,  29,  30,  31,  32,  33,  34, 
 35,  36,  37,  38,  28,  29,  30,  31,  32,  33,  34, 
 35,  36,  37,  38,  39,  28,  29,  30,  31,  32,  33, 
 34,  35,  36,  37,  38,  39,  29,  30,  31,  32,  33, 
 34,  35,  36,  37,  38,  39,  40,  29,  30,  31,  32, 
 33,  34,  35,  36,  37,  38,  39,  40,  30,  31,  32, 
 33,  34,  35,  36,  37,  38,  39,  40,  41,  30,  31, 
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  31, 
 32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42, 
 31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41, 
 42,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41, 
 42,  43,  32,  33,  34,  35,  36,  37,  38,  39,  40, 
 41,  42,  43,  33,  34,  35,  36,  37,  38,  39,  40, 
 41,  42,  43,  44,  33,  34,  35,  36,  37,  38,  39, 
 40,  41,  42,  43,  44,  33,  34,  35,  36,  37,  38, 
 39,  40,  41,  42,  43,  44,  45,  34,  35,  36,  37, 
 38,  39,  40,  41,  42,  43,  44,  45,  34,  35,  36, 
 37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  34, 
 35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45, 
 46,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44, 
 45,  46,  35,  36,  37,  38,  39,  40,  41,  42,  43, 
 44,  45,  46,  47,  36,  37,  38,  39,  40,  41,  42, 
 43,  44,  45,  46,  47,  36,  37,  38,  39,  40,  41, 
 42,  43,  44,  45,  46,  47,  48,  36,  37,  38,  39, 
 40,  41,  42,  43,  44,  45,  46,  47,  48,  37,  38, 
 39,  40,  41,  42,  43,  44,  45,  46,  47,  48,  49, 
 37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47, 
 48,  49,  37,  38,  39,  40,  41,  42,  43,  44,  45, 
 46,  47,  48,  49,  50,  37,  38,  39,  40,  41,  42, 
 43,  44,  45,  46,  47,  48,  49,  50,  37,  38,  39, 
 40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50, 
 38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  48, 
 49,  50,  51,  38,  39,  40,  41,  42,  43,  44,  45, 
 46,  47,  48,  49,  50,  51,  39,  40,  41,  42,  43, 
 44,  45,  46,  47,  48,  49,  50,  51,  39,  40,  41, 
 42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52, 
 40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50, 
 51,  52,  40,  41,  42,  43,  44,  45,  46,  47,  48, 
 49,  50,  51,  52,  53,  41,  42,  43,  44,  45,  46, 
 47,  48,  49,  50,  51,  52,  53,  41,  42,  43,  44, 
 45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  42, 
 43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53, 
 54,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51, 
 52,  53,  54,  55,  42,  43,  44,  45,  46,  47,  48, 
 49,  50,  51,  52,  53,  54,  55,  43,  44,  45,  46, 
 47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  43, 
 44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54, 
 55,  56,  44,  45,  46,  47,  48,  49,  50,  51,  52, 
 53,  54,  55,  56,  44,  45,  46,  47,  48,  49,  50, 
 51,  52,  53,  54,  55,  56,  57,  44,  45,  46,  47, 
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  45, 
 46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56, 
 57,  58,  45,  46,  47,  48,  49,  50,  51,  52,  53, 
 54,  55,  56,  57,  58,  45,  46,  47,  48,  49,  50, 
 51,  52,  53,  54,  55,  56,  57,  58,  59,  46,  47, 
 48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58, 
 59,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  47,  48,  49,  50,  51,  52,  53, 
 54,  55,  56,  57,  58,  59,  47,  48,  49,  50,  51, 
 52,  53,  54,  55,  56,  57,  58,  59,  47,  48,  49, 
 50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60, 
 47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 
 58,  59,  60,  48,  49,  50,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  48,  49,  50,  51,  52, 
 53,  54,  55,  56,  57,  58,  59,  60,  61,  48,  49, 
 50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60, 
 61,  62,  49,  50,  51,  52,  53,  54,  55,  56,  57, 
 58,  59,  60,  61,  62,  49,  50,  51,  52,  53,  54, 
 55,  56,  57,  58,  59,  60,  61,  62,  63,  49,  50, 
 51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61, 
 62,  63,  49,  50,  51,  52,  53,  54,  55,  56,  57, 
 58,  59,  60,  61,  62,  63,  50,  51,  52,  53,  54, 
 55,  56,  57,  58,  59,  60,  61,  62,  63,  50,  51, 
 52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62, 
 63,  64,  50,  51,  52,  53,  54,  55,  56,  57,  58, 
 59,  60,  61,  62,  63,  64,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  51, 
 52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62, 
 63,  64,  65,  52,  53,  54,  55,  56,  57,  58,  59, 
 60,  61,  62,  63,  64,  65,  66,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66, 
 52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62, 
 63,  64,  65,  66,  67,  53,  54,  55,  56,  57,  58, 
 59,  60,  61,  62,  63,  64,  65,  66,  67,  53,  54, 
 55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65, 
 66,  67,  68,  54,  55,  56,  57,  58,  59,  60,  61, 
 62,  63,  64,  65,  66,  67,  68,  54,  55,  56,  57, 
 58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68, 
 69,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63, 
 64,  65,  66,  67,  68,  69,  55,  56,  57,  58,  59, 
 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70, 
 55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65, 
 66,  67,  68,  69,  70,  55,  56,  57,  58,  59,  60, 
 61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71, 
 55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65, 
 66,  67,  68,  69,  70,  71,  56,  57,  58,  59,  60, 
 61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71, 
 56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66, 
 67,  68,  69,  70,  71,  57,  58,  59,  60,  61,  62, 
 63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  57, 
 58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68, 
 69,  70,  71,  72,  58,  59,  60,  61,  62,  63,  64, 
 65,  66,  67,  68,  69,  70,  71,  72,  73,  58,  59, 
 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70, 
 71,  72,  73,  59,  60,  61,  62,  63,  64,  65,  66, 
 67,  68,  69,  70,  71,  72,  73,  74,  59,  60,  61, 
 62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72, 
 73,  74,  60,  61,  62,  63,  64,  65,  66,  67,  68, 
 69,  70,  71,  72,  73,  74,  75,  60,  61,  62,  63, 
 64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74, 
 75,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70, 
 71,  72,  73,  74,  75,  76,  61,  62,  63,  64,  65, 
 66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76, 
 62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72, 
 73,  74,  75,  76,  62,  63,  64,  65,  66,  67,  68, 
 69,  70,  71,  72,  73,  74,  75,  76,  77,  63,  64, 
 65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75, 
 76,  77,  63,  64,  65,  66,  67,  68,  69,  70,  71, 
 72,  73,  74,  75,  76,  77,  64,  65,  66,  67,  68, 
 69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  64, 
 65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75, 
 76,  77,  78,  65,  66,  67,  68,  69,  70,  71,  72, 
 73,  74,  75,  76,  77,  78,  65,  66,  67,  68,  69, 
 70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  66, 
 67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77, 
 78,  79,  66,  67,  68,  69,  70,  71,  72,  73,  74, 
 75,  76,  77,  78,  79,  67,  68,  69,  70,  71,  72, 
 73,  74,  75,  76,  77,  78,  79,  67,  68,  69,  70, 
 71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  68, 
 69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79, 
 80,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77, 
 78,  79,  80,  81,  69,  70,  71,  72,  73,  74,  75, 
 76,  77,  78,  79,  80,  81,  69,  70,  71,  72,  73, 
 74,  75,  76,  77,  78,  79,  80,  81,  70,  71,  72, 
 73,  74,  75,  76,  77,  78,  79,  80,  81,  70,  71, 
 72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82, 
 71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81, 
 82,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80, 
 81,  82,  71,  72,  73,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  72,  73,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  83,  72,  73,  74,  75,  76,  77,  78, 
 79,  80,  81,  82,  83,  73,  74,  75,  76,  77,  78, 
 79,  80,  81,  82,  83,  73,  74,  75,  76,  77,  78, 
 79,  80,  81,  82,  83,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  83,  74,  75,  76,  77,  78,  79,  80, 
 81,  82,  83,  84,  75,  76,  77,  78,  79,  80,  81, 
 82,  83,  84,  75,  76,  77,  78,  79,  80,  81,  82, 
 83,  84,  76,  77,  78,  79,  80,  81,  82,  83,  84, 
 85,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85, 
 76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  76, 
 77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  77, 
 78,  79,  80,  81,  82,  83,  84,  85,  86,  77,  78, 
 79,  80,  81,  82,  83,  84,  85,  86,  77,  78,  79, 
 80,  81,  82,  83,  84,  85,  86,  78,  79,  80,  81, 
 82,  83,  84,  85,  86,  87,  78,  79,  80,  81,  82, 
 83,  84,  85,  86,  87,  78,  79,  80,  81,  82,  83, 
 84,  85,  86,  87,  79,  80,  81,  82,  83,  84,  85, 
 86,  87,  88,  79,  80,  81,  82,  83,  84,  85,  86, 
 87,  88,  79,  80,  81,  82,  83,  84,  85,  86,  87, 
 88,  80,  81,  82,  83,  84,  85,  86,  87,  88,  80, 
 81,  82,  83,  84,  85,  86,  87,  88,  89,  80,  81, 
 82,  83,  84,  85,  86,  87,  88,  89,  81,  82,  83, 
 84,  85,  86,  87,  88,  89,  81,  82,  83,  84,  85, 
 86,  87,  88,  89,  90,  82,  83,  84,  85,  86,  87, 
 88,  89,  90,  82,  83,  84,  85,  86,  87,  88,  89, 
 90,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91, 
 82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  83, 
 84,  85,  86,  87,  88,  89,  90,  91,  83,  84,  85, 
 86,  87,  88,  89,  90,  91,  84,  85,  86,  87,  88, 
 89,  90,  91,  84,  85,  86,  87,  88,  89,  90,  91, 
 92,  85,  86,  87,  88,  89,  90,  91,  92,  85,  86, 
 87,  88,  89,  90,  91,  92,  85,  86,  87,  88,  89, 
 90,  91,  92,  85,  86,  87,  88,  89,  90,  91,  92, 
 85,  86,  87,  88,  89,  90,  91,  92,  86,  87,  88, 
 89,  90,  91,  92,  86,  87,  88,  89,  90,  91,  92, 
 93,  86,  87,  88,  89,  90,  91,  92,  93,  86,  87, 
 88,  89,  90,  91,  92,  93,  86,  87,  88,  89,  90, 
 91,  92,  93,  94,  87,  88,  89,  90,  91,  92,  93, 
 94,  87,  88,  89,  90,  91,  92,  93,  94,  87,  88, 
 89,  90,  91,  92,  93,  94,  95,  87,  88,  89,  90, 
 91,  92,  93,  94,  95,  88,  89,  90,  91,  92,  93, 
 94,  95,  96,  88,  89,  90,  91,  92,  93,  94,  95, 
 96,  89,  90,  91,  92,  93,  94,  95,  96,  97,  89, 
 90,  91,  92,  93,  94,  95,  96,  97,  90,  91,  92, 
 93,  94,  95,  96,  97,  98,  90,  91,  92,  93,  94, 
 95,  96,  97,  98,  91,  92,  93,  94,  95,  96,  97, 
 98,  91,  92,  93,  94,  95,  96,  97,  98,  99,  92, 
 93,  94,  95,  96,  97,  98,  99,  92,  93,  94,  95, 
 96,  97,  98,  99, 100,  93,  94,  95,  96,  97,  98, 
 99, 100,  93,  94,  95,  96,  97,  98,  99, 100,  94, 
 95,  96,  97,  98,  99, 100, 101,  94,  95,  96,  97, 
 98,  99, 100, 101,  94,  95,  96,  97,  98,  99, 100, 
101,  95,  96,  97,  98,  99, 100, 101,  95,  96,  97, 
 98,  99, 100, 101, 102,  96,  97,  98,  99, 100, 101, 
102,  96,  97,  98,  99, 100, 101, 102, 103,  96,  97, 
 98,  99, 100, 101, 102, 103,  97,  98,  99, 100, 101, 
102, 103, 104,  97,  98,  99, 100, 101, 102, 103, 104, 
 98,  99, 100, 101, 102, 103, 104, 105,  98,  99, 100, 
101, 102, 103, 104, 105,  99, 100, 101, 102, 103, 104, 
105, 100, 101, 102, 103, 104, 105, 106, 100, 101, 102, 
103, 104, 105, 106, 101, 102, 103, 104, 105, 106, 107, 
102, 103, 104, 105, 106, 107, 102, 103, 104, 105, 106, 
107, 103, 104, 105, 106, 107, 108, 104, 105, 106, 107, 
108, 105, 106, 107, 108, 109, 106, 107, 108, 109, 107, 
108, 109, 110, 108, 109, 110, 108, 109, 110, 109, 110, 
109, 110, 110, 111, 110
  },
  // --------- A -----------
  {
  1,   1,   2,   3,   3,   4,   4,   4,   5,   5,   5, 
  5,   6,   6,   6,   6,   7,   7,   7,   7,   8,   8, 
  8,   8,   8,   9,   9,   9,   9,   9,  10,  10,  10, 
 10,  10,  10,  11,  11,  11,  11,  11,  12,  12,  12, 
 12,  12,  12,  13,  13,  13,  13,  13,  14,  14,  14, 
 14,  14,  14,  15,  15,  15,  15,  15,  16,  16,  16, 
 16,  16,  16,  17,  17,  17,  17,  17,  17,  18,  18, 
 18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19, 
 19,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21, 
 21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22, 
 22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23, 
 24,  24,  24,  24,  24,  24,  24,  24,  24,  25,  25, 
 25,  25,  25,  25,  25,  25,  26,  26,  26,  26,  26, 
 26,  26,  26,  26,  27,  27,  27,  27,  27,  27,  27, 
 27,  28,  28,  28,  28,  28,  28,  28,  28,  28,  29, 
 29,  29,  29,  29,  29,  29,  29,  29,  30,  30,  30, 
 30,  30,  30,  30,  30,  30,  31,  31,  31,  31,  31, 
 31,  31,  31,  31,  32,  32,  32,  32,  32,  32,  32, 
 32,  32,  32,  33,  33,  33,  33,  33,  33,  33,  33, 
 33,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34, 
 35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  36, 
 36,  36,  36,  36,  36,  36,  36,  36,  36,  37,  37, 
 37,  37,  37,  37,  37,  37,  37,  37,  38,  38,  38, 
 38,  38,  38,  38,  38,  38,  38,  39,  39,  39,  39, 
 39,  39,  39,  39,  39,  39,  40,  40,  40,  40,  40, 
 40,  40,  40,  40,  40,  41,  41,  41,  41,  41,  41, 
 41,  41,  41,  41,  42,  42,  42,  42,  42,  42,  42, 
 42,  42,  42,  42,  43,  43,  43,  43,  43,  43,  43, 
 43,  43,  43,  44,  44,  44,  44,  44,  44,  44,  44, 
 44,  44,  44,  45,  45,  45,  45,  45,  45,  45,  45, 
 45,  45,  45,  45,  46,  46,  46,  46,  46,  46,  46, 
 46,  46,  46,  46,  46,  47,  47,  47,  47,  47,  47, 
 47,  47,  47,  47,  47,  48,  48,  48,  48,  48,  48, 
 48,  48,  48,  48,  48,  48,  49,  49,  49,  49,  49, 
 49,  49,  49,  49,  49,  49,  49,  50,  50,  50,  50, 
 50,  50,  50,  50,  50,  50,  50,  50,  51,  51,  51, 
 51,  51,  51,  51,  51,  51,  51,  51,  51,  52,  52, 
 52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  53, 
 53,  53,  53,  53,  53,  53,  53,  53,  53,  53,  53, 
 54,  54,  54,  54,  54,  54,  54,  54,  54,  54,  54, 
 54,  55,  55,  55,  55,  55,  55,  55,  55,  55,  55, 
 55,  55,  56,  56,  56,  56,  56,  56,  56,  56,  56, 
 56,  56,  56,  57,  57,  57,  57,  57,  57,  57,  57, 
 57,  57,  57,  57,  58,  58,  58,  58,  58,  58,  58, 
 58,  58,  58,  58,  58,  59,  59,  59,  59,  59,  59, 
 59,  59,  59,  59,  59,  59,  60,  60,  60,  60,  60, 
 60,  60,  60,  60,  60,  60,  60,  61,  61,  61,  61, 
 61,  61,  61,  61,  61,  61,  61,  61,  62,  62,  62, 
 62,  62,  62,  62,  62,  62,  62,  62,  63,  63,  63, 
 63,  63,  63,  63,  63,  63,  63,  63,  64,  64,  64, 
 64,  64,  64,  64,  64,  64,  64,  65,  65,  65,  65, 
 65,  65,  65,  65,  65,  65,  65,  66,  66,  66,  66, 
 66,  66,  66,  66,  66,  66,  67,  67,  67,  67,  67, 
 67,  67,  67,  67,  67,  67,  68,  68,  68,  68,  68, 
 68,  68,  68,  68,  68,  69,  69,  69,  69,  69,  69, 
 69,  69,  69,  69,  69,  70,  70,  70,  70,  70,  70, 
 70,  70,  70,  70,  71,  71,  71,  71,  71,  71,  71, 
 71,  71,  71,  71,  72,  72,  72,  72,  72,  72,  72, 
 72,  72,  72,  72,  73,  73,  73,  73,  73,  73,  73, 
 73,  73,  73,  73,  74,  74,  74,  74,  74,  74,  74, 
 74,  74,  74,  74,  75,  75,  75,  75,  75,  75,  75, 
 75,  75,  75,  75,  76,  76,  76,  76,  76,  76,  76, 
 76,  76,  76,  76,  77,  77,  77,  77,  77,  77,  77, 
 77,  77,  77,  77,  77,  78,  78,  78,  78,  78,  78, 
 78,  78,  78,  78,  78,  78,  79,  79,  79,  79,  79, 
 79,  79,  79,  79,  79,  79,  79,  80,  80,  80,  80, 
 80,  80,  80,  80,  80,  80,  80,  80,  81,  81,  81, 
 81,  81,  81,  81,  81,  81,  81,  81,  81,  82,  82, 
 82,  82,  82,  82,  82,  82,  82,  82,  82,  82,  83, 
 83,  83,  83,  83,  83,  83,  83,  83,  83,  83,  83, 
 84,  84,  84,  84,  84,  84,  84,  84,  84,  84,  84, 
 84,  85,  85,  85,  85,  85,  85,  85,  85,  85,  85, 
 85,  85,  86,  86,  86,  86,  86,  86,  86,  86,  86, 
 86,  86,  86,  87,  87,  87,  87,  87,  87,  87,  87, 
 87,  87,  87,  87,  88,  88,  88,  88,  88,  88,  88, 
 88,  88,  88,  88,  88,  89,  89,  89,  89,  89,  89, 
 89,  89,  89,  89,  89,  89,  89,  90,  90,  90,  90, 
 90,  90,  90,  90,  90,  90,  90,  90,  91,  91,  91, 
 91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  92, 
 92,  92,  92,  92,  92,  92,  92,  92,  92,  92,  92, 
 92,  93,  93,  93,  93,  93,  93,  93,  93,  93,  93, 
 93,  93,  94,  94,  94,  94,  94,  94,  94,  94,  94, 
 94,  94,  94,  94,  95,  95,  95,  95,  95,  95,  95, 
 95,  95,  95,  95,  95,  96,  96,  96,  96,  96,  96, 
 96,  96,  96,  96,  96,  96,  96,  97,  97,  97,  97, 
 97,  97,  97,  97,  97,  97,  97,  97,  97,  98,  98, 
 98,  98,  98,  98,  98,  98,  98,  98,  98,  98,  98, 
 99,  99,  99,  99,  99,  99,  99,  99,  99,  99,  99, 
 99,  99, 100, 100, 100, 100, 100, 100, 100, 100, 100, 
100, 100, 100, 100, 100, 101, 101, 101, 101, 101, 101, 
101, 101, 101, 101, 101, 101, 101, 101, 102, 102, 102, 
102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 
103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 
103, 103, 103, 104, 104, 104, 104, 104, 104, 104, 104, 
104, 104, 104, 104, 104, 104, 105, 105, 105, 105, 105, 
105, 105, 105, 105, 105, 105, 105, 105, 106, 106, 106, 
106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 
107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 
107, 107, 108, 108, 108, 108, 108, 108, 108, 108, 108, 
108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 
109, 109, 109, 109, 109, 109, 109, 110, 110, 110, 110, 
110, 110, 110, 110, 110, 110, 110, 110, 110, 110, 111, 
111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 111, 
111, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 
112, 112, 112, 112, 113, 113, 113, 113, 113, 113, 113, 
113, 113, 113, 113, 113, 113, 113, 114, 114, 114, 114, 
114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 115, 
115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 
115, 115, 116, 116, 116, 116, 116, 116, 116, 116, 116, 
116, 116, 116, 116, 117, 117, 117, 117, 117, 117, 117, 
117, 117, 117, 117, 117, 117, 117, 118, 118, 118, 118, 
118, 118, 118, 118, 118, 118, 118, 118, 118, 118, 119, 
119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 
119, 119, 120, 120, 120, 120, 120, 120, 120, 120, 120, 
120, 120, 120, 120, 120, 121, 121, 121, 121, 121, 121, 
121, 121, 121, 121, 121, 121, 121, 121, 121, 122, 122, 
122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 
122, 123, 123, 123, 123, 123, 123, 123, 123, 123, 123, 
123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 
124, 124, 124, 124, 124, 124, 125, 125, 125, 125, 125, 
125, 125, 125, 125, 125, 125, 125, 125, 126, 126, 126, 
126, 126, 126, 126, 126, 126, 126, 126, 126, 126, 126, 
127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 
127, 127, 127, 128, 128, 128, 128, 128, 128, 128, 128, 
128, 128, 128, 128, 128, 128, 129, 129, 129, 129, 129, 
129, 129, 129, 129, 129, 129, 129, 129, 129, 130, 130, 
130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 
130, 130, 131, 131, 131, 131, 131, 131, 131, 131, 131, 
131, 131, 131, 131, 131, 132, 132, 132, 132, 132, 132, 
132, 132, 132, 132, 132, 132, 132, 132, 132, 133, 133, 
133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 133, 
133, 133, 134, 134, 134, 134, 134, 134, 134, 134, 134, 
134, 134, 134, 134, 134, 134, 135, 135, 135, 135, 135, 
135, 135, 135, 135, 135, 135, 135, 135, 135, 136, 136, 
136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 
136, 136, 137, 137, 137, 137, 137, 137, 137, 137, 137, 
137, 137, 137, 137, 137, 137, 138, 138, 138, 138, 138, 
138, 138, 138, 138, 138, 138, 138, 138, 138, 138, 139, 
139, 139, 139, 139, 139, 139, 139, 139, 139, 139, 139, 
139, 139, 139, 140, 140, 140, 140, 140, 140, 140, 140, 
140, 140, 140, 140, 140, 140, 140, 141, 141, 141, 141, 
141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 
142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 142, 
142, 142, 142, 142, 142, 143, 143, 143, 143, 143, 143, 
143, 143, 143, 143, 143, 143, 143, 143, 143, 144, 144, 
144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 
144, 144, 144, 145, 145, 145, 145, 145, 145, 145, 145, 
145, 145, 145, 145, 145, 145, 145, 146, 146, 146, 146, 
146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 
146, 147, 147, 147, 147, 147, 147, 147, 147, 147, 147, 
147, 147, 147, 147, 147, 147, 148, 148, 148, 148, 148, 
148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 148, 
149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 149, 
149, 149, 149, 149, 149, 150, 150, 150, 150, 150, 150, 
150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 
151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 151, 
151, 151, 151, 151, 151, 151, 152, 152, 152, 152, 152, 
152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 152, 
153, 153, 153, 153, 153, 153, 153, 153, 153, 153, 153, 
153, 153, 153, 153, 153, 154, 154, 154, 154, 154, 154, 
154, 154, 154, 154, 154, 154, 154, 154, 154, 154, 155, 
155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 155, 
155, 155, 155, 155, 156, 156, 156, 156, 156, 156, 156, 
156, 156, 156, 156, 156, 156, 156, 156, 156, 157, 157, 
157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 157, 
157, 157, 157, 158, 158, 158, 158, 158, 158, 158, 158, 
158, 158, 158, 158, 158, 158, 158, 158, 159, 159, 159, 
159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 
159, 159, 160, 160, 160, 160, 160, 160, 160, 160, 160, 
160, 160, 160, 160, 160, 160, 160, 161, 161, 161, 161, 
161, 161, 161, 161, 161, 161, 161, 161, 161, 161, 161, 
161, 162, 162, 162, 162, 162, 162, 162, 162, 162, 162, 
162, 162, 162, 162, 162, 162, 163, 163, 163, 163, 163, 
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 
164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 164, 
164, 164, 164, 164, 165, 165, 165, 165, 165, 165, 165, 
165, 165, 165, 165, 165, 165, 165, 165, 165, 166, 166, 
166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 166, 
166, 166, 167, 167, 167, 167, 167, 167, 167, 167, 167, 
167, 167, 167, 167, 167, 167, 168, 168, 168, 168, 168, 
168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 169, 
169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 169, 
169, 169, 169, 170, 170, 170, 170, 170, 170, 170, 170, 
170, 170, 170, 170, 170, 170, 171, 171, 171, 171, 171, 
171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 172, 
172, 172, 172, 172, 172, 172, 172, 172, 172, 172, 172, 
172, 172, 173, 173, 173, 173, 173, 173, 173, 173, 173, 
173, 173, 173, 173, 173, 174, 174, 174, 174, 174, 174, 
174, 174, 174, 174, 174, 174, 174, 175, 175, 175, 175, 
175, 175, 175, 175, 175, 175, 175, 175, 175, 175, 176, 
176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 176, 
176, 177, 177, 177, 177, 177, 177, 177, 177, 177, 177, 
177, 177, 177, 177, 178, 178, 178, 178, 178, 178, 178, 
178, 178, 178, 178, 178, 178, 179, 179, 179, 179, 179, 
179, 179, 179, 179, 179, 179, 179, 179, 180, 180, 180, 
180, 180, 180, 180, 180, 180, 180, 180, 180, 181, 181, 
181, 181, 181, 181, 181, 181, 181, 181, 181, 181, 181, 
182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 182, 
182, 183, 183, 183, 183, 183, 183, 183, 183, 183, 183, 
183, 183, 184, 184, 184, 184, 184, 184, 184, 184, 184, 
184, 184, 184, 185, 185, 185, 185, 185, 185, 185, 185, 
185, 185, 185, 185, 186, 186, 186, 186, 186, 186, 186, 
186, 186, 186, 186, 186, 187, 187, 187, 187, 187, 187, 
187, 187, 187, 187, 187, 188, 188, 188, 188, 188, 188, 
188, 188, 188, 188, 188, 189, 189, 189, 189, 189, 189, 
189, 189, 189, 189, 190, 190, 190, 190, 190, 190, 190, 
190, 190, 190, 190, 191, 191, 191, 191, 191, 191, 191, 
191, 191, 191, 192, 192, 192, 192, 192, 192, 192, 192, 
192, 192, 193, 193, 193, 193, 193, 193, 193, 193, 193, 
193, 194, 194, 194, 194, 194, 194, 194, 194, 194, 194, 
195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 196, 
196, 196, 196, 196, 196, 196, 196, 196, 196, 196, 197, 
197, 197, 197, 197, 197, 197, 197, 197, 197, 198, 198, 
198, 198, 198, 198, 198, 198, 198, 198, 199, 199, 199, 
199, 199, 199, 199, 199, 199, 199, 200, 200, 200, 200, 
200, 200, 200, 200, 200, 200, 201, 201, 201, 201, 201, 
201, 201, 201, 201, 201, 202, 202, 202, 202, 202, 202, 
202, 202, 202, 202, 203, 203, 203, 203, 203, 203, 203, 
203, 203, 203, 204, 204, 204, 204, 204, 204, 204, 204, 
204, 204, 205, 205, 205, 205, 205, 205, 205, 205, 205, 
205, 206, 206, 206, 206, 206, 206, 206, 206, 206, 207, 
207, 207, 207, 207, 207, 207, 207, 207, 207, 208, 208, 
208, 208, 208, 208, 208, 208, 208, 208, 209, 209, 209, 
209, 209, 209, 209, 209, 209, 210, 210, 210, 210, 210, 
210, 210, 210, 210, 210, 211, 211, 211, 211, 211, 211, 
211, 211, 211, 212, 212, 212, 212, 212, 212, 212, 212, 
212, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 
214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 215, 
215, 215, 215, 215, 215, 215, 215, 215, 216, 216, 216, 
216, 216, 216, 216, 216, 216, 217, 217, 217, 217, 217, 
217, 217, 217, 218, 218, 218, 218, 218, 218, 218, 218, 
218, 219, 219, 219, 219, 219, 219, 219, 219, 220, 220, 
220, 220, 220, 220, 220, 220, 221, 221, 221, 221, 221, 
221, 221, 221, 222, 222, 222, 222, 222, 222, 222, 222, 
223, 223, 223, 223, 223, 223, 223, 223, 224, 224, 224, 
224, 224, 224, 224, 225, 225, 225, 225, 225, 225, 225, 
225, 226, 226, 226, 226, 226, 226, 226, 226, 227, 227, 
227, 227, 227, 227, 227, 227, 228, 228, 228, 228, 228, 
228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 229, 
229, 230, 230, 230, 230, 230, 230, 230, 230, 231, 231, 
231, 231, 231, 231, 231, 231, 231, 232, 232, 232, 232, 
232, 232, 232, 232, 232, 233, 233, 233, 233, 233, 233, 
233, 233, 233, 234, 234, 234, 234, 234, 234, 234, 234, 
234, 235, 235, 235, 235, 235, 235, 235, 235, 235, 236, 
236, 236, 236, 236, 236, 236, 236, 236, 237, 237, 237, 
237, 237, 237, 237, 237, 237, 238, 238, 238, 238, 238, 
238, 238, 238, 238, 239, 239, 239, 239, 239, 239, 239, 
239, 240, 240, 240, 240, 240, 240, 240, 240, 240, 241, 
241, 241, 241, 241, 241, 241, 241, 242, 242, 242, 242, 
242, 242, 242, 242, 242, 243, 243, 243, 243, 243, 243, 
243, 243, 244, 244, 244, 244, 244, 244, 244, 244, 245, 
245, 245, 245, 245, 245, 245, 245, 246, 246, 246, 246, 
246, 246, 246, 246, 247, 247, 247, 247, 247, 247, 247, 
247, 248, 248, 248, 248, 248, 248, 248, 249, 249, 249, 
249, 249, 249, 249, 249, 250, 250, 250, 250, 250, 250, 
250, 251, 251, 251, 251, 251, 251, 251, 251, 252, 252, 
252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 
253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 
255, 255, 255, 255, 255, 255, 255, 255, 256, 256, 256, 
256, 256, 256, 256, 256, 257, 257, 257, 257, 257, 257, 
257, 258, 258, 258, 258, 258, 258, 258, 259, 259, 259, 
259, 259, 259, 259, 260, 260, 260, 260, 260, 260, 260, 
261, 261, 261, 261, 261, 261, 262, 262, 262, 262, 262, 
262, 263, 263, 263, 263, 263, 263, 264, 264, 264, 264, 
264, 265, 265, 265, 265, 265, 266, 266, 266, 266, 267, 
267, 267, 267, 268, 268, 268, 269, 269, 269, 270, 270, 
271, 271, 272, 272, 273
  }
};




//+----------------------+
//| Table of Mass Excess |
//+----------------------+
// unit: keV
G4double G4NucleiPropertiesTable::MassExcess[G4NucleiPropertiesTable::nEntries] = {
   8071.323,   7288.969,  13135.720,  14949.794,  14931.204,  25927.784,   2424.911,  25320.173,  36833.979,  11386.234,  11678.880,
  37996.000,  41863.763,  17594.123,  14086.312,  18374.465,  26110.264,  14907.673,  15769.489,  27867.864,  31597.983,  20946.195,
   4941.662,  22921.002,  35094.056,  40818.362,  24953.903,  11347.584,  12415.701,  28913.650,  48810.011,  33050.226,  12606.577,
  12050.761,  15698.568,  39699.000,  40795.860,  20173.970,   8667.984,  10650.531,  24960.520,  50096.000,  25076.402,  13368.901,
      0.0  ,  17338.083,  32047.838,  33658.445,  16562.209,   3125.011,   5345.456,  23110.735,  39882.396,  23663.730,   3019.892,
   2863.417,   8006.456,  33608.000,  28966.936,   9873.143,    101.438,   2855.388,  16777.001,  37081.686,  13694.117,   5683.432,
  -4736.998,  10680.257,  23992.401,  43716.310,  21036.589,   7870.819,   -809.002,   1951.701,  16485.173,  52322.000,  24924.036,
  13117.136,   -782.064,    873.431,   5306.782,  25318.000,  59364.000,  32833.383,  15860.449,   3333.565,  -1487.405,   1751.059,
  12928.622,  37560.063,  21766.492,   3796.909,    -17.396,  -7041.930,   6844.859,  17570.530,  45960.000,  25231.909,   8061.736,
    -47.580,  -5731.720,  -2184.261,  10911.681,  26119.000,  52583.000,  32080.890,   9284.346,   2793.783,  -8024.344,  -5182.104,
   -396.766,  18183.000,  32164.000,  37735.000,  14616.373,   3329.518,  -5153.641,  -9529.485,  -5472.666,   6767.210,  23772.000,
  47040.000,  18974.457,   7544.514,  -5947.519,  -8417.601, -13933.381,    -55.041,  10754.759,  31997.000,  27144.000,  11266.384,
  -2058.696,  -9357.459, -13192.726,  -8915.742,   3825.310,  18872.000,  35164.000,  18288.165,    429.882,  -6902.465, -16214.476,
 -12210.339,  -7144.618,  10973.000,  25970.000,  25050.028,   7093.512,  -5580.857, -14586.503, -17196.829, -12384.431,   -752.978,
  17507.000,  33226.000,  11278.595,  -1033.576, -15018.752, -16850.552, -21492.793,  -7161.018,   4073.107,  26557.000,  40296.000,
  18020.589,   2618.710, -10661.187, -18215.504, -21895.025, -16951.907,  -3158.878,  13143.000,  22236.621,   8594.416,  -8882.233,
 -15872.372, -24432.881, -20200.556, -14062.806,   4443.000,  20083.000,  30842.000,  12663.760,  -3215.089, -14954.181, -22948.958,
 -24440.991, -19044.932,  -7064.436,  11296.000,  37176.000,  18303.661,   -795.599, -11062.068, -24080.859, -24305.318, -26015.981,
 -13330.694,  -2179.081,  20418.000,  25509.891,   5204.233,  -8504.923, -20492.381, -26337.727, -26586.235, -21003.512,  -9381.336,
   6763.000,  32509.000,   8450.922,  -2862.243, -19956.562, -24557.549, -29931.850, -24440.566, -18378.264,  -1481.000,  13153.000,
  41153.000,  16292.000,    -58.079, -14359.762, -24857.613, -28846.371, -29013.512, -23048.208, -11167.107,   4439.000,  20912.000,
   5916.384, -12400.639, -20250.840, -30663.958, -29521.886, -30230.439, -17425.078,  -6439.199,  13898.000,  29100.000,   9603.702,
  -6524.192, -18994.708, -26896.218, -31761.519, -30948.034, -24799.240, -13160.607,   2841.000,  15742.000,  -3744.605, -14466.100,
 -26861.076, -29797.976, -34714.763, -28801.691, -22059.044,  -4937.000,   9101.000,  20400.000,   2142.000, -12649.687, -23161.339,
 -29800.652, -33241.836, -33806.836, -27276.256, -14168.014,   1232.000,   5403.000,  -8336.870, -22849.544, -27557.728, -35039.890,
 -33535.016, -34846.110, -20526.386,  -8850.210,  10330.000,  11830.000,  -4843.768, -18601.932, -27339.148, -33067.261, -35558.872,
 -35137.487, -28642.211, -15713.000,   -242.000,  14997.000,     84.000, -17241.951, -24987.328, -34422.065, -35021.319, -38546.765,
 -32120.925, -25120.878,  -8169.000,   5990.000,   3083.000, -12482.018, -24029.389, -31977.531, -36593.042, -38408.442, -36187.623,
 -29320.314, -18024.000,  -2136.000,   9203.000, -10880.000, -19991.058, -32262.039, -35810.214, -41469.087, -37815.811, -37548.299,
 -23846.000, -13535.000,   6399.000,  14103.000,  -4825.000, -18909.325, -29719.331, -36608.028, -40812.530, -41069.338, -39006.912,
 -31873.591, -19412.000,  -5114.000,  13563.000,  22197.000,   -401.000, -14792.000, -29720.739, -35418.933, -43134.911, -41758.637,
 -44125.338, -37073.929, -29470.929, -12370.000,    755.000,   7098.000, -11225.000, -25908.348, -35696.887, -42339.694, -44331.631,
 -44931.732, -42003.929, -34552.357, -22263.000,  -6623.000,  12100.000,  -4797.000, -23222.000, -32124.479, -44214.742, -44492.812,
 -48487.000, -44474.659, -42815.313, -28997.000, -18108.000,   1639.000,  20502.000,   -102.000, -16599.000, -30320.047, -41290.047,
 -46552.277, -48558.040, -47956.179, -45325.434, -37610.541, -24582.000,  -9576.000,   7200.000, -13097.000, -25352.625, -39571.456,
 -44537.508, -51425.849, -49217.535, -50254.460, -42621.470, -34471.499, -17195.000,  -3791.000,  12603.000,  -6297.000, -22002.000,
 -35886.511, -43218.800, -49726.852, -52197.493, -51444.760, -48236.956, -40217.307, -27274.000, -11439.000,  -1705.000, -16199.000,
 -32509.136, -40380.259, -49464.024, -51437.409, -55412.797, -50701.137, -48329.137, -33916.000, -22654.000,  -2627.000,   5800.000,
 -11998.000, -27898.000, -37968.000, -46824.604, -51844.604, -55280.638, -54683.625, -50941.273, -42639.145, -29379.000, -13460.000,
  -5598.000, -23585.000, -34465.273, -45764.293, -49886.730, -56928.321, -55551.269, -56248.410, -48005.330, -39206.103, -21694.000,
  -6567.000,   -570.000, -18118.000, -30339.000, -41805.444, -49147.298, -55103.298, -57706.384, -57475.007, -54023.711, -45329.911,
 -31624.000, -14923.000, -13237.000, -25467.000, -39132.057, -46239.355, -55288.596, -56905.551, -60601.003, -56035.003, -53899.645,
 -38601.000, -25728.000,  -4741.000,  -7120.000, -21387.000, -34558.000, -44376.367, -52392.990, -57484.854, -60175.708, -59339.666,
 -56075.475, -47305.268, -32686.000, -15901.000, -15770.000, -31568.000, -40380.259, -51930.783, -55902.253, -62148.844, -59841.428,
 -60223.014, -51659.966, -42293.114, -23986.000,  -8374.000, -11140.000, -26119.000, -37911.800, -47850.840, -55473.100, -60658.421,
 -62223.609, -61151.125, -56351.547, -47257.409, -34121.000, -17000.000, -22691.000, -33068.032, -46826.196, -52914.442, -61406.923,
 -61644.218, -64468.100, -58341.209, -54183.106, -39998.000, -27768.000,  -6399.000, -16750.000, -30357.000, -42764.883, -51735.169,
 -58917.489, -62895.042, -64216.775, -61979.570, -56342.425, -47348.000, -33729.000, -18052.000, -25020.000, -41172.029, -48465.626,
 -58897.896, -61428.097, -66742.688, -62794.517, -61167.353, -51996.353, -42243.000, -24964.000, -21657.000, -35527.000, -46751.677,
 -55779.304, -61837.017, -65509.217, -65576.162, -62209.293, -56689.293, -46910.000, -33823.000, -33347.000, -43100.221, -55079.232,
 -59789.309, -67095.900, -65420.802, -65999.528, -58834.729, -54424.729, -39521.000, -27600.000, -40892.580, -51288.052, -59164.222,
 -65122.587, -67259.719, -65907.775, -62652.909, -56410.559, -47056.000, -32919.000, -36496.000, -50319.298, -56052.259, -66028.726,
 -66254.326, -68896.301, -63721.301, -61621.301, -51821.000, -41722.000, -33701.000, -46574.693, -55321.420, -63742.462, -67300.158,
 -67877.158, -66876.681, -62653.753, -56643.753, -46491.000, -32798.000, -44237.000, -51828.318, -63486.027, -65541.887, -70004.030,
 -67082.930, -66976.955, -58876.955, -54148.000, -38892.000, -39402.000, -51045.864, -60377.721, -65739.917, -68414.928, -69320.923,
 -67093.638, -63080.621, -56297.481, -46409.000, -32304.000, -46752.000, -59485.198, -62960.334, -69559.425, -68904.705, -70560.320,
 -64340.320, -61940.000, -51590.000, -40976.000, -44963.000, -55889.632, -62764.225, -67321.674, -70136.821, -69904.897, -67892.187,
 -63092.000, -56592.000, -46100.000, -32304.000, -40604.000, -54678.690, -60063.000, -68128.416, -68586.498, -72585.557, -68229.459,
 -67894.432, -59152.770, -54112.770, -38117.000, -50226.000, -59159.000, -65409.994, -69703.842, -71297.136, -70956.276, -68216.276,
 -63532.642, -56885.291, -46234.000, -31699.000, -48522.000, -55703.000, -65709.197, -68054.011, -73422.011, -70859.599, -72212.607,
 -65305.961, -62169.554, -51725.504, -40697.000, -43808.000, -54306.000, -62468.419, -68464.198, -71855.908, -73032.457, -72168.818,
 -69138.818, -64241.597, -57222.414, -46649.000, -41610.000, -50310.000, -62042.888, -66202.888, -73212.888, -72289.575, -75251.563,
 -70288.688, -68978.700, -60480.547, -54390.000, -36487.000, -48484.000, -58604.138, -65874.138, -71214.138, -73916.177, -74599.049,
 -73233.933, -70171.407, -64825.826, -57974.770, -46929.000, -33720.000, -43957.000, -57222.063, -63662.063, -71862.063, -72816.201,
 -77025.673, -73451.896, -74159.700, -66935.766, -63174.508, -52629.000, -41656.000, -53398.000, -62487.989, -69487.989, -73635.989,
 -75916.934, -76067.980, -74442.202, -70796.589, -65477.427, -58357.427, -47357.000, -35499.000, -51777.345, -59067.745, -69447.745,
 -72117.967, -77759.404, -75888.849, -77893.342, -72172.776, -70304.883, -61165.000, -55377.000, -46128.000, -57982.741, -66302.741,
 -72532.741, -76389.081, -77974.363, -77693.650, -75456.438, -71526.530, -66016.164, -58856.164, -47460.000, -42066.000, -52946.000,
 -65623.439, -70323.439, -77593.439, -77495.943, -80588.563, -76189.034, -76008.727, -68192.736, -64192.736, -52974.000, -49490.000,
 -61004.000, -69880.088, -75340.088, -79009.106, -79981.833, -79072.696, -76796.985, -72328.103, -66460.103, -58960.103, -47748.000,
 -44395.000, -58395.000, -66080.000, -75949.796, -77776.304, -82431.033, -79750.149, -80644.288, -74158.306, -71492.000, -61879.000,
 -55806.000, -53384.000, -63519.000, -72428.605, -78610.605, -81480.605, -82167.687, -81102.665, -77847.665, -73154.665, -67154.665,
 -59066.000, -47562.000, -50049.000, -59401.000, -70540.945, -75639.945, -83265.945, -82747.319, -84521.563, -79281.563, -77805.027,
 -69827.027, -64557.027, -53207.000, -56281.000, -66582.484, -73857.484, -80709.984, -84595.045, -84878.358, -83016.752, -79347.835,
 -74182.835, -67694.611, -59122.000, -47339.000, -51642.000, -63878.140, -70732.140, -79692.140, -82606.221, -87919.663, -84297.063,
 -83623.763, -76424.000, -72700.555, -62568.000, -55498.000, -47292.000, -59597.000, -68569.815, -76724.815, -81710.698, -86207.050,
 -87702.101, -84869.416, -80578.408, -75003.363, -67493.363, -59513.000, -47152.000, -56430.000, -64613.083, -74963.083, -79354.948,
 -85941.863, -86487.861, -88767.938, -82656.938, -80167.938, -71207.275, -65409.000, -53216.000, -50888.000, -61510.918, -71312.918,
 -77747.918, -83638.978, -86346.300, -87891.133, -86637.743, -82203.631, -75983.631, -68578.969, -59103.000, -47059.000, -47199.000,
 -56583.354, -68788.258, -74775.258, -82875.106, -84815.467, -88454.559, -86448.952, -86805.466, -78935.111, -74408.000, -63360.000,
 -55498.000, -53002.000, -64026.001, -72626.001, -80087.598, -84224.201, -87117.379, -87208.744, -86803.852, -83602.997, -77265.997,
 -69173.000, -59699.000, -47804.000, -61141.000, -68551.124, -78841.774, -82349.639, -87266.289, -86364.891, -88410.338, -84154.593,
 -82568.017, -72938.000, -66350.000, -53300.000, -56039.000, -65838.676, -75117.330, -81204.179, -85657.624, -86782.460, -87708.077,
 -86017.446, -83449.993, -78339.993, -70151.000, -60100.000, -53030.000, -61214.086, -72954.158, -78340.695, -85440.646, -85604.215,
 -88791.015, -85817.781, -86072.192, -79625.760, -76175.760, -64571.000, -56104.000, -47916.000, -58364.738, -68791.979, -76260.455,
 -82948.861, -85606.946, -87540.831, -87220.574, -86112.372, -82589.372, -77799.372, -70794.000, -60603.000, -54302.779, -66628.659,
 -72452.035, -81276.224, -83526.412, -88112.011, -86428.013, -88224.474, -83167.096, -81300.084, -72880.084, -67460.000, -53803.000,
 -50840.361, -62116.633, -70202.280, -77769.413, -82327.417, -85966.080, -87323.307, -87616.958, -85574.384, -82187.793, -76757.793,
 -69853.000, -60910.000, -46696.000, -60219.468, -67294.468, -76604.468, -79939.468, -86184.468, -86016.384, -89218.795, -85588.795,
 -85227.407, -78180.851, -74305.049, -64134.253, -56864.000, -43597.645, -55407.645, -64912.645, -73457.645, -78942.645, -83511.645,
 -86336.086, -87949.584, -87408.099, -85428.099, -81224.275, -75747.738, -68409.000, -59560.000, -37996.000, -53077.643, -61892.643,
 -71742.643, -76347.643, -83557.643, -84567.591, -89097.851, -86775.318, -87925.833, -81971.463, -79384.463, -70134.463, -64748.000,
 -47553.000, -58740.000, -68374.386, -75319.386, -80849.386, -84599.386, -87258.919, -88022.274, -87479.193, -84791.601, -80649.714,
 -74599.714, -66946.000, -55778.000, -44404.000, -54539.000, -66341.000, -72228.533, -80333.533, -82488.533, -88091.239, -86950.001,
 -89390.890, -85112.244, -83975.950, -76067.264, -71552.264, -59348.000, -51148.000, -62364.000, -70854.991, -77339.991, -82289.991,
 -85929.991, -87846.909, -88413.628, -87068.376, -84330.172, -79481.172, -73224.351, -63780.695, -46370.000, -59699.000, -66891.000,
 -76257.412, -79777.412, -86324.412, -86363.812, -89904.912, -86939.647, -87133.792, -80610.422, -77425.330, -66357.000, -58030.000,
 -55089.000, -64916.000, -72940.884, -79100.884, -83920.884, -86861.300, -88372.264, -88405.269, -86988.269, -83562.269, -78555.949,
 -70654.000, -60513.000, -51903.000, -60538.000, -71185.000, -75935.404, -83655.404, -85016.729, -89521.729, -87603.546, -89252.572,
 -84095.561, -82003.746, -72507.000, -65682.577, -52824.000, -58097.000, -67245.000, -74867.000, -80852.209, -85012.209, -87603.705,
 -88719.654, -88505.359, -86485.406, -82635.728, -76255.728, -67573.840, -57574.091, -53393.000, -65456.000, -71362.000, -80139.971,
 -82949.971, -88349.971, -87457.530, -90349.708, -86471.708, -85834.656, -77535.000, -72277.250, -60348.000, -51721.000, -61004.000,
 -69815.000, -76792.000, -82288.000, -86029.092, -88217.425, -89254.225, -88388.821, -85943.905, -80844.000, -73475.687, -64947.000,
 -54369.000, -58833.000, -65913.000, -75867.000, -79537.000, -86337.113, -86625.080, -90581.047, -87995.116, -88658.831, -81603.855,
 -77256.594, -67096.000, -59927.331, -46266.000, -53999.000, -63966.000, -72154.000, -78786.000, -83693.469, -87033.469, -89049.931,
 -89366.381, -88330.421, -84413.891, -78314.000, -71124.917, -62053.479, -51664.830, -59727.000, -70794.000, -75594.000, -83494.153,
 -84944.875, -90021.317, -88569.457, -90558.142, -84676.634, -81919.000, -72796.000, -66932.000, -54566.000, -45698.000, -57492.000,
 -66779.000, -74403.374, -80403.374, -84987.374, -88090.859, -89536.747, -90032.633, -87002.633, -82363.966, -76459.000, -68430.000,
 -59672.000, -48708.000, -65056.000, -71061.000, -79961.027, -82568.027, -88719.729, -88249.733, -91524.722, -86817.803, -85305.972,
 -77560.823, -72901.000, -62490.055, -54325.000, -60743.000, -69536.000, -76532.000, -82265.638, -86425.638, -88943.010, -90397.972,
 -88641.338, -85106.700, -80436.645, -73993.816, -66471.883, -56952.000, -46565.000, -58656.000, -65736.000, -75465.986, -79565.986,
 -86708.904, -87230.094, -91653.102, -87996.470, -87723.260, -80690.442, -77713.676, -68413.676, -62000.000, -49770.000, -63938.000,
 -72023.000, -78556.562, -83906.562, -87703.562, -90067.185, -89473.283, -87180.271, -83665.999, -78660.656, -72311.049, -64224.707,
 -54967.000, -44004.000, -59821.000, -70766.000, -75647.912, -83972.912, -85733.293, -91103.293, -88422.693, -89404.882, -83789.882,
 -81829.882, -73887.752, -68887.752, -57687.000, -49705.000, -57678.000, -66900.000, -74658.233, -81058.233, -85838.233, -89202.770,
 -89592.901, -88557.294, -86287.943, -82542.934, -77142.934, -70340.913, -62401.000, -52471.000, -41579.000, -65391.000, -71427.000,
 -80574.000, -83576.327, -89944.918, -88328.519, -90311.064, -86077.064, -85186.607, -78131.893, -74277.000, -64543.000, -57743.000,
 -45038.000, -61236.000, -69955.000, -77310.567, -83425.567, -87819.470, -89222.491, -89169.158, -87934.936, -85258.936, -81049.124,
 -75591.000, -68707.000, -60072.000, -50338.000, -66574.000, -76710.101, -80876.101, -88236.101, -87618.618, -90523.071, -87363.484,
 -87657.508, -81742.563, -79094.600, -70300.000, -64720.000, -53132.000, -64702.000, -73357.777, -80479.777, -85897.777, -88261.089,
 -89027.789, -88842.019, -87189.468, -84090.728, -79530.728, -73895.000, -66565.000, -57911.000, -61013.000, -72326.776, -77812.776,
 -86019.776, -86397.776, -90070.293, -87914.962, -89172.962, -84348.676, -82675.533, -75106.000, -70700.000, -60258.000, -53030.000,
 -58796.000, -68525.512, -76993.512, -83507.512, -86708.512, -88289.512, -88987.080, -88324.638, -86239.937, -82789.937, -78096.000,
 -71958.000, -64431.000, -55424.000, -67290.542, -74360.542, -83336.142, -84610.075, -88993.635, -87741.827, -89860.807, -85932.247,
 -85409.725, -78759.725, -75572.000, -66322.000, -60184.000, -48195.000, -63099.000, -72975.131, -80630.131, -84626.131, -87005.631,
 -88503.573, -88697.350, -87501.395, -85069.842, -81349.842, -76300.000, -69992.000, -62173.000, -52946.000, -61497.000, -69997.161,
 -80246.161, -82393.930, -87352.930, -86932.580, -89881.796, -86902.636, -87271.214, -81673.000, -79462.000, -71371.000, -66341.000,
 -55470.000, -47851.000, -68215.710, -77389.307, -82021.307, -85211.307, -87444.761, -88415.608, -88063.214, -86693.390, -83733.390,
 -79713.390, -74463.390, -67903.390, -59802.000, -50403.000, -62485.535, -76620.535, -79723.535, -85209.535, -85702.535, -89279.535,
 -87160.068, -88439.611, -83731.611, -82447.000, -75339.000, -71613.000, -61711.000, -55126.000, -42700.000, -57436.000, -70966.712,
 -78956.712, -82959.712, -85877.712, -87648.300, -88075.660, -87558.217, -85328.217, -82391.000, -78059.000, -72461.000, -65465.000,
 -57073.000, -47599.000, -51549.000, -66635.740, -74005.740, -82399.438, -83949.438, -88124.438, -86895.877, -88954.546, -85241.369,
 -84741.369, -78551.000, -75781.000, -66611.000, -61460.000, -50003.000, -60799.000, -69705.584, -77825.584, -83787.584, -86435.645,
 -87586.595, -87855.940, -86655.940, -84630.357, -80910.357, -76159.000, -70219.000, -63016.000, -54287.000, -56504.000, -64590.000,
 -74423.420, -79498.246, -86424.442, -86344.134, -88892.358, -86022.358, -86495.190, -81368.844, -79157.844, -71307.844, -66788.000,
 -56355.000, -49304.000, -50496.000, -60258.000, -69559.519, -76501.119, -82378.579, -86551.145, -87726.774, -87126.667, -85904.567,
 -83202.567, -79512.567, -73856.000, -67955.543, -60351.000, -51558.000, -54995.000, -65931.000, -72299.139, -80119.139, -82893.139,
 -88267.172, -86529.421, -87573.860, -83136.860, -82037.000, -75037.000, -71222.000, -61991.000, -55918.000, -43901.000, -50571.000,
 -60799.000, -68843.542, -75649.542, -80706.565, -84919.280, -87236.114, -86958.114, -84829.114, -82042.114, -77537.722, -72375.210,
 -65355.000, -57678.000, -48410.000, -57101.000, -64077.000, -72995.897, -77055.897, -83276.031, -84325.762, -88087.615, -84699.615,
 -84477.342, -78430.247, -75459.386, -66989.386, -61529.000, -50729.000, -43044.000, -51800.000, -60705.000, -68328.538, -74478.538,
 -79729.877, -82942.993, -85444.905, -86025.576, -84202.574, -80474.888, -75946.081, -69968.353, -63146.000, -54809.000, -45466.000,
 -47972.000, -55722.000, -65481.242, -70521.242, -77828.012, -80039.086, -84542.631, -83797.314, -85959.517, -81085.853, -78996.944,
 -71352.399, -66852.000, -56952.000, -50052.000, -37390.000, -52098.000, -60650.000, -67691.387, -73944.606, -78190.856, -81616.413,
 -83077.858, -84011.780, -82970.420, -79527.634, -74252.511, -68242.511, -60780.000, -52322.000, -42206.000, -46938.000, -57538.000,
 -63316.084, -71780.481, -74899.869, -80441.308, -80759.963, -83757.479, -81425.820, -81976.369, -75661.412, -71921.000, -62848.000,
 -56756.000, -45047.000, -36710.000, -52471.000, -60185.471, -68070.025, -72993.377, -77101.730, -79636.301, -81441.582, -81278.541,
 -80662.142, -78002.099, -72947.615, -66248.000, -58728.000, -49481.000, -39626.000, -49090.000, -55738.704, -65105.231, -69209.858,
 -75740.025, -76766.257, -80935.509, -79463.724, -81005.724, -77127.958, -76098.070, -67830.797, -62670.797, -52071.000, -44600.000,
 -31210.000, -43771.000, -52289.934, -61485.563, -67235.563, -72180.563, -75470.563, -78156.253, -79052.253, -79276.392, -77555.055,
 -75367.684, -70758.904, -64386.257, -56039.000, -47217.000, -36253.000, -47599.766, -58048.483, -63163.483, -70425.837, -72485.837,
 -77417.837, -76878.251, -79346.590, -76239.256, -76280.245, -70515.356, -67833.356, -58433.000, -51754.000, -39542.000, -30963.000,
 -44041.000, -53598.000, -61134.000, -66798.164, -70988.164, -74385.196, -76075.853, -77146.768, -76451.500, -75137.623, -71499.950,
 -67687.950, -61674.261, -53864.000, -44106.000, -34018.000, -39151.000, -50655.000, -57222.000, -64993.681, -68003.681, -73693.681,
 -73607.132, -77061.132, -74800.546, -75771.944, -71115.684, -69322.027, -62082.000, -57974.000, -46882.000, -39132.000, -25460.000,
 -35397.000, -45923.000, -54437.000, -61441.000, -66855.300, -70956.788, -73399.207, -74586.250, -74662.939, -74198.821, -71633.583,
 -68763.221, -63638.923, -58256.000, -50828.000, -41685.000, -30602.000, -42700.000, -50198.000, -59262.000, -63714.000, -70157.856,
 -71268.076, -74772.647, -72898.338, -74717.096, -70727.096, -70128.564, -63583.214, -60474.024, -51884.000, -46419.000, -33897.000,
 -37623.000, -47087.000, -55349.000, -61805.000, -67352.098, -70688.098, -72569.048, -73377.294, -72892.857, -71323.686, -69153.298,
 -65023.389, -60460.355, -54000.905, -47311.000, -38480.000, -42476.000, -52797.000, -58321.000, -65685.878, -68421.001, -72465.282,
 -71747.955, -73716.308, -70154.308, -70400.400, -64649.151, -62617.538, -54564.000, -50075.000, -39961.000, -33301.000, -39002.000,
 -48400.000, -55899.000, -62755.159, -66977.159, -70201.159, -71828.023, -72080.112, -71258.898, -69164.398, -66062.398, -62219.810,
 -56642.687, -50494.000, -42632.000, -34689.000, -45401.000, -52052.000, -60361.000, -64216.854, -69371.854, -70094.116, -72545.159,
 -70100.736, -70534.324, -65474.000, -64259.103, -56814.703, -53237.567, -43866.000, -37961.000, -26371.000, -40669.000, -49211.000,
 -56570.000, -62224.000, -66737.338, -69471.338, -70833.880, -70773.828, -69432.382, -66892.382, -63392.333, -58911.333, -53413.115,
 -46480.113, -39004.000, -29673.000, -44917.000, -54148.000, -58973.000, -65215.806, -67214.806, -70699.888, -69479.885, -70416.616,
 -66186.616, -65287.000, -58687.000, -56022.000, -47349.000, -42246.000, -31328.000, -24276.000, -41703.000, -49937.000, -56700.000,
 -62224.000, -66057.353, -68571.851, -69542.412, -69176.777, -67339.054, -64570.486, -60725.048, -55746.428, -49727.694, -42846.000,
 -34545.000, -25821.000, -47143.000, -53104.000, -60417.000, -63372.000, -67951.903, -67846.267, -69681.592, -66391.592, -66062.547,
 -60462.547, -58163.000, -50283.000, -45909.990, -35995.000, -29464.000, -17247.000, -42541.000, -50431.000, -56979.000, -61777.000,
 -65515.980, -67471.557, -68064.634, -67205.734, -65203.315, -62039.315, -57889.000, -52589.000, -46266.506, -38775.302, -30656.000,
 -20809.000, -46305.000, -54753.000, -58647.000, -64290.578, -65684.473, -68190.258, -66049.975, -66345.722, -61506.402, -59848.000,
 -52888.000, -49180.103, -39917.000, -34147.000, -22629.000, -15072.000, -43296.000, -50897.000, -56626.000, -61488.000, -64604.742,
 -66389.866, -66387.301, -65177.303, -62738.303, -59368.303, -54768.303, -49316.000, -42553.760, -34901.000, -26112.000, -16722.000,
 -48177.000, -53104.000, -59746.000, -62086.625, -65976.625, -64989.789, -65952.563, -61990.011, -60994.000, -54758.000, -51770.000,
 -43249.000, -38206.329, -27647.000, -20561.000, -43799.000, -50561.000, -56467.000, -60659.000, -63621.191, -64907.266, -64531.286,
 -62938.746, -60176.746, -56256.746, -51661.000, -45813.000, -38809.795, -30692.473, -21914.000, -11569.000, -46603.000, -54399.000,
 -57706.000, -62593.368, -63079.584, -64934.464, -61894.849, -61590.725, -56110.725, -53794.000, -46137.000, -41898.691, -31855.000,
 -25592.000, -13501.000, -43734.000, -50701.000, -55843.000, -59942.538, -62292.538, -63299.248, -62550.890, -60596.598, -57466.598,
 -53468.000, -48463.000, -42223.000, -34872.000, -26497.000, -17193.000, -48102.000, -52499.000, -58470.000, -60084.685, -62998.997,
 -61319.891, -61576.900, -57101.900, -55303.000, -48636.000, -44839.000, -35761.000, -29963.446, -18662.000, -11146.000, -43901.000,
 -50096.000, -55606.785, -58806.785, -60930.800, -61281.940, -60372.800, -58079.800, -54810.434, -50375.000, -44936.000, -38350.000,
 -30668.313, -21991.762, -12649.000, -46342.000, -53403.000, -56248.302, -60118.302, -59803.883, -60771.916, -57312.778, -56216.000,
 -50217.000, -47236.000, -38971.000, -33934.586, -23257.000, -16463.000, -43501.000, -49854.000, -54528.508, -57728.508, -59218.961,
 -59315.389, -57836.544, -55433.000, -51735.000, -47078.000, -41408.000, -34428.000, -26288.000, -17465.000,  -7662.000, -47404.000,
 -51400.000, -56493.101, -57383.638, -59263.786, -56744.520, -56394.520, -51474.520, -48975.000, -41651.000, -37187.000, -27346.000,
 -21073.989,  -9213.000, -43370.000, -49099.000, -53654.000, -56261.916, -57560.027, -56889.216, -55284.000, -52594.000, -48594.000,
 -43722.000, -37454.000, -30080.000, -21890.439, -12670.051, -45503.000, -51847.000, -53873.303, -56953.303, -55578.958, -55852.224,
 -52007.224, -50152.000, -43676.000, -39939.000, -30922.000, -25326.129, -14050.000, -42802.000, -48503.000, -52319.311, -54704.311,
 -55174.334, -54489.605, -52490.000, -49583.000, -45277.000, -39980.000, -33274.000, -25825.000, -17185.000,  -8000.000, -46305.000,
 -49377.174, -53497.174, -53390.993, -54583.838, -51473.838, -50683.000, -45112.000, -41964.000, -33989.000, -28876.000, -18379.000,
 -11724.482, -42504.000, -47469.000, -50992.651, -52391.884, -52890.209, -51724.209, -49723.000, -46323.000, -41875.000, -36170.000,
 -29386.000, -21224.000, -12727.118,  -2905.000, -44116.000, -49701.349, -50345.971, -52445.216, -50533.216, -50441.916, -45781.916,
 -43455.842, -36251.000, -31941.000, -22379.000, -16323.195,  -4445.000, -41601.000, -46416.000, -49067.170, -50472.927, -50362.041,
 -49302.356, -46592.356, -42894.000, -38052.000, -32160.000, -24767.000, -16969.000,  -7949.000, -44404.000, -46686.502, -49789.502,
 -48935.420, -49643.282, -45840.974, -44385.000, -37955.000, -34265.000, -25713.000, -20193.000,  -9135.000, -40846.000, -44740.000,
 -47413.853, -48441.085, -48253.195, -46514.522, -43524.522, -39456.072, -34300.000, -27993.000, -20674.000, -12199.000,  -3061.000,
 -41722.000, -46059.677, -46432.720, -48246.241, -45446.241, -44538.241, -39003.801, -36078.959, -28299.000, -23519.000, -13404.000,
  -6822.167, -39523.000, -43285.577, -45295.577, -46365.611, -45809.611, -43678.000, -40228.000, -35650.000, -30161.000, -23696.000,
 -16118.000,  -7517.000, -36170.000, -41500.026, -42840.026, -45706.026, -44223.334, -44254.521, -39692.521, -37358.000, -30298.000,
 -26178.000, -16990.000, -10993.000, -38396.000, -41396.439, -43388.439, -43821.433, -42808.642, -40436.000, -36557.611, -31850.611,
 -26098.000, -19468.000, -11569.000,  -2135.000, -36403.000, -38610.327, -42511.327, -41929.771, -42999.289, -39168.289, -37788.521,
 -31672.961, -28447.803, -19982.000, -14623.000,  -3279.000, -36878.000, -39906.720, -41217.871, -41220.534, -39718.125, -36740.000,
 -33010.000, -28145.000, -22197.000, -14876.000,  -6094.000, -33804.000, -38669.148, -39018.148, -41138.501, -38329.144, -37822.659,
 -32523.000, -30223.000, -22430.000, -17642.000,  -7291.000, -35478.534, -37978.534, -38987.800, -38455.352, -36484.845, -33635.000,
 -29685.000, -24508.000, -17810.000,  -9776.000, -34298.032, -35568.032, -38708.032, -36708.032, -37324.891, -32882.891, -31413.000,
 -24413.000, -20325.188, -10695.000,  -4555.000, -34350.148, -36395.374, -36709.063, -35690.511, -33860.511, -30680.511, -26188.000,
 -20307.000, -12991.000,  -4980.000, -31708.000, -35882.031, -34835.823, -36295.511, -32779.170, -32069.000, -25949.000, -22577.000,
 -13629.000,  -7897.000, -33395.840, -34536.346, -34479.707, -33411.060, -31070.752, -27434.000, -22281.000, -15779.000,  -8289.000,
    175.000, -32435.255, -32531.855, -34778.645, -32286.611, -32246.611, -26964.000, -24250.000, -16070.000, -10913.283,   -959.000,
 -29692.402, -31692.402, -32812.385, -32585.585, -31075.585, -28271.000, -23780.000, -17930.000, -11136.000,  -3210.000, -28296.408,
 -29453.923, -32662.940, -31157.245, -31843.261, -27466.000, -25420.000, -18064.000, -13495.000,  -4003.000,   2151.000, -28283.417,
 -30438.051, -31156.971, -30557.346, -28376.843, -24796.000, -19622.582, -13445.000,  -6250.000,   1547.000, -25821.000, -29923.300,
 -29597.990, -30970.466, -27510.466, -26100.000, -19538.646, -15516.000,  -6751.000,  -1136.443, -24417.100, -27408.077, -29111.031,
 -29563.297, -28118.225, -25234.743, -20886.930, -15281.000,  -8725.000,  -1575.000, -26618.475, -27276.109, -29520.227, -27064.187,
 -26253.633, -20360.609, -17014.000,  -9042.000,  -4027.000,   6054.000, -23756.385, -26416.385, -27679.084, -27196.109, -25293.236,
 -21451.632, -16572.000, -10724.374,  -4159.000,   3713.000, -22598.000, -24415.916, -27362.070, -25997.463, -25947.892, -20796.062,
 -17975.000, -10760.031,  -6318.000,   3062.000, -23159.493, -25283.448, -25775.284, -24800.566, -21547.206, -17313.804, -12251.737,
  -6226.000,    976.000,   8579.000, -20767.000, -24707.278, -24359.825, -25123.544, -20674.356, -18343.803, -11865.779,  -8044.000,
    552.000,   6034.000, -18993.000, -22303.593, -23834.813, -23783.728, -21075.339, -17544.318, -13007.052,  -7761.000,  -1244.512,
   5763.000, -20959.849, -22267.062, -23800.598, -20043.090, -18196.508, -12482.724,  -9166.000,  -1409.457,   3523.000, -16229.395,
 -21044.395, -22467.068, -20068.833, -17159.768, -13249.698,  -8637.905,  -2925.464,   3472.000,  11265.000, -13097.000, -16762.555,
 -21763.563, -18884.455, -17483.154, -12498.312,  -9658.440,  -2669.802,   1654.000,  10698.000, -13647.200, -17628.707, -18272.891,
 -16379.586, -12893.106,  -8964.106,  -3804.760,   1811.000,   8913.219,  -9253.857, -14742.634, -14806.147, -15968.230, -11987.107,
  -9613.145,  -3354.936,    416.000,   8622.654,  14001.000, -10496.563, -11868.965, -12447.675, -11661.552,  -8769.633,  -4164.400,
    832.752,   7124.247,  13840.000,  -7556.749,  -8130.505, -10384.522,  -8630.610,  -8673.233,  -3544.346,   -201.676,   7276.309,
  12032.000,  -3260.000,  -5239.806,  -6667.147,  -6593.906,  -5711.591,  -3563.108,    322.155,   6123.351,  12074.000,  19732.030,
   -188.025,  -1212.186,  -4484.259,  -3393.980,  -4334.917,   -973.653,     84.898,   6420.855,  10666.000,  19318.465,   1706.821,
   -545.288,  -1265.672,  -1183.747,    303.694,   2518.941,   6008.911,  10923.253,  17789.308,   5775.000,   1774.680,   2243.818,
    240.468,   2969.484,   3277.370,   8123.808,  10293.904,  17800.520,   5825.000,   4386.981,   3646.384,   4300.196,   5874.010,
   8693.330,  12171.056,  17035.691,   8351.563,   8086.725,   5203.618,   7045.191,   6635.913,  10828.658,  12358.822,  18637.242,
  21878.000,  10522.600,   8825.747,   8607.788,   9379.013,  11555.105,  14457.952,  18518.422,  23208.564,  14253.000,  10604.265,
  11469.463,  10260.096,  13741.495,  14655.310,  20377.819,  23019.000,  16897.000,  14396.000,  13269.739,  12954.995,  14508.712,
  16926.640,  20365.941,  24546.000,  20800.000,  16366.787,  16342.089,  14309.441,  16607.466,  17189.909,  22100.000,  24284.000,
  23604.000,  20297.000,  18379.037,  17229.973,  17815.779,  19370.558,  22322.084,  25823.763,  22440.000,  21643.737,  18818.043,
  20221.274,  19989.160,  23860.080,  25700.045,  26492.000,  23852.683,  21987.412,  21629.824,  22301.306,  24326.123,  27371.360,
  31577.352,  28774.000,  27333.218,  23662.324,  24302.533,  23185.517,  26019.186,  27329.797,  32723.000,  32981.000,  29652.399,
  27172.306,  25846.141,  25801.317,  26820.644,  29006.783,  32563.406,  35475.000,  33276.000,  28936.019,  28890.119,  26763.075,
  28910.721,  29217.569,  33701.000,  36074.602,  35793.000,  32434.904,  30674.904,  29579.904,  29890.335,  31201.446,  33763.734,
  37389.171,  39598.000,  34544.239,  33557.201,  30857.201,  32166.869,  31603.158,  35222.197,  36929.636,  42296.000,  38396.000,
  35910.488,  33810.488,  33420.973,  33803.128,  35613.955,  38432.000,  42439.000,  46253.000,  40700.000,  39143.677,  35443.677,
  35938.635,  34601.531,  37352.000,  38358.400,  43398.000,  44707.000,  41498.000,  38728.649,  37483.532,  36913.421,  37941.934,
  40042.657,  43289.000,  47320.000,  47085.000,  45103.000,  40608.938,  40335.850,  38140.580,  39950.426,  40338.044,  44520.000,
  46798.000,  47601.000,  44250.076,  42324.062,  40914.062,  41037.778,  42179.440,  44739.000,  48057.000,  52704.000,  51398.000,
  46305.000,  45340.627,  42440.627,  43370.097,  42893.512,  46174.000,  47883.000,  53403.000,  50202.000,  47636.065,  45386.065,
  44867.501,  45087.818,  46547.445,  49268.000,  53214.000,  57818.000,  52390.000,  50763.664,  47303.664,  47450.729,  46158.688,
  48417.037,  49384.356,  54274.000,  57203.000,  53216.000,  50568.731,  49305.273,  48583.478,  49386.389,  51186.000,  54364.000,
  58292.000,  56802.000,  52709.264,  52320.918,  50121.319,  51500.271,  51715.651,  55656.000,  58027.000,  64199.000,  56197.000,
  54256.039,  52951.039,  52930.224,  53697.581,  56098.000,  59351.000,  63959.000,  58614.000,  57413.000,  54713.012,  55463.975,
  54799.156,  57799.000,  59325.645,  64924.000,  68400.000,  59870.000,  57749.837,  57168.280,  57177.189,  58685.576,  60939.000,
  64861.000,  69406.000,  63202.000,  59799.717,  59875.894,  58447.839,  60703.482,  61469.643,  66107.000,  69002.000,  63098.143,
  61893.480,  60999.422,  61809.635,  63378.000,  66432.000,  70212.000,  75467.000,  65389.406,  64988.872,  62612.736,  63962.736,
  64085.667,  67966.000,  70124.380,  76320.000,  68996.000,  67148.000,  65527.622,  65482.652,  66128.652,  68604.000,  71556.000,
  76200.000,  70556.000,  67386.359,  68074.000,  67233.439,  70289.000,  71896.805,  77229.000,  73104.000,  70744.222,  69843.351,
  69719.351,  71170.000,  73611.000,  77316.000,  81807.000,  72983.184,  72945.777,  71166.085,  73266.000,  74067.510,  78700.000,
  81499.000,  76641.333,  75221.333,  74128.333,  74504.225,  75978.663,  79101.000,  82866.000,  87896.000,  79056.000,  78528.000,
  76028.139,  77288.139,  76811.050,  80695.000,  82871.198,  88799.000,  80929.000,  79295.083,  79007.422,  79341.163,  81301.000,
  84439.000,  88732.000,  93782.000,  84393.000,  81334.503,  81986.388,  80898.188,  83578.000,  84718.198,  89971.000,  93304.000,
  84803.000,  84082.584,  83792.964,  84835.986,  86845.454,  90140.000,  94539.000, 100041.000,  87039.000,  87180.000,  85479.952,
  87609.566,  87817.402,  91997.000,  94248.151, 100704.000,  89403.000,  88583.794,  88989.933,  90217.768,  92782.000,  96011.000,
 100469.000,  90419.000,  91682.582,  91473.000,  94903.000,  96473.000, 101941.000, 105399.000,  93697.000,  93617.000,  94103.000,
  95935.000,  98392.000, 102205.000, 106798.000,  96545.000,  95605.000,  98340.000,  99142.000, 103794.000, 106595.916, 113459.000,
  98499.000,  99615.000, 101302.000, 104426.000, 108238.000, 113456.000, 100154.000, 102177.000, 102388.000, 106333.000, 108498.000,
 114582.000, 103762.000, 104830.000, 107194.000, 110208.000, 114710.000, 119893.000, 106170.000, 109425.000, 110777.000, 116186.000,
 119611.504, 110530.000, 112772.000, 116621.000, 121096.000, 127211.000, 113575.000, 118308.000, 121133.000, 128490.000, 118989.000,
 122746.000, 128105.000, 134094.000, 123102.000, 129306.000, 133696.000, 124927.000, 129576.000, 135200.000, 131083.000, 134718.000,
 131554.000, 136070.000, 136287.000, 142963.000, 139021.000
};


//+----------------------------+
//| Table of Beta Decay Energy |
//+----------------------------+
//unit: keV
G4double G4NucleiPropertiesTable::BetaEnergy[G4NucleiPropertiesTable::nEntries] = {
    782.353,      0.0  ,      0.0  ,     18.591,      0.0  ,  23502.873, -22895.261,      0.0  ,  25447.745,   -292.646, -26317.000,
      0.0  ,  24269.640,   3507.811,  -4288.153,      0.0  ,  11202.591,   -861.815, -12098.376,      0.0  ,  10651.789,  16004.532,
 -17979.340, -12173.054,      0.0  ,  15864.459,  13606.319,  -1068.116, -16497.950,      0.0  ,  15759.785,  20443.649,    555.816,
  -3647.807, -24000.000,      0.0  ,  20621.889,  11505.986,  -1982.547, -14309.989,      0.0  ,  25019.000,  11707.501,  13368.901,
 -17338.083, -14709.755,      0.0  ,  17096.236,  13437.198,  -2220.445, -17765.279,      0.0  ,  16218.666,  20643.837,    156.475,
  -5143.039, -25602.000,      0.0  ,  19093.792,   9771.705,  -2753.950, -13921.614,      0.0  ,  23387.569,   8010.685,  10420.430,
 -15417.255, -13312.144,      0.0  ,  22679.721,  13165.771,   8679.820,  -2760.703, -14533.472,      0.0  ,  27398.000,  11806.900,
  13899.200,  -1655.496,  -4433.351, -20011.000,      0.0  ,  26531.000,  16972.934,  12526.884,   4820.970,  -3238.464, -11177.564,
      0.0  ,  15793.571,  17969.583,   3814.305,   7024.533, -13886.789, -10725.671,      0.0  ,  20728.000,  17170.173,   8109.316,
   5684.140,  -3547.460, -13095.942, -15207.000,      0.0  ,  20502.000,  22796.544,   6490.562,  10818.127,  -2842.240,  -4785.338,
 -18580.000, -13982.000,      0.0  ,  23118.000,  11286.855,   8483.159,   4375.844,  -4056.819, -12239.876, -17005.000,      0.0  ,
  28066.000,  11429.943,  13492.033,   2470.081,   5515.780, -13878.340, -10809.800, -21242.000,      0.0  ,  15877.000,  13325.079,
   7298.763,   3835.267,  -4276.983, -12741.052, -15047.000,      0.0  ,  16876.000,  17858.282,   7332.347,   9312.012,  -4004.137,
  -5065.721, -18118.000, -14997.000,      0.0  ,  17956.515,  12674.370,   9005.645,   2610.326,  -4812.398, -11631.453, -18260.000,
      0.0  ,  21948.000,  12312.171,  13985.176,   1831.800,   4642.241, -14331.775, -11234.125, -22484.000,      0.0  ,  22276.000,
  15401.879,  13279.896,   7554.317,   3679.521,  -4943.119, -13793.029, -16302.000,      0.0  ,  13642.205,  17476.649,   6990.139,
   8560.509,  -4232.325,  -6137.750, -18506.000, -15640.000,      0.0  ,  18178.000,  15878.849,  11739.092,   7994.777,   1492.032,
  -5396.059, -11980.495, -18360.000,      0.0  ,  18872.000,  19099.260,  10266.469,  13018.791,    224.458,   1710.663, -12685.287,
 -11151.613, -22597.000,      0.0  ,  20305.658,  13709.156,  11987.457,   5845.347,    248.508,  -5582.724, -11622.175, -16144.000,
      0.0  ,  24058.000,  11313.165,  17094.319,   4600.987,   5374.301,  -5491.284,  -6062.302, -16897.000, -14634.000,      0.0  ,
  24862.000,  16350.000,  14301.683,  10497.851,   3988.758,    167.141,  -5965.305, -11881.101, -15606.000,      0.0  ,  14996.000,
  18317.023,   7850.201,  10413.118,  -1142.072,    708.554, -12805.361, -10985.879, -20337.000,      0.0  ,  19496.000,  16127.894,
  12470.516,   7901.510,   4865.301,   -813.485,  -6148.793, -11638.634, -16002.000,      0.0  ,  19487.000,  10721.494,  12394.976,
   2936.900,   4916.787,  -5913.072,  -6742.647, -17122.000, -14038.000,      0.0  ,  18257.000,  14792.000,  10511.652,   6639.314,
   3441.184,    565.000,  -6530.581, -13108.242, -15400.000,      0.0  ,  13740.000,  14512.674,   4708.184,   7482.161,  -1504.873,
   1311.093, -14319.724, -11676.176, -19180.000,      0.0  ,  16674.000,  13758.164,   8737.215,   5728.114,   2491.611,   -421.386,
  -6495.276, -12929.000, -15471.000,      0.0  ,  14913.000,  17326.000,   7745.377,   9434.736,    599.255,   3525.445,  -6425.839,
  -7000.047, -16952.000, -14159.000,      0.0  ,  15565.000,  11547.371,   7948.142,   4615.511,   1815.400,  -2220.819,  -6867.310,
 -11296.000, -15888.000,      0.0  ,  20083.000,   9111.000,  12270.981,   3548.175,   5658.873,  -3653.276,   -267.513, -13702.000,
 -10312.000, -19934.000,      0.0  ,  18928.000,  14084.000,  10810.006,   6888.696,   4204.502,    256.809,  -2062.427,  -7133.321,
 -12461.000, -14298.000, -18676.000,      0.0  ,  22598.000,  14392.000,  14929.000,   5698.194,   7715.977,  -1376.274,   2366.702,
  -7051.409,  -7603.000, -17101.000, -13125.000,      0.0  ,  18322.000,  14684.000,   9788.539,   6642.807,   1991.936,    600.101,
  -2927.802,  -7451.573, -12290.000, -15640.000,      0.0  ,  16897.000,  18425.000,   8902.000,  12090.263,    278.070,   3994.188,
  -4012.342,  -1659.346, -13818.000, -10889.000, -19748.000,      0.0  ,  20605.000,  16497.000,  13721.000,  10970.000,   5262.230,
   2005.764,   -601.861,  -2630.745,  -7714.893, -13028.000, -15006.000,      0.0  ,  20297.000,  12256.000,  14218.831,   4966.053,
   6888.341,  -2208.314,   1036.925,  -7632.989,  -8149.972, -17276.000, -13404.000,      0.0  ,  18900.000,  15705.000,  13885.000,
   7332.289,   6508.052,   2470.641,   -752.733,  -3207.804,  -8019.649, -12943.000, -15835.000,      0.0  ,  14494.000,  16310.000,
   7871.123,   9083.765,   1973.385,   3975.387,  -4711.659,  -2372.000, -14413.000, -11262.000, -20027.000,      0.0  ,  17798.000,
  15901.000,  10069.000,   8857.000,   5020.000,   3436.034,   -597.013,  -3742.352,  -8302.128, -13260.000, -15919.000,      0.0  ,
  17987.000,  10880.000,  11299.021,   4122.437,   7041.591,  -1377.052,    697.140,  -8243.079,  -8799.227, -17512.000, -15127.000,
      0.0  ,  17547.000,  12221.000,  11467.000,   7341.854,   5956.000,   2603.086,   -231.377,  -3451.296,  -8693.800, -13706.000,
 -16702.000,      0.0  ,  12231.000,  13665.000,   7107.298,   9049.241,   1616.955,   3695.453,  -4566.000,  -2135.358, -15299.000,
 -12873.000, -20987.000,      0.0  ,  14267.000,  13171.000,   9818.000,   8016.623,   5091.864,   2690.854,   -836.042,  -3264.191,
  -8770.207, -14619.000, -16786.000,      0.0  ,  15798.000,   8812.000,  11550.524,   3971.470,   6246.591,  -2307.416,    381.586,
  -8563.049,  -9366.851, -18307.000, -15612.000,      0.0  ,  14979.000,  11793.000,   9939.039,   7622.260,   5185.321,   1565.188,
  -1072.484,  -4799.579,  -9094.138, -13137.000, -17121.000,      0.0  ,  10377.000,  13758.164,   6088.246,   8492.481,    237.295,
   2823.882,  -6126.891,  -4158.103, -14185.000, -12231.000, -21368.000,      0.0  ,  13607.000,  12407.000,   8970.286,   7182.320,
   3977.553,   1321.733,  -2237.206,  -5637.145,  -8995.000, -13618.000, -15677.000,      0.0  ,  16152.000,   7293.597,  10432.270,
   2530.201,   5314.591,  -3948.171,  -1627.164,  -9171.000,  -9753.000, -17279.000,      0.0  ,  13870.000,  11225.000,   9027.627,
   6057.713,   3672.200,     66.945,  -3366.869,  -5520.000,  -9779.000, -13087.000,      0.0  ,   9753.000,  11979.011,   4710.077,
   7306.591,  -1675.098,    578.725,  -7164.799,  -4410.000, -14904.000,      0.0  ,  13292.000,  10395.471,   7876.171,   5958.365,
   2137.132,  -1351.944,  -3254.866,  -6242.350,  -9355.000, -14137.000,      0.0  ,  13823.000,   5732.961,   9976.467,    225.600,
   2641.976,  -5175.000,  -2100.000,  -9800.000, -10100.000,      0.0  ,  12873.000,   8746.727,   8421.041,   3557.696,    577.000,
  -1000.477,  -4222.928,  -6010.000, -10153.000, -13693.000,      0.0  ,   7592.000,  11657.709,   2055.860,   4462.143,  -2921.100,
   -105.975,  -8100.000,  -4729.000, -15256.000,      0.0  ,  11644.000,   9331.858,   5362.196,   2675.011,    905.995,  -2227.285,
  -4013.017,  -6783.140,  -9889.000, -14105.000,      0.0  ,  12734.000,   3475.137,   6599.091,   -654.720,   1655.614,  -6220.000,
  -2400.000, -10350.000, -10614.000,      0.0  ,  10926.000,   6874.594,   4557.449,   2815.147,   -231.924,  -2012.710,  -4800.000,
  -6500.000, -10493.000, -13795.000,      0.0  ,  14075.000,   5384.000,   8066.000,    458.083,   3999.058,  -4356.097,   -335.027,
  -8741.663,  -5040.000, -15996.000,      0.0  ,   8933.000,   6251.000,   4293.849,   1593.293,   -340.859,  -2740.000,  -4683.635,
  -6647.351, -10651.000, -14535.000,      0.0  ,   7182.000,  10006.000,   2344.814,   5368.000,  -2562.412,   1353.008,  -6906.646,
  -3136.408, -10444.050, -11029.000,      0.0  ,  10498.000,   8162.000,   5995.779,   3391.710,   1176.549,   -863.639,  -3030.000,
  -4897.221,  -7019.183, -10573.000,      0.0  ,   8700.000,  11733.000,   4160.000,   7010.000,   -923.313,   2961.988,  -4962.875,
  -1309.988,  -8498.153,  -6091.000,      0.0  ,  11998.000,  10120.000,   7270.000,   5340.000,   2702.040,    682.871,  -1365.116,
  -3062.526,  -5345.581,  -6851.055, -11046.000,      0.0  ,  10237.000,  13265.000,   6440.000,   8200.000,    954.138,   4209.472,
  -3573.777,    707.804,  -7223.934,  -3761.258, -10545.000,      0.0  ,  11742.000,   9090.000,   7000.000,   4148.000,   2280.945,
    151.046,  -1625.778,  -3645.613,  -5319.162,  -7120.000, -11000.000,      0.0  ,  16278.000,   7290.400,  10380.000,   2670.222,
   5641.437,  -1870.555,   2004.493,  -5720.566,  -1867.893,  -9140.000,  -5788.000,      0.0  ,  11855.000,   8320.000,   6230.000,
   3856.341,   1585.282,   -280.714,  -2237.212,  -3929.907,  -5510.367,  -7160.000, -11397.000,      0.0  ,  10880.000,  12677.000,
   4700.000,   7270.000,    -97.496,   3092.620,  -4399.529,   -180.307,  -7815.991,  -4000.000, -11219.000,      0.0  ,  11513.000,
   8877.000,   5460.000,   3669.018,    972.728,   -909.137,  -2275.712,  -4468.882,  -5868.000,  -7500.000, -11212.000,      0.0  ,
  14000.000,   7685.000,   9870.000,   1826.508,   4654.729,  -2680.884,    894.139,  -6485.983,  -2666.000,  -9613.000,  -6073.000,
      0.0  ,  10135.000,   8910.000,   6182.000,   2870.000,    687.083,  -1065.022,  -3255.000,  -4693.000,  -6000.000,  -8089.000,
 -11504.000,      0.0  ,   9352.000,  11140.000,   5099.000,   7626.000,   -518.626,   1774.243,  -5240.000,  -1476.536,  -7978.000,
  -5270.000, -11350.000,      0.0  ,  10302.000,   7275.000,   6852.500,   3885.061,    283.314,  -1861.606,  -3668.917,  -5165.000,
  -6488.223,  -8573.000, -11783.000,      0.0  ,  12236.000,   6854.000,   8960.000,   2914.081,   5313.443,  -3622.600,   -673.301,
  -7200.000,  -3723.000, -10132.000,  -7070.000,      0.0  ,  12305.000,   8973.000,   8155.000,   4985.882,   4496.352,   1495.051,
  -2832.685,  -4291.008,  -5575.045,  -7510.000,  -7980.000, -12361.000,      0.0  ,   8183.000,  10350.000,   4391.865,   6586.914,
    545.998,   2280.077,  -6111.000,  -2489.000,  -8960.663,  -5798.000, -12193.000,      0.0  ,  10623.000,   9802.000,   6435.000,
   5891.060,   2707.322,   1544.833,  -1253.390,  -4434.112,  -6220.000,  -7404.663,  -9476.000, -12044.000,      0.0  ,   9385.000,
  12204.904,   5987.000,   8099.849,   1940.361,   3639.092,  -2005.607,    356.514,  -7870.354,  -4527.000, -11048.000,  -7862.000,
      0.0  ,  11024.000,   8600.000,   7461.597,   4136.604,   2893.177,     91.365,   -404.892,  -3200.855,  -6337.000,  -8093.000,
  -9473.000,      0.0  ,  13337.000,   7410.000,  10290.651,   3507.865,   4916.650,   -901.398,   2045.447,  -4255.745,  -1586.576,
  -9630.000,  -6588.000, -13050.000,      0.0  ,   9800.000,   9278.654,   6086.850,   4453.445,   1124.835,    925.617,  -1690.631,
  -2567.453,  -5110.000,  -8189.000, -10051.000,      0.0  ,   8184.000,  11740.072,   5386.536,   7099.951,    163.569,   3186.800,
  -2973.234,    254.411,  -6446.432,  -3450.000, -11605.000,  -8467.000,      0.0  ,  10449.000,  10427.241,   7468.476,   6688.406,
   2658.085,   1933.885,   -320.257,  -1108.202,  -3523.000,  -4790.000,  -7006.000, -10191.000,      0.0  ,  12325.881,   5823.376,
   8824.189,   2250.188,   4585.599,  -1683.997,   1796.461,  -5057.378,  -1867.012,  -8420.000,  -5420.000, -13657.000,      0.0  ,
  11276.271,   8085.648,   7567.133,   4558.004,   3638.662,   1357.227,    293.651,  -2042.574,  -3386.591,  -5430.000,  -6905.000,
  -8942.000,      0.0  ,  13524.000,   7075.000,   9310.000,   3335.000,   6245.000,   -168.084,   3202.411,  -3630.000,   -361.388,
  -7046.557,  -3875.802, -10170.796,  -7270.000,      0.0  ,  11810.000,   9505.000,   8545.000,   5485.000,   4569.000,   2824.441,
   1613.498,   -541.485,  -1980.000,  -4203.824,  -5476.538,  -7339.000,  -8849.000,      0.0  ,  15082.000,   8815.000,   9850.000,
   4605.000,   7210.000,   1009.949,   4530.260,  -2322.533,   1150.515,  -5954.369,  -2587.000,  -9250.000,  -5386.000,      0.0  ,
  11187.000,   9634.000,   6945.000,   5530.000,   3750.000,   2659.534,    763.355,   -543.081,  -2687.592,  -4141.887,  -6050.000,
  -7653.000, -11169.000,      0.0  ,  10135.000,  11802.000,   5888.000,   8105.000,   2155.000,   5602.706,  -1141.238,   2440.889,
  -4278.646,  -1136.294,  -7908.686,  -4515.000, -12204.000,      0.0  ,  11215.000,   8491.000,   6485.000,   4950.000,   3640.000,
   1916.919,    566.719,  -1345.252,  -2738.204,  -4849.000,  -6256.821,  -9443.656,      0.0  ,  13330.000,   7191.000,   9367.000,
   3520.000,   6547.000,     39.400,   3541.100,  -2965.265,    194.145,  -6523.369,  -3185.092, -11068.000,  -8327.000,      0.0  ,
   9827.000,   8025.000,   6160.000,   4820.000,   2940.416,   1510.964,     33.005,  -1417.000,  -3426.000,  -5006.320,  -7902.000,
 -10141.000,      0.0  ,   8635.000,  10648.000,   4750.000,   7720.000,   1361.325,   4505.000,  -1918.183,   1649.025,  -5157.011,
  -2091.814,  -9496.000,  -6825.000, -12858.000,      0.0  ,   9147.000,   7623.000,   5985.000,   4160.000,   2591.496,   1115.949,
   -214.295,  -2019.953,  -3849.678,  -6380.000,  -8681.887,  -9999.749,      0.0  ,  12063.000,   5906.000,   8778.000,   2810.000,
   5400.000,   -892.440,   2892.178,  -3878.000,   -637.052,  -8300.000,  -5257.000, -11929.000,  -8627.000,      0.0  ,   8812.000,
   6977.000,   5496.000,   3741.000,   2188.333,   1036.800,   -865.404,  -2444.917,  -5100.000,  -7368.000,  -8528.000, -10578.000,
      0.0  ,   7079.000,   9955.000,   3670.000,   6800.000,    287.967,   3955.967,  -2585.931,    663.715,  -7054.976,  -4347.260,
 -10161.000,  -7168.000, -13661.000,      0.0  ,   9967.000,   8188.000,   6632.000,   4908.000,   3340.000,   2016.462,    316.450,
  -1035.961,  -3916.529,  -6100.000,  -7189.000,  -9071.438, -10388.648,      0.0  ,  11067.000,   4800.000,   7900.000,   1450.722,
   5076.442,  -1451.860,   1988.685,  -5881.508,  -2758.000,  -9122.000,  -5864.000, -12366.000,  -8868.000,      0.0  ,   9287.000,
   7625.000,   6000.000,   4584.000,   3103.485,   1445.888,    495.886,  -3030.000,  -4638.667,  -5905.000,  -8029.000,  -8757.000,
 -10965.000,      0.0  ,   6005.000,   8900.000,   2607.000,   6151.701,   -469.996,   3274.989,  -4706.918,  -1511.831,  -7745.149,
  -4660.000, -10411.000,  -8165.000,      0.0  ,   8793.000,   6996.000,   5734.000,   4160.000,   2517.373,   1454.962,  -1756.634,
  -3534.638,  -4670.055,  -6442.829,  -7521.933,  -9520.000, -10386.000,      0.0  ,   7079.000,   9730.000,   4100.000,   7142.918,
    521.190,   4423.008,  -3656.632,   -273.210,  -7032.818,  -2976.766,  -9300.000,  -6413.000, -12231.000,      0.0  ,   8085.000,
   6533.000,   5350.000,   3797.000,   2363.623,   -593.902,  -2293.011,  -3514.272,  -5005.343,  -6349.607,  -8086.343,  -9257.000,
 -10964.000,      0.0  ,  10945.000,   4882.000,   8325.000,   1760.381,   5370.000,  -2680.600,    982.189,  -5615.000,  -1960.000,
  -7942.130,  -5000.000, -11200.000,  -7983.000,      0.0  ,   9222.000,   7758.000,   6400.000,   4780.000,   3364.538,    390.131,
  -1035.608,  -2269.350,  -3745.010,  -5400.000,  -6802.021,  -7940.000,  -9930.000, -10893.000,      0.0  ,   6036.000,   9147.000,
   3002.000,   6368.591,  -1616.399,   1982.545,  -4234.000,   -890.457,  -7054.714,  -3855.000,  -9734.000,  -6800.000, -12706.000,
      0.0  ,   8719.000,   7355.000,   6115.000,   4393.903,   1403.021,    -53.333,  -1234.222,  -2676.000,  -4209.812,  -5458.000,
  -6884.000,  -8635.000,  -9734.000,      0.0  ,  10136.000,   4166.000,   7360.000,   -617.483,   2904.453,  -3159.587,    294.024,
  -5914.946,  -2647.963,  -8795.000,  -5580.000, -11588.000,      0.0  ,   8656.000,   7122.000,   5418.000,   2363.312,    766.700,
   -185.770,  -1652.551,  -3098.740,  -4560.000,  -5635.000,  -7331.000,  -8654.000,      0.0  ,  11314.000,   5486.000,   8207.000,
    378.000,   3672.517,  -2155.331,   1258.000,  -4824.286,  -1673.143,  -7569.000,  -4406.000, -10442.000,  -7228.000,      0.0  ,
   9730.000,   8468.000,   6514.000,   3201.000,   1581.000,    697.568,   -662.442,  -2084.701,  -3450.000,  -4693.000,  -6139.000,
  -7526.000,  -9008.000,      0.0  ,   7070.000,   8975.600,   1273.933,   4383.560,  -1251.808,   2118.979,  -3928.559,   -522.523,
  -6650.000,  -3188.000,  -9250.000,  -6139.000, -11988.000,      0.0  ,   9876.000,   7655.000,   3996.000,   2379.500,   1497.942,
    193.777,  -1195.955,  -2431.553,  -3720.000,  -5050.000,  -6307.000,  -7819.000,  -9227.000,      0.0  ,   8500.000,  10249.000,
   2147.769,   4959.000,   -420.351,   2949.217,  -2979.160,    368.578,  -5598.000,  -2211.000,  -8091.000,  -5030.000, -10871.000,
  -7620.000,      0.0  ,   9173.597,   4632.000,   3190.000,   2233.454,    970.848,   -352.395,  -1369.823,  -2960.000,  -4020.000,
  -5250.000,  -6560.000,  -8101.000,  -9399.000,      0.0  ,  14135.000,   3103.000,   5486.000,    493.000,   3577.000,  -2119.467,
   1279.543,  -4708.000,  -1285.000,  -7107.000,  -3726.000,  -9902.000,  -6586.000, -12426.000,      0.0  ,  13531.000,   7990.000,
   4003.000,   2918.000,   1770.588,    427.360,   -517.443,  -2230.000,  -2938.000,  -4331.000,  -5598.000,  -6996.000,  -8393.000,
  -9473.000,      0.0  ,  15087.000,   7370.000,   8393.699,   1550.000,   4175.000,  -1228.561,   2058.669,  -3713.176,   -500.000,
  -6190.000,  -2770.000,  -9170.000,  -5151.000, -11457.000,      0.0  ,   8907.000,   8120.000,   5962.000,   2648.061,   1150.950,
    269.345,  -1200.000,  -2025.582,  -3720.000,  -4751.000,  -5940.000,  -7203.000,  -8728.000,      0.0  ,   8085.000,   9834.000,
   5074.826,   6926.196,    -80.308,   2548.224,  -2870.000,    472.833,  -5126.347,  -2211.000,  -7850.000,  -4520.000, -10433.000,
  -7051.000,      0.0  ,   9762.000,   9301.000,   6941.600,   5877.460,   4172.566,   1175.630,   -600.107,  -1222.100,  -2702.000,
  -3690.000,  -5657.000,  -5900.000,  -7604.000,  -8793.000,      0.0  ,  10936.000,   6368.000,   7820.000,   2774.000,   5374.034,
  -1737.751,   1044.439,  -4437.000,  -1100.000,  -7000.000,  -3815.000,  -9231.000,  -6073.000, -12016.000,      0.0  ,  10228.000,
   8045.000,   6806.000,   5057.023,   4212.716,   2316.834,   -278.000,  -2129.000,  -2787.000,  -4504.392,  -5162.512,  -7020.000,
  -7677.000,  -9268.000,      0.0  ,   6977.000,   8918.000,   4060.000,   6220.134,   1049.731,   3761.853,  -3388.000,   -222.273,
  -6047.095,  -2970.861,  -8470.000,  -5460.000, -10800.000,  -7685.000,      0.0  ,   8905.000,   7623.000,   6150.000,   5251.339,
   3213.117,   2501.911,    580.672,  -1823.002,  -3727.686,  -4528.807,  -5977.727,  -6822.000,  -8337.000,  -9343.000,      0.0  ,
   7750.000,   9759.000,   5040.000,   7306.770,   2211.074,   4503.545,   -745.318,   2162.203,  -4873.664,  -2088.908,  -7644.545,
  -4500.000,  -9900.000,  -6900.000, -12662.000,      0.0  ,   8551.000,   7042.000,   6253.219,   4246.250,   3425.558,   1461.444,
    933.922,  -1041.359,  -3442.786,  -5275.123,  -6010.000,  -7463.000,  -8458.000, -10116.000,      0.0  ,  10600.000,   5778.000,
   8464.396,   3119.389,   5541.438,    318.655,   2997.516,  -2331.659,    550.549,  -6314.957,  -3740.000,  -9074.000,  -6092.000,
 -11709.000,  -8337.000,      0.0  ,   7714.000,   7884.554,   4923.352,   4108.352,   2534.571,   1805.282,   -163.041,   -616.399,
  -2660.043,  -5054.484,  -6700.000,  -7520.000,  -9247.000,  -9855.000,      0.0  ,   6649.000,   9366.528,   4104.626,   6530.167,
   1026.232,   4169.252,  -1471.785,   1542.000,  -3877.767,  -1029.888,  -8267.273,  -5160.000, -10600.000,  -7471.000, -13390.000,
      0.0  ,   8519.000,   9195.630,   5750.000,   4945.000,   3290.000,   2685.690,    896.000,    224.139,  -1721.336,  -2187.371,
  -4608.780,  -6372.647,  -8348.000,  -8821.000, -10965.000,      0.0  ,  10448.718,   5115.000,   7262.354,   2060.000,   4932.000,
   -539.586,   2468.339,  -3107.333,     40.989,  -5764.889,  -2682.000,  -9400.000,  -6680.000, -12212.000,  -8579.000,      0.0  ,
   9557.000,   7536.000,   5664.000,   4190.000,   3397.033,   1690.657,   1070.915,   -695.268,  -1313.877,  -3637.673,  -3812.000,
  -6013.690,  -7810.000,  -9758.000, -10088.000,      0.0  ,  11504.000,   6567.000,   7772.000,   3010.000,   5690.000,    -86.548,
   3454.000,  -2260.587,    971.398,  -4656.261,  -1793.657,  -7240.000,  -4108.000, -11092.000,  -7750.000, -13672.000,      0.0  ,
  10526.000,   8514.000,   7005.000,   5414.000,   4101.488,   2442.420,   1187.042,     76.689,   -464.118,  -2565.237,  -2870.363,
  -5124.297,  -5383.000,  -7427.000,  -9143.000, -11083.000,      0.0  ,   7499.000,   9063.000,   4453.000,   6444.000,   1110.220,
   3504.571,  -1874.310,   1818.758,  -3990.000,   -598.532,  -6545.350,  -3109.190,  -8590.000,  -5465.000, -12522.000,      0.0  ,
   9464.000,   8262.000,   6455.000,   5547.000,   3336.000,   1880.950,    808.246,   -484.437,  -1569.171,  -2170.387,  -4129.909,
  -4563.034,  -6459.450,  -6690.000,  -8831.000,      0.0  ,  10321.000,   5524.000,   7365.000,   2735.123,   4044.281,   -717.327,
   1968.354,  -3562.000,    246.091,  -5751.249,  -2031.613,  -8054.000,  -4488.701, -10114.000,  -6660.000,      0.0  ,   9399.000,
   7499.000,   6856.000,   4222.000,   3224.000,   1626.864,    252.089,   -821.215,  -2094.500,  -3102.000,  -3842.588,  -5577.123,
  -6149.000,  -7862.000,  -7943.000,      0.0  ,   6651.000,   8309.000,   3856.000,   5155.000,    722.262,   2451.043,  -2444.423,
    433.588,  -5060.000,  -1215.000,  -7444.400,  -3577.136,  -9371.000,  -5905.015, -11590.000,      0.0  ,   8542.000,   7359.000,
   5654.000,   4514.000,   2734.000,   1362.542,    -60.053,  -1341.445,  -2540.000,  -3500.049,  -4481.000,  -5498.218,  -6933.002,
  -7476.000,  -9331.000,      0.0  ,   9231.000,   4825.000,   6243.000,   1999.000,   3485.082,  -1220.003,    936.732,  -4230.000,
   -900.000,  -6599.118,  -2665.000,  -8673.000,  -5102.070, -10919.000,  -7052.000,      0.0  ,   8234.000,   6763.000,   5524.000,
   3834.000,   2514.498,    970.561,   -365.635,  -1837.723,  -2768.568,  -3845.437,  -4978.620,  -6018.734,  -6882.000,  -8301.000,
  -8724.000,      0.0  ,   5962.000,   7312.000,   2955.000,   4580.000,   -105.636,   1835.325,  -3290.000,   -329.045,  -5600.000,
  -2300.000,  -7880.000,  -4373.000,  -9915.000,  -6530.628, -12217.000,      0.0  ,   7890.000,   6548.000,   4797.000,   3739.000,
   1955.577,    593.077,   -858.900,  -2002.419,  -3164.000,  -4150.000,  -5300.000,  -6323.000,  -7491.204,  -8119.000,  -9847.000,
      0.0  ,   8449.000,   3894.000,   5644.000,   1393.895,   2505.785,  -2140.283,    295.747,  -4839.320,  -1658.000,  -6960.028,
  -3708.000,  -9264.000,  -5769.440, -11519.000,  -7556.000,      0.0  ,   7601.000,   5729.000,   4862.000,   3117.000,   1785.124,
     -2.565,  -1209.999,  -2439.000,  -3370.000,  -4600.000,  -5452.000,  -6762.000,  -7653.000,  -8789.000,  -9390.000,      0.0  ,
   4928.000,   6642.000,   2341.000,   3890.000,   -986.836,    962.774,  -3962.552,   -996.000,  -6236.680,  -2987.000,  -8521.000,
  -5043.000, -10559.000,  -7086.153,      0.0  ,   6763.000,   5906.000,   4192.000,   2962.000,   1286.075,   -375.980,  -1592.540,
  -2762.000,  -3920.000,  -4596.000,  -5848.000,  -7004.000,  -8117.322,  -8779.000, -10345.000,      0.0  ,   7797.000,   3307.000,
   4887.000,    486.215,   1854.881,  -3039.615,   -304.124,  -5480.000,  -2317.000,  -7657.000,  -4238.000, -10044.000,  -6262.936,
 -12091.000,      0.0  ,   6968.000,   5142.000,   4099.000,   2350.000,   1006.709,   -748.358,  -1954.292,  -3130.000,  -3999.000,
  -5005.000,  -6240.000,  -7351.000,  -8375.000,  -9304.000,      0.0  ,   4397.000,   5971.000,   1615.000,   2914.312,  -1679.106,
    257.009,  -4475.000,  -1799.000,  -6666.000,  -3797.000,  -9078.000,  -5798.000, -11302.000,  -7516.000,      0.0  ,   6194.000,
   5511.000,   3200.000,   2124.015,    351.141,   -909.141,  -2293.000,  -3269.366,  -4435.000,  -5439.000,  -6587.000,  -7681.000,
  -8676.551,  -9343.000,      0.0  ,   7061.000,   2846.000,   3870.000,   -314.419,    968.032,  -3459.138,  -1097.000,  -5999.000,
  -2981.000,  -8265.000,  -5036.000, -10678.000,  -6793.591,      0.0  ,   6353.000,   4675.000,   3200.000,   1490.453,     96.428,
  -1478.845,  -2403.000,  -3698.000,  -4657.000,  -5670.000,  -6979.000,  -8141.000,  -8823.000,  -9802.000,      0.0  ,   3996.000,
   5093.000,    890.537,   1880.148,  -2519.266,   -350.000,  -4920.000,  -2500.000,  -7323.000,  -4464.000,  -9841.000,  -6272.000,
 -11861.000,      0.0  ,   5729.000,   4555.000,   2608.000,   1298.111,   -670.811,  -1605.000,  -2690.000,  -4000.000,  -4872.000,
  -6268.000,  -7374.000,  -8190.000,  -9220.388,      0.0  ,   6343.000,   2026.000,   3080.000,  -1374.345,    273.266,  -3845.000,
  -1856.000,  -6476.000,  -3736.000,  -9017.000,  -5596.000, -11277.000,      0.0  ,   5701.000,   3816.000,   2385.000,    470.023,
   -684.729,  -2000.000,  -2906.000,  -4307.000,  -5297.000,  -6706.000,  -7449.000,  -8641.000,  -9184.000,      0.0  ,   3073.000,
   4120.000,   -106.181,   1192.844,  -3110.000,   -791.000,  -5570.000,  -3148.000,  -7975.000,  -5113.000, -10497.000,  -6655.000,
      0.0  ,   4965.000,   3524.000,   1399.233,    498.325,  -1166.000,  -2001.000,  -3400.000,  -4448.000,  -5705.000,  -6784.000,
  -8162.000,  -8497.000,  -9822.000,      0.0  ,   5586.000,    644.621,   2099.246,  -1912.000,    -91.300,  -4660.000,  -2326.075,
  -7205.000,  -4310.000,  -9562.000,  -6056.000, -11879.000,      0.0  ,   4816.000,   2651.000,   1405.757,   -110.885,  -1059.685,
  -2710.000,  -3698.000,  -4842.000,  -5892.000,  -7393.000,  -7798.000,  -9020.000,      0.0  ,   2282.000,   3103.000,   -854.082,
    707.862,  -3802.308,  -1456.000,  -6429.000,  -3691.000,  -8551.000,  -5520.000, -11059.000,      0.0  ,   3894.000,   2674.000,
   1027.231,   -187.890,  -1738.673,  -2990.000,  -4068.450,  -5156.000,  -6307.000,  -7319.000,  -8475.000,  -9138.000,      0.0  ,
   4338.000,    373.043,   1813.520,  -2800.000,   -908.000,  -5534.440,  -2924.842,  -7780.000,  -4780.000, -10115.000,  -6582.000,
      0.0  ,   3762.000,   2010.000,   1070.034,   -556.000,  -2132.000,  -3450.000,  -4578.000,  -5488.000,  -6466.000,  -7578.000,
  -8601.000,      0.0  ,   5330.000,   1340.000,   2866.000,  -1482.692,     31.187,  -4562.000,  -2335.000,  -7060.000,  -4120.000,
  -9187.000,  -5997.000,      0.0  ,   3000.000,   1992.000,    432.994,  -1012.791,  -2372.000,  -3879.000,  -4707.000,  -5753.000,
  -6630.000,  -7899.000,  -9434.000,      0.0  ,   2208.000,   3901.000,   -581.556,   1069.517,  -3831.000,  -1379.768,  -6115.560,
  -3225.158,  -8466.000,  -5359.000, -11344.000,      0.0  ,   3029.000,   1311.151,      2.663,  -1502.409,  -2978.000,  -3730.000,
  -4865.000,  -5947.000,  -7322.000,  -8782.000,      0.0  ,   4865.000,    349.000,   2120.353,  -2809.357,   -506.486,  -5300.000,
  -2300.000,  -7792.000,  -4789.000, -10351.000,      0.0  ,   2500.000,   1009.267,   -532.448,  -1970.508,  -2850.000,  -3950.000,
  -5176.558,  -6698.000,  -8034.000,      0.0  ,   1270.000,   3140.000,  -2000.000,    616.859,  -4442.000,  -1470.000,  -7000.000,
  -4088.000,  -9630.000,  -6140.000,      0.0  ,   2045.226,    313.689,  -1018.553,  -1830.000,  -3180.000,  -4493.000,  -5881.000,
  -7315.000,  -8011.000,      0.0  ,   4174.000,  -1046.208,   1459.689,  -3516.341,   -710.000,  -6120.000,  -3372.000,  -8947.000,
  -5732.000,      0.0  ,   1140.506,    -56.639,  -1068.648,  -2340.308,  -3636.000,  -5153.000,  -6503.000,  -7490.000,  -8464.000,
      0.0  ,     96.600,   2246.791,  -2492.034,    -40.000,  -5283.000,  -2713.000,  -8180.501,  -5156.000,  -9955.000,      0.0  ,
   2000.000,   1119.983,   -226.800,  -1510.000,  -2805.000,  -4490.000,  -5850.000,  -6795.000,  -7925.000,      0.0  ,   1157.515,
   3209.016,  -1505.695,    686.016,  -4378.000,  -2045.000,  -7357.000,  -4569.000,  -9492.000,  -6154.000,      0.0  ,   2154.634,
    718.919,   -599.624,  -2180.503,  -3580.000,  -5174.000,  -6178.000,  -7194.000,  -7797.000,      0.0  ,   4102.000,   -325.310,
   1372.475,  -3460.000,  -1410.000,  -6562.000,  -4022.000,  -8764.701,  -5615.000,      0.0  ,   2990.977,   1702.954,    452.265,
  -1445.071,  -2883.483,  -4347.812,  -5606.000,  -6555.000,  -7150.000,      0.0  ,    657.634,   2244.118,  -2456.040,   -810.554,
  -5893.024,  -3347.000,  -7972.000,  -5016.000, -10080.000,      0.0  ,   2660.000,   1262.699,   -482.975,  -1902.874,  -3841.604,
  -4879.000,  -5848.000,  -6566.000,  -7872.000,      0.0  ,   1818.000,   2946.154,  -1364.606,    -49.571,  -5151.830,  -2822.000,
  -7214.000,  -4442.000,  -9379.647,      0.0  ,   2123.955,    491.836,   -974.718,  -3253.361,  -4233.402,  -5062.066,  -6026.000,
  -7202.000,  -7603.000,      0.0  ,   3940.000,   -347.453,    763.718,  -4449.187,  -2330.553,  -6478.024,  -3822.000,  -8596.000,
  -5481.000,      0.0  ,   3310.000,   1531.220,    -51.085,  -2708.389,  -3531.022,  -4537.266,  -5246.000,  -6517.000,  -7007.000,
      0.0  ,   1307.213,   1533.536,  -3757.508,  -1846.582,  -5713.784,  -3317.000,  -7756.000,  -4932.000,      0.0  ,   4815.000,
   1422.674,  -2398.235,  -2909.065,  -3910.070,  -4611.793,  -5712.441,  -6397.000,  -7794.000,      0.0  ,   3666.000,   5001.007,
  -2879.108,  -1401.302,  -4984.842,  -2839.872,  -6988.638,  -4324.000,  -9043.000,      0.0  ,   3981.507,    644.184,  -1893.305,
  -3486.479,  -3929.000,  -5159.346,  -5615.000,  -7103.000,      0.0  ,   5488.776,     63.514,   1162.083,  -3981.123,  -2373.963,
  -6258.208,  -3771.000,  -8207.000,  -5378.000,      0.0  ,   1372.402,    578.709,   -786.122,  -2891.919,  -4605.233,  -4997.152,
  -6291.495,  -6716.000,      0.0  ,    573.756,   2254.017,  -1753.912,     42.624,  -5128.888,  -3342.670,  -7477.985,  -4755.000,
      0.0  ,   1980.000,   1427.341,    -73.242,   -882.315,  -2148.483,  -3885.263,  -5801.196,  -5950.000,  -7658.000,      0.0  ,
   1024.161,   3272.073,  -1090.279,    940.937,  -3361.263,  -1058.551,  -6335.957,  -4246.000,  -8652.000,      0.0  ,   2252.109,
    720.384,    -81.925,  -1487.441,  -2215.247,  -3489.970,  -4914.342,  -6866.055,      0.0  ,   4000.000,   -469.139,   2003.351,
  -2729.016,   -307.886,  -4846.438,  -2170.096,  -7506.616,      0.0  ,   1438.000,    740.598,   -653.813,  -1573.813,  -2819.321,
  -3477.726,  -4864.635,      0.0  ,    264.838,   2883.107,  -1841.573,    409.278,  -4192.744,  -1530.164,  -6278.420,  -3241.000,
      0.0  ,   1696.853,    217.958,   -771.225,  -2176.092,  -2902.847,  -4060.470,  -4690.142,      0.0  ,   3649.000,   -865.199,
   1209.367,  -3481.399,   -913.815,  -5722.509,  -2641.000,      0.0  ,   2501.000,   1127.000,    314.745,  -1553.717,  -2417.928,
  -3439.301,  -4180.000,      0.0  ,   4433.000,     24.698,   2032.647,  -2298.025,   -582.444,  -4910.000,  -2183.000,      0.0  ,
   3307.000,   1918.000,   1149.064,   -585.807,  -1554.778,  -2951.527,  -3501.679,      0.0  ,    796.000,   2825.694,  -1403.231,
    232.115,  -3870.920,  -1839.965,      0.0  ,   2639.000,   1865.271,    357.589,   -671.482,  -2024.817,  -3045.237,  -4205.993,
      0.0  ,   1441.000,   3670.895,   -640.210,   1117.017,  -2833.669,  -1310.611,  -5393.000,      0.0  ,   3329.000,   2480.093,
   1326.166,     44.824,  -1019.327,  -2186.140,  -3556.622,      0.0  ,   2199.000,   4340.000,     45.900,   2127.045,  -2147.646,
   -306.848,  -4484.000,  -2373.000,      0.0  ,   3358.000,   1760.000,   1095.000,   -310.431,  -1311.112,  -2562.287,  -3625.437,
      0.0  ,   5054.000,    987.038,   2700.000,  -1309.668,    563.712,  -3619.039,  -1707.439,      0.0  ,   3900.000,   2486.000,
   2100.000,    389.515,   -382.155,  -1810.827,  -2818.000,  -4007.000,      0.0  ,   5553.000,   1556.000,   3700.000,   -494.958,
   1337.103,  -2750.000,  -1007.000,  -5040.000,      0.0  ,   3209.000,   2769.000,   1245.117,    570.111,  -1028.513,  -2100.723,
  -3246.000,  -4031.000,      0.0  ,   1982.000,   4494.000,    273.088,   2195.269,  -1809.846,   -387.618,  -4182.000,  -2279.000,
      0.0  ,   3351.000,   1926.014,   1410.000,   -123.716,  -1141.661,  -2559.000,  -3318.000,  -4647.000,      0.0  ,   5093.000,
    964.000,   2900.000,   -929.469,    476.585,  -3280.000,  -1710.000,  -5519.000,      0.0  ,   2566.000,   2250.000,    518.565,
   -220.318,  -1459.627,  -2720.000,  -3946.000,  -4604.000,      0.0  ,   1626.000,   3460.000,   -147.065,   1292.041,  -2258.350,
   -967.319,  -4890.000,  -2929.000,      0.0  ,   2648.000,   1263.457,    721.796,   -802.912,  -1800.000,  -3177.000,  -3928.000,
      0.0  ,   4093.000,    388.346,   2199.599,  -1378.952,   -215.380,  -3940.000,  -2371.000,  -6172.000,      0.0  ,   1941.000,
   1305.000,     20.815,   -767.357,  -2400.000,  -3254.000,  -4607.000,      0.0  ,   1201.000,   2700.000,   -750.963,    664.820,
  -3000.000,  -1526.000,  -5598.000,  -3476.000,      0.0  ,   2120.000,    581.556,     -8.908,  -1508.387,  -2254.000,  -3921.000,
  -4545.000,      0.0  ,   3402.000,    -76.177,   1428.055,  -2255.643,   -766.161,  -4637.000,  -2895.000,      0.0  ,   1204.663,
    894.059,   -810.213,  -1568.000,  -3054.000,  -3780.000,  -5255.000,      0.0  ,    400.534,   2376.136,  -1350.000,   -122.930,
  -3880.000,  -2158.000,  -6195.000,      0.0  ,   1848.000,   1620.000,     44.970,   -646.000,  -2476.000,  -2952.000,  -4644.000,
      0.0  ,   3170.000,   -687.000,    840.000,  -3055.000,  -1608.000,  -5332.000,      0.0  ,   2359.000,    900.871,    124.000,
  -1451.000,  -2440.000,  -3705.000,  -4491.000,      0.0  ,     37.407,   1779.692,  -2100.000,   -801.000,  -4633.000,  -2799.000,
      0.0  ,   1420.000,   1093.000,   -375.892,  -1474.438,  -3123.000,  -3765.000,  -5030.000,      0.0  ,    528.000,   2500.000,
  -1260.000,    477.090,  -3884.000,  -2176.000,  -5928.000,      0.0  ,   1633.000,    287.661,   -333.741,  -1960.000,  -3138.000,
  -4294.000,  -5049.000,      0.0  ,   3059.000,   -651.886,   1088.200,  -2680.000,  -1140.000,  -5252.000,  -3334.000,      0.0  ,
    720.000,    289.620,  -1043.022,  -2009.468,  -3295.000,  -4399.000,  -5502.000,      0.0  ,   -141.000,   1700.000,  -2129.614,
   -207.836,  -4180.000,  -2251.000,  -6456.000,      0.0  ,    820.000,   -406.139,  -1227.835,  -2564.000,  -3229.000,  -4459.000,
      0.0  ,  -1263.000,    209.000,  -3430.000,  -1570.000,  -5468.000,  -3458.000,      0.0  ,     80.000,   -486.000,  -1832.000,
  -2457.000,  -3813.000,  -4593.000,      0.0  ,    940.000,  -2735.000,   -802.000,  -4651.000,  -2802.000,  -6863.000,      0.0  ,
  -1116.000,  -1687.000,  -3125.000,  -3812.000,  -5218.000,      0.0  ,  -2023.000,   -211.000,  -3945.000,  -2165.000,  -6084.000,
      0.0  ,  -1068.000,  -2364.000,  -3014.000,  -4502.000,  -5183.000,      0.0  ,  -3255.000,  -1352.000,  -5408.000,  -3426.000,
      0.0  ,  -2242.000,  -3849.000,  -4474.000,  -6116.000,      0.0  ,  -4733.000,  -2825.000,  -7357.000,      0.0  ,  -3758.000,
  -5358.000,  -5990.000,      0.0  ,  -6204.000,  -4391.000,      0.0  ,  -4649.000,  -5624.000,      0.0  ,  -3635.000,      0.0  ,
  -4517.000,      0.0  ,  -6675.000,      0.0  ,      0.0  
};

// Reduced Table of A for shorter index search.
//         The index in this table coincide with A-1
//         For each A value shortTable[A-1] has the index of 
//         the 1st occurrence in the indexArray[][]
G4int G4NucleiPropertiesTable::shortTable[G4NucleiPropertiesTable::MaxA+1]=
{
    0,    2,    3,    5,    8,   12,   16,   20,   25,   30, 
   36,   41,   47,   52,   58,   63,   69,   75,   82,   89, 
   96,  104,  113,  121,  130,  138,  147,  155,  164,  173, 
  182,  191,  201,  210,  220,  230,  240,  250,  260,  270, 
  280,  290,  301,  311,  322,  334,  346,  357,  369,  381, 
  393,  405,  417,  429,  441,  453,  465,  477,  489,  501, 
  513,  525,  536,  547,  557,  568,  578,  589,  599,  610, 
  620,  631,  642,  653,  664,  675,  686,  698,  710,  722, 
  734,  746,  758,  770,  782,  794,  806,  818,  830,  843, 
  855,  868,  881,  893,  906,  918,  931,  944,  957,  970, 
  984,  998, 1012, 1026, 1040, 1053, 1067, 1080, 1094, 1107, 
 1121, 1134, 1148, 1162, 1176, 1190, 1203, 1217, 1231, 1245, 
 1259, 1274, 1288, 1302, 1315, 1328, 1342, 1356, 1370, 1384, 
 1399, 1413, 1428, 1443, 1458, 1472, 1487, 1502, 1517, 1532, 
 1547, 1562, 1578, 1593, 1609, 1624, 1640, 1656, 1672, 1688, 
 1705, 1722, 1738, 1754, 1770, 1786, 1802, 1818, 1834, 1850, 
 1866, 1882, 1898, 1914, 1929, 1945, 1960, 1975, 1990, 2005, 
 2019, 2034, 2048, 2062, 2075, 2089, 2102, 2116, 2129, 2142, 
 2154, 2167, 2179, 2191, 2203, 2215, 2227, 2238, 2249, 2259, 
 2270, 2280, 2290, 2300, 2310, 2320, 2331, 2341, 2351, 2361, 
 2371, 2381, 2391, 2401, 2411, 2421, 2430, 2440, 2450, 2459, 
 2469, 2478, 2487, 2497, 2507, 2516, 2525, 2533, 2542, 2550, 
 2558, 2566, 2574, 2582, 2589, 2597, 2605, 2613, 2622, 2630, 
 2638, 2647, 2656, 2665, 2674, 2683, 2692, 2701, 2710, 2718, 
 2727, 2735, 2744, 2752, 2760, 2768, 2776, 2784, 2791, 2799, 
 2806, 2814, 2822, 2830, 2838, 2846, 2854, 2861, 2868, 2875, 
 2882, 2888, 2894, 2900, 2905, 2910, 2914, 2918, 2921, 2924, 
 2926, 2928, 2930, 2931
};

