//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLImmediateQtViewer.cc,v 1.6 2008/10/24 13:49:19 lgarnier Exp $
// GEANT4 tag $Name:  $
//
//
// Class G4OpenGLImmediateQtViewer : a class derived from G4OpenGLQtViewer and
//                                G4OpenGLImmediateViewer.

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLImmediateQtViewer.hh"

#include "G4ios.hh"

G4OpenGLImmediateQtViewer::G4OpenGLImmediateQtViewer
(G4OpenGLImmediateSceneHandler& sceneHandler,
 const G4String&  name):
  G4VViewer (sceneHandler, sceneHandler.IncrementViewCount (), name),
  G4OpenGLViewer (sceneHandler),
  G4OpenGLQtViewer (sceneHandler),
  G4OpenGLImmediateViewer (sceneHandler)
{

  //set true to picking
  fVP.SetPicking(true);
#if QT_VERSION < 0x040000
  setFocusPolicy(QWidget::StrongFocus); // enable keybord events
#else
  setFocusPolicy(Qt::StrongFocus); // enable keybord events
#endif
  hasToRepaint =false;

  if (fViewId < 0) return;  // In case error in base class instantiation.
}

G4OpenGLImmediateQtViewer::~G4OpenGLImmediateQtViewer() {
  makeCurrent();
}

void G4OpenGLImmediateQtViewer::Initialise() {
#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::Initialise \n");
#endif
  readyToPaint = false;
  CreateMainWindow (this,QString(fName));
  CreateFontLists ();

  readyToPaint = true;
}

void G4OpenGLImmediateQtViewer::initializeGL () {

  InitializeGLView ();

#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::InitialiseGL ()\n");
#endif

  // If a double buffer context has been forced upon us, ignore the
  // back buffer for this OpenGLImmediate view.
  //   glDrawBuffer (GL_FRONT); // FIXME : Ne marche pas avec cette ligne, mais affiche le run correctement...
  // clear the buffers and window.
  ClearView ();
  FinishView ();

  glDepthFunc (GL_LEQUAL);
  glDepthMask (GL_TRUE);

  if (fSceneHandler.GetScene() == 0) {
    hasToRepaint =false;
  } else {
    hasToRepaint =true;
  }

#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::InitialiseGL END\n");
#endif
}


void G4OpenGLImmediateQtViewer::DrawView () {

#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::DrawView %d %d   VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n",WinSize_x, WinSize_y);
#endif
  // If a double buffer context has been forced upon us, ignore the
  // back buffer for this OpenGLImmediate view.
  //  glDrawBuffer (GL_FRONT);

  G4ViewParameters::DrawingStyle style = GetViewParameters().GetDrawingStyle();

  //Make sure current viewer is attached and clean...
  //Qt version needed
  glViewport (0, 0, WinSize_x, WinSize_y);

  if(style!=G4ViewParameters::hlr &&
     haloing_enabled) {

    HaloingFirstPass ();
    NeedKernelVisit ();
    ProcessView ();
    glFlush ();
#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::DrawView First ProcessView ok\n");
#endif
    HaloingSecondPass ();

  }

#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::DrawView before needKernelVisit %d\n",fNeedKernelVisit);
#endif
  NeedKernelVisit ();  // Always need to visit G4 kernel.
#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::DrawView before ProcessView\n");
#endif
  ProcessView ();
#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::DrawView before FinishView ok\n");
#endif
  FinishView ();

  if (isRecording()) {
    savePPMToTemp();
  }
   
#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::DrawView %d %d ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n",WinSize_x, WinSize_y);
#endif
  hasToRepaint = true;
}

void G4OpenGLImmediateQtViewer::FinishView()
{
   glFlush ();
}


/**
   - Lors du resize de la fenetre, on doit non pas redessiner le detecteur, mais aussi les evenements
*/
void G4OpenGLImmediateQtViewer::resizeGL(
                                         int aWidth
                                         ,int aHeight)
{  
  G4resizeGL(aWidth,aHeight);
}


void G4OpenGLImmediateQtViewer::paintGL()
{
#ifdef G4DEBUG
  printf("\n\nG4OpenGLImmediateQtViewer::paintGL ??\n");
#endif
  if (!readyToPaint) {
    readyToPaint= true;
    return;
  }
  // DO NOT RESIZE IF SIZE HAS NOT CHANGE
  if ( !hasToRepaint) {
    if (((WinSize_x == (G4int)width())) &&(WinSize_y == (G4int) height())) {
      return;
    }
  }
#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::paintGL VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV ready %d\n",readyToPaint);
#endif
  WinSize_x = (G4int) width();
  WinSize_y = (G4int) height();

  setupViewport(width(),height());

  SetView();
   
  ClearView (); //ok, put the background correct
  DrawView();

  hasToRepaint = false; // could be set to false by DrawView


#ifdef G4DEBUG
  printf("G4OpenGLImmediateQtViewer::paintGL ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ ready %d\n\n\n",readyToPaint);
#endif
}

void G4OpenGLImmediateQtViewer::mousePressEvent(QMouseEvent *event)
{
  G4MousePressEvent(event);
}

void G4OpenGLImmediateQtViewer::keyPressEvent (QKeyEvent * event) 
{
  G4keyPressEvent(event);
}

void G4OpenGLImmediateQtViewer::wheelEvent (QWheelEvent * event) 
{
  G4wheelEvent(event);
}

/**
 * This function was build in order to make a zoom on double clic event.
 * It was think to build a rubberband on the zoom area, but never work fine
 */
void G4OpenGLImmediateQtViewer::mouseDoubleClickEvent(QMouseEvent *event)
{
  G4MouseDoubleClickEvent();
}

void G4OpenGLImmediateQtViewer::mouseReleaseEvent(QMouseEvent *event)
{
  G4MouseReleaseEvent();
}

void G4OpenGLImmediateQtViewer::mouseMoveEvent(QMouseEvent *event)
{
  G4MouseMoveEvent(event);
}


void G4OpenGLImmediateQtViewer::contextMenuEvent(QContextMenuEvent *e)
{
  G4manageContextMenuEvent(e);
}

void G4OpenGLImmediateQtViewer::updateQWidget() {
  hasToRepaint= true;
  updateGL();
  hasToRepaint= false;
}

#endif
