//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: A01app.cc,v 1.8 2006/11/06 19:46:06 allison Exp $
// --------------------------------------------------------------
//
// --------------------------------------------------------------
//      GEANT 4 - A01app
// --------------------------------------------------------------
// Comments
//   Tutorial for Geant4 lectures
// --------------------------------------------------------------


#include "G4RunManager.hh"
#include "G4UImanager.hh"
#include "G4UIterminal.hh"
#ifdef G4UI_USE_TCSH
#include "G4UItcsh.hh"
#endif

#include "A01DetectorConstruction.hh"
#include "A01PhysicsList.hh"
#include "A01PrimaryGeneratorAction.hh"

#include "A01EventAction.hh"

#ifdef G4VIS_USE
#include "G4VisExecutive.hh"
#endif

//OSC:begin
#include <G4Lab/UIOnX.h>
#include "A01AnalysisManager.hh"
#include <AIDA/IAnalysisFactory.h>
//OSC:end

int main(int argc,char** argv)
{
  // RunManager construction
  G4RunManager* runManager = new G4RunManager;

//OSC:begin
  G4UIsession* session = 0;
  if (argc!=1) {   // batch mode
  A01AnalysisManager::setAIDA(AIDA_createAnalysisFactory());
  } else {
  std::string GUI_onx = "main.onx";
  //std::string GUI_onx = "simple_main.onx";
  G4Lab::UIOnX* uiOnX = new G4Lab::UIOnX(*runManager,GUI_onx,argc,argv);
  // Enforce the creation of the GUI here, else
  // the AIDA plotter factory will create its own
  // that will interfer with the G4Lab::UIOnX one.
  uiOnX->createUI();
  A01AnalysisManager::setAIDA(uiOnX->findAIDA());
  session = uiOnX;
  }
//OSC:end

#ifdef G4VIS_USE
  // Visualization manager construction
  G4VisManager* visManager = new G4VisExecutive;
  visManager->Initialize();
#endif

  // mandatory user initialization classes
  runManager->SetUserInitialization(new A01DetectorConstruction);
  runManager->SetUserInitialization(new A01PhysicsList);

  // initialize Geant4 kernel
  runManager->Initialize();

  // mandatory user action class
  runManager->SetUserAction(new A01PrimaryGeneratorAction);

  // optional user action classes
  runManager->SetUserAction(new A01EventAction);

  if(argc>1)
  // execute an argument macro file if exist
  {
    G4UImanager* UImanager = G4UImanager::GetUIpointer();
    G4String command = "/control/execute ";
    G4String fileName = argv[1];
    UImanager->ApplyCommand(command+fileName);
  }
  else
  // start interactive session
  {
#ifdef G4UI_USE_TCSH
    G4UIsession* session = new G4UIterminal(new G4UItcsh);
#else
//OSC:begin
//    G4UIsession* session = new G4UIterminal();
//OSC:end
#endif
    session->SessionStart();
//OSC:begin
//    delete session;
//OSC:end
  }

#ifdef G4VIS_USE
  delete visManager;
#endif

  delete runManager;

//OSC:begin
  // The delete of the run manager may induce,
  // through the user action classes,
  // a delete / closing of the AIDA resources
  // as AIDA trees and various factories.
  // Then we delete the UIOnX that manages the
  // AIDA implementation after the delete
  // of the G4 run manager.
  delete session;
//OSC:end

  return 0;
}

