// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "evio_output.h"

#include <fstream>

void evio_output :: RecordAndClear(MOutputs* output, MBank mbank)
{
 // Need to reorganize the vectors.
 // First index must be variable index
 // Second index must be hit number index

 vector<vector<double> > rawinfv;
 vector<vector<int> >    dgtinfv;

 int NHITS  = rawinfos.size();
 if(NHITS)
 {
    int NVARSR = rawinfos[0].size();
    int NVARSD = dgtinfos[0].size();

    // cout << NHITS << " " << NVARSR << " " << NVARSD << endl;

    rawinfv.resize(NVARSR);
    dgtinfv.resize(NVARSD);

    for(int i=0; i<NVARSR; i++) rawinfv[i].resize(NHITS);
    for(int i=0; i<NVARSD; i++) dgtinfv[i].resize(NHITS);


    for(int nh=0; nh<NHITS; nh++)
       for(int iv=0; iv<NVARSR; iv++)
          rawinfv[iv][nh] = rawinfos[nh][iv];

    for(int nh=0; nh<NHITS; nh++)
       for(int iv=0; iv<NVARSD; iv++)
          dgtinfv[iv][nh] = dgtinfos[nh][iv];

    // inserting bitId in bankevent >> TAG=bankID NUM=1 <<
    // hit size should be the same as bitId size
//     if(NHITS != bitId.size()) cout << " Alarm! " << NHITS << " " << bitId.size() << endl;
//     //    *bankevent << evioDOMNode::createEvioDOMNode(bankID, 1, bitId);

//     // creating dgthitbank, inserting it in bankevent  >> TAG=bankID NUM=100 <<
//     if(NVARSD)
//     {
//       //      evioDOMNodeP dgtbankhit = evioDOMNode::createEvioDOMNode(bankID, 100);
//       *bankevent << dgtbankhit;

//        for(int d=0; d<NVARSD; d++)
//          //    *dgtbankhit << evioDOMNode::createEvioDOMNode(bankID, mbank.id[d+NVARSR], dgtinfv[d]);
//     }

//     // creating rawhitbank, inserting it in bankevent  >> TAG=bankID NUM=200 <<
//     if(NVARSR)
//     {
//       //       evioDOMNodeP rawbankhit = evioDOMNode::createEvioDOMNode(bankID, 200);
//       *bankevent << rawbankhit;

//        for(int r=0; r<NVARSR; r++)
//          //       *rawbankhit << evioDOMNode::createEvioDOMNode(bankID, mbank.id[r], rawinfv[r]);
//     }
 }

 rawinfos.clear();
 dgtinfos.clear();
 bitId.clear();
}
void evio_output :: WriteEvent(MOutputs* output)
{
//  output->pchan->write(*event);
//  delete event;
}

void evio_output :: SetOutpHeader(int evtn, MOutputs* output)
{
  // event = new evioDOMTree(1, 0);

 // creating and inserting head bank  >> TAG=1 NUM=1 <<
  // evioDOMNodeP head = evioDOMNode::createEvioDOMNode(1,  1);
  // *event << evioDOMNode::createEvioDOMNode(1, 1, &evtn, 1);
}



void evio_output :: WriteGenerated(MOutputs* output, vector<MGeneratedParticle> MGP)
{
 double MAXP = output->gemcOpt.args["NGENP"].arg;
 // creating and inserting generated particles bank  >> TAG=10 NUM=10 <<
 // generatedp = evioDOMNode::createEvioDOMNode(10, 10);
 int NP = MGP.size();
 vector< vector<double> > gensinfos;

 for(int i=0; i<MAXP && i<MGP.size(); i++)
 {
    vector<double> geninfo;
    geninfo.push_back((double) MGP[i].PID);
    geninfo.push_back(MGP[i].momentum.getX()/MeV);
    geninfo.push_back(MGP[i].momentum.getY()/MeV);
    geninfo.push_back(MGP[i].momentum.getZ()/MeV);
    geninfo.push_back(MGP[i].vertex.getX()/cm);
    geninfo.push_back(MGP[i].vertex.getY()/cm);
    geninfo.push_back(MGP[i].vertex.getZ()/cm);

    gensinfos.push_back(geninfo);
 }

 // for(int p=0; p<gensinfos.size(); p++) *generatedp << evioDOMNode::createEvioDOMNode(1, 10*(p+1), gensinfos[p]);
 // *event <<  generatedp;

}



void evio_output :: SetBankHeader(int bankid, string SDName, MOutputs* output)
{
//  bankID = bankid;
//  // bankevent = evioDOMNode::createEvioDOMNode(bankID, 0);
//  *event << bankevent ;
}

void evio_output :: ProcessOutput(int bitcid, PH_output PHout, MOutputs* output, MBank mbank)
{

 // check for double/int sizes consistency
 int nraws, ndigit;
 nraws=ndigit=0;
 for(int i=0; i<mbank.name.size(); i++)
 {
    if(mbank.type[i] == 0) ndigit++;
    if(mbank.type[i] == 1) nraws++;
 }
 if(PHout.raws.size() != nraws || PHout.dgtz.size() != ndigit)
 {
    cout << "    Output does not match bank definition. This hit won't be written in the output stream." << endl;
    cout << "    nraws size: " << nraws  << "      Output nraws: " << PHout.raws.size() << endl;
    cout << "    ndgtz size: " << ndigit << "      Output ndgt: "  << PHout.dgtz.size() << endl;
    return;
 }

 vector<double> rawinf;
 vector<int>    dgtinf;

 for(int r=0; r<nraws; r++)
    rawinf.push_back(PHout.raws[r]);

 for(int d=0; d<ndigit; d++)
    dgtinf.push_back(PHout.dgtz[d]);

 bitId.push_back(bitcid);
 rawinfos.push_back(rawinf);
 dgtinfos.push_back(dgtinf);
}



