





























// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4RunManager.hh"
#include "G4UImanager.hh"
#include "G4UIterminal.hh"
#include "G4VisExecutive.hh"

#include<LHEP.hh>
#include<LHEP_BERT.hh>
#include<LHEP_BERT_HP.hh>
#include<QGSP.hh>
#include<QGSP_BIC.hh>
#include<QGSP_BIC_HP.hh>
#include<QGSP_BERT.hh>
#include<QGSP_BERT_HP.hh>

#include "G4UIQt.hh"
#include "G4Qt.hh"

// %%%%%%%%%%
// Qt headers
// %%%%%%%%%%
//#include "arthurwidgets.h"
#include <QApplication>
#include <QSplashScreen>

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%

#include "Clas12_HitProcess_MapRegister.h"
#include "detector.h"
#include "gemc_MainGui.h"
#include "icons.h"
#include "MagneticField.h"
#include "MBankdefs.h"
#include "MDetectorConstruction.h"
#include "MEventAction.h"
#include "MOutputBaseClass.h"
//#include "MPHBaseClass.h"
#include "MPhysicsList.h"
#include "MPrimaryGeneratorAction.h"
//#include "MSteppingAction.h"
//#include "Output_Register.h"
#include "usage.h"
#include "run_conditions.h"



int main( int argc, char **argv )
{
 gemc_opts gemcOpt;
 gemcOpt.Set(argc, argv);
 string hd_msg    = gemcOpt.args["LOG_MSG"].args + " Init: >> " ;

 cout << endl << hd_msg  << " Geant4 MonteCarlo" << endl;
 double use_qt = gemcOpt.args["USE_QT"].arg;

 QApplication gemc_gui( argc, argv, (bool) use_qt );
 QPixmap *splash_i;
 QSplashScreen *splash;


 if(use_qt)
 {
    splash_i = new QPixmap(CLAS12_cad);
    splash   = new QSplashScreen(*splash_i);
    splash->show();
    gemc_gui.processEvents();
 }

 string msg;

 msg = " Setting CLHEP Random Engine...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 CLHEP::HepRandom::setTheEngine(new CLHEP::RanecuEngine);
 string RAND = gemcOpt.args["RANDOM"].args;
 G4int seed;
 if(RAND=="TIME")
 {
    msg = " Initializing CLHEP Random Engine from time and clock...";
    seed = time(NULL)-clock();
 }
 else
 {
    seed = atoi(RAND.c_str());
    msg = " Initializing CLHEP Random Engine from user seed...";
 }
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 CLHEP::HepRandom::setTheSeed(seed);
 char seeds[100];
 sprintf(seeds, "%d", seed);
 msg = " Random Seed Initialised to: " ;
 msg.append(seeds);
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;

 if(gemcOpt.args["gcard"].args != "no")
 {
    msg = " Opening GCARD file " + gemcOpt.args["gcard"].args + "...";
    if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 }
 run_conditions RunConditions(gemcOpt);

 msg = " Instantiating Run Manager...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 G4RunManager *runManager = new G4RunManager;


 msg = " Retrieving gemc Detector Map...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 map<string, detector> Hall_Map = read_detector(gemcOpt, RunConditions);

 msg = " Building gemc Process Hit Factory...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 map<string, MPHB_Factory> MProcessHit_Map = Clas12_HitProcess_Map();

 msg = " Retrieving gemc Banks Map...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 map<string, MBank> MBank_Map = read_banks(gemcOpt, MProcessHit_Map);

 msg = " Retrieving gemc Materials Map...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 map<string, G4Material*> MMats = DefineMaterials();

 msg = " Retrieving gemc Magnetic Fields Map...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 map<string, MagneticField> FieldMap = get_magnetic_Fields(gemcOpt);


 MDetectorConstruction* ExpHall = new MDetectorConstruction(gemcOpt);
 ExpHall->Hall_Map = &Hall_Map;
 ExpHall->MMats    = &MMats;
 ExpHall->FieldMap = &FieldMap;
 runManager->SetUserInitialization(ExpHall);

 string phys_list = gemcOpt.args["USE_PHYSICSL"].args  ;
 msg = " Initializing Physics List " + phys_list + "...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 G4VUserPhysicsList* physics;

 if(phys_list == "gemc")         physics = new MPhysicsList(gemcOpt);
 if(phys_list == "LHEP")         physics = new LHEP(1);
 if(phys_list == "LHEP_BERT")    physics = new LHEP_BERT(1);
 if(phys_list == "LHEP_BERT_HP") physics = new LHEP_BERT_HP(1);
 if(phys_list == "QGSP")         physics = new QGSP(1);
 if(phys_list == "QGSP_BIC")     physics = new QGSP_BIC(1);
 if(phys_list == "QGSP_BIC_HP")  physics = new QGSP_BIC_HP(1);
 if(phys_list == "QGSP_BERT")    physics = new QGSP_BERT(1);
 if(phys_list == "QGSP_BERT_HP") physics = new QGSP_BERT_HP(1);
// physics->SetDefaultCutValue(1*cm);
 runManager->SetUserInitialization(physics);
 // Setting Max step for all the simulation.
 G4TransportationManager::GetTransportationManager()->GetPropagatorInField()->SetLargestAcceptableStep(5*mm);


 msg = " Initializing Primary Generator Action...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 G4VUserPrimaryGeneratorAction* gen_action = new MPrimaryGeneratorAction(gemcOpt);
 runManager->SetUserAction(gen_action);

 msg = " Initializing Event Action...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 MEventAction* event_action = new MEventAction(gemcOpt);
 event_action->SetEvtNumber((int) gemcOpt.args["EVN"].arg);     
 runManager->SetUserAction(event_action);


 msg = " Initializing Stepping Action...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
//  MSteppingAction* SteppingAction = new MSteppingAction(gemcOpt);
//  runManager->SetUserAction(SteppingAction);

 G4UIsession * session = NULL;
 msg = " Initializing User Interface...";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 if(use_qt == 1)
 {
    session = new G4UIQt(argc,argv);
 }
 else
    session = new G4UIterminal();

 G4UImanager* UImanager = G4UImanager::GetUIpointer();

 G4VisManager* visManager;
 if(use_qt)
 {
    visManager = new G4VisExecutive;
    visManager->Initialize();
 }

 msg = " Initializing Run Manager...\n";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 runManager->Initialize();

 msg = " Initializing Output Action...";
 MOutputs MOutput(gemcOpt);

 // map<string, MOutput_Factory> MProcessOutput_Map = Output_Map();

 event_action->MOut            = &MOutput;
 // event_action->Out             = &MProcessOutput_Map;
 event_action->MProcessHit_Map = &MProcessHit_Map;
 event_action->SeDe_Map        = ExpHall->SeDe_Map;
 event_action->MBank_Map       = &MBank_Map;


 map<string, MSensitiveDetector*>::iterator it;
 for(it = ExpHall->SeDe_Map.begin(); it != ExpHall->SeDe_Map.end(); it++)
   it->second->MProcessHit_Map = &MProcessHit_Map;


 msg = " Executing initial directives...\n";
 if(use_qt) splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
 vector<string> init_commands = init_dmesg(gemcOpt);
 for(int i=0; i<init_commands.size(); i++)
    UImanager->ApplyCommand(init_commands[i].c_str());

 string exec_macro = "/control/execute " + gemcOpt.args["EXEC_MACRO"].args;

 if(use_qt)
 {
    msg = " Executing initial visual directives...\n";
    splash->showMessage(msg.c_str()); gemc_gui.processEvents(); cout << hd_msg << msg << endl;
    vector<string> init_vcommands = init_dvmesg(gemcOpt);
    for(int i=0; i<init_vcommands.size(); i++)
      UImanager->ApplyCommand(init_vcommands[i].c_str());

    if(use_qt == 1) session->SessionStart();

    splash->showMessage("Starting GUI...");
    gemc_gui.processEvents();

    gemcMainWidget gemcW(runManager, visManager, UImanager);
    gemcW.Hall_Map = &Hall_Map;
    gemcW.MMats = &MMats;
    gemcW.gemcOpt  = gemcOpt;

    gemcW.setWindowTitle( " gemc: Geant4 Simulation of the CLAS 12 Detector " );

    gemcW.show();
    splash->finish(&gemcW);

    if(exec_macro != "/control/execute no") UImanager->ApplyCommand(exec_macro.c_str());
    if(gemcOpt.args["N"].arg>0)
    {
       char command[100];
       sprintf(command, "/run/beamOn %d", (int) gemcOpt.args["N"].arg);
       UImanager->ApplyCommand(command);
    }

    //    QStyle *arthurStyle = new ArthurStyle();
    QList<QWidget *> widgets = qFindChildren<QWidget *>(&gemcW);
//     foreach (QWidget *w, widgets)
//         w->setStyle(arthurStyle);

    return gemc_gui.exec();
 }
 else
 {
    if(gemcOpt.args["N"].arg>0)
    {
       char command[100];
       sprintf(command, "/run/beamOn %d", (int) gemcOpt.args["N"].arg);
       UImanager->ApplyCommand(command);
    }
    if(exec_macro != "/control/execute no") UImanager->ApplyCommand(exec_macro.c_str());
 }
 delete runManager;
 delete session;

 return 1;
}








