  set prompt='mac-g4> ' 
  #//////////////////////////////////////////////////////////
  # Core :
  #//////////////////////////////////////////////////////////
  export MACOSX_DEPLOYMENT_TARGET=10.4
  export MAKECMD=make
  export G4INSTALL=/Users/garnier/Work/Geant4-QtDriver/trunk
  export G4SYSTEM=Darwin-g++
  export G4WORKDIR=$G4INSTALL
  export G4STTDIR=$G4WORKDIR/stt
  export G4LIB=$G4INSTALL/lib
  export G4DEBUG=1
  export G4INCLUDE=$G4INSTALL/include/geant4
  export CPPVERBOSE=1
#  export G4LIB_USE_GRANULAR=1
#  unset G4LIB_USE_GRANULAR
  # Shareable library
  export G4LIB_BUILD_SHARED=1
  #FIXME export G4LIB_BUILD_SHARED 1
  export CLHEP_BASE_DIR=/sw/
  export DYLD_LIBRARY_PATH=${DYLD_LIBRARY_PATH}:$G4LIB/$G4SYSTEM:${CLHEP_BASE_DIR}/lib
  # data :
  export G4DATA=$G4INSTALL/data
  export NeutronHPCrossSections=$G4DATA/G4NDL3.5
  export G4LEVELGAMMADATA=$G4DATA/PhotonEvaporation
  export G4RADIOACTIVEDATA=$G4DATA/RadiativeDecay
  export G4LEDATA=$G4DATA//G4EMLOW5.1
  # ////////////////////////////////////////////////////////
  # Correction of a bug on OpenGL : 
  # http://wiki.finkproject.org/index.php/Fink:Packaging:Preparing_for_10.5#OpenGL_Bug
  # ////////////////////////////////////////////////////////

  #//////////////////////////////////////////////////////////
  # GUI, Visualization :
  #//////////////////////////////////////////////////////////
  # GUI :
  export G4UI_BUILD_XM_SESSION=1
#  export G4UI_USE_XM=1
#  unset G4UI_BUILD_XM_SESSION
#  unset G4UI_USE_XM
  export G4UI_BUILD_QT_SESSION=1
  export G4UI_USE_QT=1
  # OpenGL :
  export G4VIS_BUILD_OPENGLXM_DRIVER=1
  export G4VIS_BUILD_OPENGLX_DRIVER=1
  export G4VIS_USE_OPENGLXM=1
  export G4VIS_USE_OPENGLX=1
#  unset G4VIS_BUILD_OPENGLXM_DRIVER
#  unset G4VIS_BUILD_OPENGLX_DRIVER
#  unset G4VIS_USE_OPENGLXM
#  unset G4VIS_USE_OPENGLX
  unset G4UI_BUILD_OI_SESSION
  unset G4UI_USE_OI
  unset G4VIS_USE_OIQT
  unset OIVHOME
  unset G4VIS_BUILD_OI_DRIVER


  export G4VIS_BUILD_OPENGLQT_DRIVER=1
  export G4VIS_USE_OPENGLQT=1
  #//////////////////////////////////////////////////////////
  # Inventor :
  #//////////////////////////////////////////////////////////
  #export G4VIS_BUILD_OIX_DRIVER=1
  #export G4VIS_USE_OIX=1
  unset G4VIS_USE_OIX
  unset G4VIS_BUILD_OIX_DRIVER
  # SGI-Inventor :
  # Darwin : Tiger, g++4.0 out.
  #export OIVHOME /usr/local/SGI-Inventor/2.1.5.10/macos104_gcc40/usr
  export DYLD_LIBRARY_PATH=${G4LIB}/${G4SYSTEM}
  # OpenScientist RTK Coin* :
  #export OIVHOME /Applications/OpenScientist/v15r0
  #export OIVFLAGS "-I${OIVHOME}/Resources/CoinXt/include -I${OIVHOME}/Resources/CoinGL/include"
  #export OIVLIBS "-L${OIVHOME}/lib -lCoinXt -losc_Coin"
  #export DYLD_LIBRARY_PATH "${DYLD_LIBRARY_PATH}:${OIVHOME}/lib"
  # OpenScientist devel Coin* :
  #export COINGLHOME /barrand/OpenScientist/dev/CoinGL/v1r244p0
  #export COINXTHOME /barrand/OpenScientist/dev/CoinXt/v1r122p0
  unset COINGLHOME
  unset COINXTHOME
  unset OIVFLAGS
  unset OIVLIBS
  export DYLD_LIBRARY_PATH="${DYLD_LIBRARY_PATH}:${COINGLHOME}/Darwin:${COINXTHOME}/Darwin"
  #export XENVIRONMENT visTutor/g4Xt.xrm
#  export DYLD_BIND_AT_LAUNCH 1
  #//////////////////////////////////////////////////////////
  # AIDA :
  #//////////////////////////////////////////////////////////
  #  export G4ANALYSIS_USE 1
  # OSC-dev implementation :
  #  source $HOME_BARRAND/OpenScientist/dev/setup.csh
  #  source $HOME_BARRAND/OpenScientist/dev/OnXLab/v1r0/cmt/setup.csh
  # Set AIDA compile and link access :
  #  export G4ANALYSIS_AIDA_CONFIG_CFLAGS `aida-config --cflags`
  #  export G4ANALYSIS_AIDA_CONFIG_LIBS `aida-config --libs`
  # Set PYTHONPATH to access local scripts :
  #  export PYTHONPATH ${PYTHONPATH}:.

  # OSC-15 implementation :
  #   source /barrand/OpenScientist/v15r0/aida-setup.csh
  # Set AIDA compile and link access :
  #  export G4ANALYSIS_AIDA_CONFIG_CFLAGS `aida-config --cflags`
  #  export G4ANALYSIS_AIDA_CONFIG_LIBS `aida-config --libs`
  # Set PYTHONPATH to access local scripts :
  #  export PYTHONPATH ${PYTHONPATH}:.
