//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLImmediateViewer.hh,v 1.9 2006/09/04 12:07:59 allison Exp $
// GEANT4 tag $Name: HEAD $
//
// 
// Andrew Walkden  7th February 1997
// Class G4OpenGLImmediateViewer : Encapsulates the `immediateness' of
//                                 an OpenGL viewer, for inheritance by
//                                 derived (X, Xm...) classes.

#ifdef G4VIS_BUILD_OPENGL_DRIVER

#ifndef G4OPENGLIMMEDIATEVIEWER_HH
#define G4OPENGLIMMEDIATEVIEWER_HH

#include "G4OpenGLViewer.hh"
#include "globals.hh"

class G4OpenGLSceneHandler;
class G4OpenGLImmediateSceneHandler;

class G4OpenGLImmediateViewer: virtual public G4OpenGLViewer {
  
public:
  G4OpenGLImmediateViewer (G4OpenGLImmediateSceneHandler& scene);
  void ProcessView ();
};

#endif

#endif
