<?xml version='1.0' ?>
<!-- ******************************************************************** -->  
<!--  HTML Customization Layer of Docbook XSL                             --> 
<!-- ******************************************************************** -->  
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Import the stylesheet to chunk the html output                       -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:import href="/usr/share/xml/docbook/stylesheet/nwalsh/html/chunk.xsl" />

<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Include the file which specifies common DocBook XSL parameters.      -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:include href="./G4XSLCommon.xsl" />

<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Specify the CSS stylesheet to be used for fine tuning of appearance. -->
<!--   [Note] Remember to take care the relative path to index.html       -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:param name="html.stylesheet">../xml/XSLCustomizationLayer/G4HTMLStylesheet.css</xsl:param>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Specify the chunk conditions - the chunk level and the directory to  -->
<!-- which the chunked files will be stored. You need to import the chunk -->
<!-- stylesheet beforehand.                                               -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:param name="chunk.section.depth">1</xsl:param>
<xsl:param name="base.dir">../html/</xsl:param>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Include the file which specifies the customized title page.          -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:include href="./G4BookTitlePageHTML.xsl" />

<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Use customized navigation icons.                                     -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<xsl:param name="navig.graphics">1</xsl:param>
<xsl:param name="navig.graphics.extension">.gif</xsl:param>
<xsl:param name="navig.graphics.path">AllResources/IconsGIF/</xsl:param>

<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- Define Java script and invoke by processing instruction (PI)         -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

<!-- Include JavaScript Function in HTML Header Part -->
<xsl:template name="user.head.content">
<script language="JavaScript">
function remote_win(fName)
{
   var url = "AllResources/Detector/geometry.src/" + fName;
   RemoteWin=window.open(url,"","resizable=no,toolbar=0,location=0,directories=0,status=0,menubar=0,scrollbars=0,copyhistory=0,width=520,height=520")
   RemoteWin.creator=self
}
</script>
</xsl:template>

<!-- Handle Processing Instruction named 'JavaScript' -->
<xsl:template match="processing-instruction()[local-name()= 'JavaScript']">
  <xsl:text disable-output-escaping="yes">&lt;a href="javascript:remote_win('</xsl:text>
  <xsl:value-of select="." /><xsl:text disable-output-escaping="yes">')" onMouseOver="window.status='Get alive picture...'; return true"&gt;[Rotate the Picture]&lt;br /&gt;
  </xsl:text>
  <xsl:text disable-output-escaping="yes">&lt;/a&gt;
  </xsl:text>
</xsl:template>


</xsl:stylesheet>


