//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4LineSection.cc,v 1.10 2006/06/29 18:24:16 gunter Exp $
// GEANT4 tag $Name: geant4-09-02-cand-01 $
//
// --------------------------------------------------------------------

#include "G4LineSection.hh" 

G4LineSection::G4LineSection( const G4ThreeVector& PntA, 
			      const G4ThreeVector& PntB )
  : EndpointA(PntA), 
    VecAtoB(PntB-PntA)
{ 
  fABdistanceSq = VecAtoB.mag2() ;  
  /*
  G4double distABsquared = VecAtoB.mag2() ;  
  if ( distABsquared == 0.0)
  {
    G4Exception("G4LineSection::G4LineSection()", "WrongArgumentValue",
                FatalException, "Equal points in input (line->point) ?") ;
  }
  else
  {
    inverse_square_distAB=1.0 / distABsquared ;
  }
  */
}

G4double G4LineSection::Dist( G4ThreeVector OtherPnt ) const
{
  G4double       dist_sq;  
  G4ThreeVector  VecAZ;
  G4double sq_VecAZ, inner_prod, unit_projection ; 

  VecAZ= OtherPnt - EndpointA;
  sq_VecAZ = VecAZ.mag2();

  inner_prod= VecAtoB.dot( VecAZ );
   
  //  Determine  Projection(AZ on AB) / Length(AB) 
  //
  if( fABdistanceSq != 0.0 )
  {
    //  unit_projection= inner_prod * InvsqDistAB();
    unit_projection = inner_prod/fABdistanceSq;

    if( (0. <= unit_projection ) && (unit_projection <= 1.0 ) )
    {
      dist_sq= sq_VecAZ -  unit_projection * inner_prod ;
    }
    else
    {
     //  The perpendicular from the point to the line AB meets the line
     //   in a point outside the line segment!
     
      if( unit_projection < 0. ) // A is the closest point
      {
        dist_sq= sq_VecAZ;  
      }
      else                       // B is the closest point
      {
	G4ThreeVector   EndpointB = EndpointA + VecAtoB;
        G4ThreeVector   VecBZ =     OtherPnt - EndpointB;
        dist_sq =  VecBZ.mag2();
      }
    }
  }
  else
  {
     dist_sq = (OtherPnt - EndpointA).mag2() ;   
  }  
  if( dist_sq < 0.0 ) dist_sq = 0.0 ;

  return std::sqrt(dist_sq) ;  
}

G4double G4LineSection::Distline( const G4ThreeVector& OtherPnt, 
				  const G4ThreeVector& LinePntA, 
				  const G4ThreeVector& LinePntB )
{
  G4LineSection LineAB( LinePntA, LinePntB );  // Line from A to B

  return LineAB.Dist( OtherPnt );
}
