//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLBitMapStore.hh,v 1.3 2009/02/04 16:48:40 lgarnier Exp $
// GEANT4 tag $Name:  $
//
// 
// John Allison  6th January 2007
//
// Class description
//
// Keeps bit maps on byte boundaries suitable for drawing.  For
// example, in OpenGL:
//
//   const char* circle = G4OpenGLBitMapStore::GetCircle(size, true);
//   glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
//   glBitmap(size, size, size/2., size/2., 0., 0., circle);

#ifdef G4VIS_BUILD_OPENGL_DRIVER

#ifndef G4OPENGLBITMAPSTORE_HH
#define G4OPENGLBITMAPSTORE_HH

#include "globals.hh"
#include <map>

#include "G4OpenGL.hh"
#include <GL/gl.h>
#include <GL/glu.h>

namespace G4OpenGLBitMapStore {

  enum Shape {circle, square};

  const GLubyte* GetBitMap(Shape, G4double& size, G4bool filled);
  // Size in pixels (gets changed to a rationalised value).

  struct Key{
    Key(Shape shape, G4int size, G4bool filled):
      fShape(shape), fSize(size), fFilled(filled) {}
    bool operator<(const Key& rhs) const {
      if (fShape < rhs.fShape) return true;
      else if (fSize < rhs.fSize) return true;
      else if (fFilled != rhs.fFilled) return true;
      else return false;
    }
    Shape fShape;
    G4int fSize;
    G4bool fFilled;
  };

  extern std::map<Key, GLubyte*> fStore;

}

#endif

#endif
svn add      electromagnetic/standard/src/G4WentzelVIModel.cc;
svn add      electromagnetic/standard/src/G4UrbanMscModel2.cc;
svn add      electromagnetic/standard/src/G4eMultipleScattering.cc;
svn add      electromagnetic/standard/src/G4eBremsstrahlungRelModel.cc;
svn add      electromagnetic/utils/src/G4EmSaturation.cc;
svn add      electromagnetic/utils/src/G4EmConfigurator.cc;
svn add      electromagnetic/utils/src/G4VMscModel.cc;
svn add      electromagnetic/utils/src/G4EmElementSelector.cc;
svn add      electromagnetic/utils/src/G4ElectronIonPair.cc;
svn add      electromagnetic/highenergy/src/G4eeToPGammaModel.cc;
svn add      electromagnetic/highenergy/src/G4ee2KNeutralModel.cc;
svn add      electromagnetic/highenergy/src/G4hBremsstrahlung.cc;
svn add      electromagnetic/highenergy/src/G4hPairProduction.cc;
svn add      electromagnetic/highenergy/src/G4ee2KChargedModel.cc;
svn add      electromagnetic/highenergy/src/G4eeTo3PiModel.cc;
svn add      electromagnetic/highenergy/src/G4hBremsstrahlungModel.cc;
svn add      electromagnetic/highenergy/src/G4hPairProductionModel.cc;
svn add      electromagnetic/lowenergy/include/G4IonParametrisedLossModel.icc;
svn add      electromagnetic/lowenergy/include/G4IonParametrisedLossTable.icc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionElasticChampion.cc;
svn add      electromagnetic/lowenergy/src/G4DNAScreenedRutherfordElasticModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAElastic.cc;
svn add      electromagnetic/lowenergy/src/G4LivermoreRayleighModel.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeRayleighModel.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeAnnihilationModel.cc;
svn add      electromagnetic/lowenergy/src/G4RayleighScattering.cc;
svn add      electromagnetic/lowenergy/src/G4DNADingfelderChargeIncreaseModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAEmfietzoglouExcitationModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAChampionElasticModel.cc;
svn add      electromagnetic/lowenergy/src/G4IonParametrisedLossModel.cc;
svn add      electromagnetic/lowenergy/src/G4PaulKCrossSection.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopePhotoElectricModel.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeComptonModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermorePolarizedComptonModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNABornIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAMillerGreenExcitationModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermorePhotoElectricModel.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionElasticScreenedRutherfordHE.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionElasticScreenedRutherfordLE.cc;
svn add      electromagnetic/lowenergy/src/G4OrlicLCrossSection.cc;
svn add      electromagnetic/lowenergy/src/G4DNAExcitation.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeGammaConversionModel.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionChargeTransferCH.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionPsCreationChampion.cc;
svn add      electromagnetic/lowenergy/src/G4ecpssrCrossSection.cc;
svn add      electromagnetic/lowenergy/src/G4DNARuddIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionPsCreationChampionPartial.cc;
svn add      electromagnetic/lowenergy/src/G4DNAChargeDecrease.cc;
svn add      electromagnetic/lowenergy/src/G4LivermoreComptonModel.cc;
svn add      electromagnetic/lowenergy/src/G4FinalStatePsCreationChampion.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeBremsstrahlungModel.cc;
svn add      electromagnetic/lowenergy/src/G4FinalStateElasticChampion.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNABornExcitationModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermoreGammaConversionModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAIonisation.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionChargeTransferExp.cc;
svn add      electromagnetic/lowenergy/src/G4FinalStateChargeTransferProton.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeComptonModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermorePolarizedComptonModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNABornIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAMillerGreenExcitationModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermorePhotoElectricModel.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionElasticScreenedRutherfordHE.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionElasticScreenedRutherfordLE.cc;
svn add      electromagnetic/lowenergy/src/G4OrlicLCrossSection.cc;
svn add      electromagnetic/lowenergy/src/G4DNAExcitation.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeGammaConversionModel.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionChargeTransferCH.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionPsCreationChampion.cc;
svn add      electromagnetic/lowenergy/src/G4ecpssrCrossSection.cc;
svn add      electromagnetic/lowenergy/src/G4DNARuddIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionPsCreationChampionPartial.cc;
svn add      electromagnetic/lowenergy/src/G4DNAChargeDecrease.cc;
svn add      electromagnetic/lowenergy/src/G4LivermoreComptonModel.cc;
svn add      electromagnetic/lowenergy/src/G4FinalStatePsCreationChampion.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeBremsstrahlungModel.cc;
svn add      electromagnetic/lowenergy/src/G4FinalStateElasticChampion.cc;
svn add      electromagnetic/lowenergy/src/G4PenelopeIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNABornExcitationModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermoreGammaConversionModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAIonisation.cc;
svn add      electromagnetic/lowenergy/src/G4CrossSectionChargeTransferExp.cc;
svn add      electromagnetic/lowenergy/src/G4FinalStateChargeTransferProton.cc;
svn add      electromagnetic/lowenergy/src/G4DopplerProfile.cc;
svn add      electromagnetic/lowenergy/src/G4DNADingfelderChargeDecreaseModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermoreIonisationModel.cc;
svn add      electromagnetic/lowenergy/src/G4LivermorePolarizedRayleighModel.cc;
svn add      electromagnetic/lowenergy/src/G4DNAChargeIncrease.cc;
svn add      hadronic/cross_sections/src/G4GGNuclNuclCrossSection.cc;
svn add      hadronic/cross_sections/src/G4CrossSectionDataSetRegistry.cc;
svn add      hadronic/models/neutron_hp/src/G4NeutronHPFinalState.cc;
svn add      hadronic/models/incl/src/G4AblaFission.cc;
svn add      hadronic/models/incl/src/G4Ranecu.cc;
svn add      hadronic/models/incl/src/G4AblaFissionSimfis18.cc;
svn add      hadronic/models/rpg/src/G4RPGPionInelastic.cc;
svn add      hadronic/models/rpg/src/G4RPGNucleonInelastic.cc;
svn add      hadronic/models/parton_string/diffraction/src/G4FTFParameters.cc;
svn add      hadronic/models/parton_string/diffraction/src/G4ElasticHNScattering.cc;
svn add      hadronic/models/pre_equilibrium/exciton_model/src/G4PreCompoundAlpha.cc;
svn add      hadronic/models/pre_equilibrium/exciton_model/src/G4PreCompoundHe3.cc;
svn add      hadronic/models/pre_equilibrium/exciton_model/src/G4PreCompoundDeuteron.cc;
svn add      hadronic/models/pre_equilibrium/exciton_model/src/G4PreCompoundNeutron.cc;
svn add      hadronic/models/pre_equilibrium/exciton_model/src/G4PreCompoundTriton.cc;
svn add      hadronic/models/pre_equilibrium/exciton_model/src/G4PreCompoundProton.cc;
svn add      hadronic/models/chiral_inv_phase_space/interface/src/G4QIonIonElastic.cc;
svn add      hadronic/models/chiral_inv_phase_space/interface/src/G4GammaNuclearReaction.cc;
svn add      hadronic/models/chiral_inv_phase_space/calcul/G4NuMuXQ2Integration_N.cc;
svn add      hadronic/models/chiral_inv_phase_space/calcul/G4BoundMuDecInElIntegration.cc;
svn add      hadronic/models/chiral_inv_phase_space/calcul/G4NuElXQ2Integration.cc;
svn add      hadronic/models/chiral_inv_phase_space/calcul/G4SurfaceCalculation.cc;
svn add      hadronic/models/chiral_inv_phase_space/calcul/G4NuElXQ2Integration_N.cc;
svn add      hadronic/models/chiral_inv_phase_space/calcul/G4MultyFragmentationTest.cc;
svn add      hadronic/management/src/G4HadronicProcessStore.cc;
svn add      cuts/src/G4ProductionCutsTableMessenger.cc;
