//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4Wt.cc,v 1.7 2007/11/15 18:24:28 lgarnier Exp $
// GEANT4 tag $Name: HEAD $
//
// L. Garnier
//#define G4INTY_BUILD_WT

#if defined(G4INTY_BUILD_WT) || defined(G4INTY_USE_WT)

#include <stdlib.h>
#include <string.h>

#include "G4ios.hh"

#include "G4Wt.hh"

#include <Wt/WApplication>
#include <Wt/WEnvironment>



G4Wt* G4Wt::instance    = NULL;

static G4bool WtInited  = FALSE;

#define NewString(str)  \
 ((str) != NULL ? (strcpy((char*)malloc((unsigned)strlen(str) + 1), str)) : NULL)

/***************************************************************************/
// FIXME Should nevr eb called
G4Wt* G4Wt::getInstance (
 ) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  return G4Wt::getInstance (0,NULL,(char*)"Geant4");
}
/***************************************************************************/
G4Wt* G4Wt::getInstance (
 const Wt::WEnvironment& env
) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if (instance==NULL) {
    instance = new G4Wt(env);
  }
  return instance;
}
/***************************************************************************/
G4Wt::G4Wt (
 const Wt::WEnvironment& env
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
#ifdef GEANT4_WT_DEBUG
  printf("G4Wt::G4Wt try to inited Wt\n");
#endif
  // Check if Wt already init in another external app

  int argn = (env.arguments()).size();

  argn = 0;
  char **argv = (char**)malloc(argn * sizeof(char*));
  // =======================
  // FIXME !!!!!!!!!!!!!!!!!!
  // =======================

//   if(argv!=NULL) {
//     for(G4int argi=0;argi<argn;argi++) {
//       // FIXME
//       argv[argi] = (char*)NewString (env.arguments()[argi]);
//     }
//   }
  if(wApp) {
      WtInited  = TRUE;
      //#if WT_VERSION < 0x040000
      //      SetMainInteractor (&wApp);
      //#else
      SetMainInteractor (wApp);
      //#endif
      SetArguments      (argn,argv);
#ifdef GEANT4_WT_DEBUG
      printf("G4Wt::G4Wt alredy inited in external \n");
#endif
  } else {

    if(WtInited==FALSE) {  //Wt should be Inited once !
#ifdef GEANT4_WT_DEBUG
      printf("G4Wt::G4Wt inited Wt\n");
#endif
// #if WT_VERSION < 0x040000

//       wApp = new WApplication (env);
//       //    WApplication wApp(a_argn, argv);
//       //    if(&wApp == NULL) {
// #else
      new Wt::WApplication (env);
// #endif
      if(!wApp) {
        
        G4cout        << "G4Wt : Unable to init Wt." << G4endl;
      } else {
        WtInited  = TRUE;
        //#if WT_VERSION < 0x040000
        //      SetMainInteractor (&wApp);
        //#else
        SetMainInteractor (wApp);
        //#endif
        SetArguments      (argn,argv);
#ifdef GEANT4_WT_DEBUG
        printf("G4Wt::G4Wt inited Wt END\n");
#endif
      }
    }
  }
#ifdef GEANT4_WT_DEBUG
  if (wApp) {
    printf("G4Wt::wApp exist\n");
  }  else {
    printf("G4Wt::wApp not exist\n");
  }
#endif
  //  AddDispatcher     ((G4DispatchFunction)XtDispatchEvent);
}
/***************************************************************************/
G4Wt::~G4Wt (
) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if(this==instance) {
    instance = NULL;
  }
}
/***************************************************************************/
G4bool G4Wt::Inited (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  return WtInited;
}
/***************************************************************************/
/**
  Si j'ai bien compris, cette fonction ne sert  rien
 */
void* G4Wt::GetEvent (
) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
//FIXME
//   G4cout        << "G4Wt : Rien compris a cette fonction G4Wt::GetEvent." << G4endl;
//  static XEvent  event;
//  if(appContext==NULL) return NULL;
//  if(mainApp==NULL) return NULL;
//  WtAppNextEvent (appContext, &event);
//  return         &event;
  printf("*");
  return 0;
}
/***************************************************************************/
void G4Wt::FlushAndWaitExecution (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  //  printf("G4Wt::FlushAndWaitExecution ::  Flush ....\n");
  if(!wApp) return;
  wApp->processEvents();
}

#endif



