#ifndef MEMPHYSTrackInformation_h
#define MEMPHYSTrackInformation_h 1


#include "globals.hh"
#include "G4Track.hh"
#include "G4Allocator.hh"
#include "G4VUserTrackInformation.hh"

// Maximilien Fechner, december 2004
// Information class for flagging the secondaries
// I'm interested in (namely gammas from pi0s and secondaries
// from muon decay
class MEMPHYSTrackInformation : public G4VUserTrackInformation {
private:
  G4bool saveit; 

public:
  MEMPHYSTrackInformation() : saveit(true) {}
  MEMPHYSTrackInformation(const MEMPHYSTrackInformation* aninfo) 
  { saveit = aninfo->saveit;}
  virtual ~MEMPHYSTrackInformation() {}
  MEMPHYSTrackInformation(const G4Track* );
  
  inline void *operator new(size_t);
  inline void operator delete(void *aTrackInfo);
  inline int operator ==(const MEMPHYSTrackInformation& right) const
  {return (this==&right);}

  void Print() const;

};

extern G4Allocator<MEMPHYSTrackInformation> aMEMPHYSTrackInfoAllocator;

inline void* MEMPHYSTrackInformation::operator new(size_t) { 
  void* aTrackInfo;
  aTrackInfo = (void*)aMEMPHYSTrackInfoAllocator.MallocSingle();
  return aTrackInfo;
}

inline void MEMPHYSTrackInformation::operator delete(void *aTrackInfo){ 
  aMEMPHYSTrackInfoAllocator.FreeSingle((MEMPHYSTrackInformation*)aTrackInfo);
}


#endif
