// Geant4:
#include "G4ios.hh"
#include "G4RunManager.hh"
#include "G4UImanager.hh"

//MEMPHYS:
#include "MEMPHYS/Analysis.hh"
#include "MEMPHYS/DetectorConstruction.hh"
#include "MEMPHYS/PhysicsList.hh"
#include "MEMPHYS/PhysicsMessenger.hh"
#include "MEMPHYS/PrimaryGeneratorAction.hh"
#include "MEMPHYS/EventAction.hh"
#include "MEMPHYS/RunAction.hh"
#include "MEMPHYS/StackingAction.hh"
#include "MEMPHYS/TrackingAction.hh"
#include "MEMPHYS/SteppingAction.hh"


//JEC AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

//JEC Lib :
#include <Lib/System.h>

/////////////////////////////////////////////////////////////////
int main(
	 int //aArgc 
	 , char** //aArgv
	 )
{
  //AIDA Analysis factory
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cout << "MEMPHYS_batch :"
              << " AIDA not found." << std::endl;
    return 0;
  }
  //Book all the histo, tuple 
  MEMPHYS::Analysis* analysis = new MEMPHYS::Analysis(*aida);


  // Construct the default run manager
  G4RunManager* runManager = new G4RunManager;
  

  runManager->SetGeometryToBeOptimized(false); //JEC 21/4/06 test to speed up the closing phase
                                               //note that G.B suspect memory leak with valgrind


  // UserInitialization classes (mandatory)



  //JEC 18/11/05 give the "analysis" to fill geometry ITuple
  MEMPHYS::DetectorConstruction* MEMPHYSdetector = 
    new MEMPHYS::DetectorConstruction(*analysis); 

  runManager->SetUserInitialization(MEMPHYSdetector);

  runManager->SetUserInitialization(new MEMPHYS::PhysicsList);

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/jobOptions.mac"; //JEC FIXME this comes from JHF
    UI->ApplyCommand("/control/execute "+file);  
  }



  // Set user action classes
  MEMPHYS::PrimaryGeneratorAction* myGeneratorAction = new MEMPHYS::PrimaryGeneratorAction(MEMPHYSdetector);
  runManager->SetUserAction(myGeneratorAction);

  MEMPHYS::RunAction* myRunAction = new MEMPHYS::RunAction();

  runManager->SetUserAction(myRunAction);


  runManager->SetUserAction(new MEMPHYS::EventAction(*analysis,
						   myRunAction, 
						   MEMPHYSdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new MEMPHYS::TrackingAction);

  runManager->SetUserAction(new MEMPHYS::StackingAction);
  runManager->SetUserAction(new MEMPHYS::SteppingAction); //JEC 15/12/05 Add user SteppingAction

  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("MEMPHYSROOT")+"/scripts/Geant4/init.g4m"; //JEC FIXME this comes from JHF
    UI->ApplyCommand("/control/execute "+file);  
  }

  runManager->BeamOn(1);


  //JEC interactive session  delete visManager;

  delete runManager;
  delete analysis;
  delete aida;
  return 0;
}


