//std
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <cmath>
#include <fstream>
#include <iostream>

//Globes
#include <globes/globes.h>

// AIDA :
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/IHistogramFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>
#include <AIDA/ITuple.h>


/*
  Sensibility to delta and theta_13
  Theta_13=0 and Delta=0 for the true value of the reference experiment
  use glbChiDeltaTheta to marginalized other all parameters except of 
  the current delta and theta

  24/10/05 (JEC) 
  . transfert the #defined variables to Data Cards
  . polish the code

 */

float TH12, TH23,DMQ21,DMQ31; //theta12,theta23,Dm^2_21,Dm^2_31

//The true value Theta13 and Delta_CP
#define TH13_0   0.0  
#define DELTA_0  0.0

int ND; //number of bins to scan delta parameter [-pi,+pi]
int NTH; //number of bins to scan theta13 parameter
float LOG10MIN; //minimal Log10(sin^2(2theta13))
float LOG10MAX; //minimal Log10(sin^2(2theta13))

/**************************************/
/*           main                     */
/**************************************/

int main(int argc, char *argv[])
{
  //Process data card file
  std::string ROOTDIR = getenv("GLBFREJUSROOT");
  std::string DATACARD;
  DATACARD = ROOTDIR + "/run/sensi.data"; 
  std::ifstream fileDataCard;
  std::cout << "Open DataCard file : " << DATACARD <<std::endl;
  fileDataCard.open(DATACARD.data());
  std::string DUMMYSTR; //comment string of the variables

  std::string ROOTFILENAME;

  fileDataCard >> DUMMYSTR >> TH12;  
  std::cout << DUMMYSTR << TH12 << std::endl; 
  fileDataCard >> DUMMYSTR >> TH23;  
  std::cout << DUMMYSTR << TH23 << std::endl; 
  fileDataCard >> DUMMYSTR >> DMQ21;  
  std::cout << DUMMYSTR << DMQ21 << std::endl; 
  fileDataCard >> DUMMYSTR >> DMQ31;  
  std::cout << DUMMYSTR << DMQ31 << std::endl; 
  fileDataCard >> DUMMYSTR >> ROOTFILENAME;  
  ROOTFILENAME += ".root";
  std::cout << DUMMYSTR <<ROOTFILENAME  << std::endl; 

  fileDataCard >> DUMMYSTR >> ND;  
  std::cout << DUMMYSTR << ND  << std::endl; 
  fileDataCard >> DUMMYSTR >> NTH;  
  std::cout << DUMMYSTR << NTH  << std::endl; 
  fileDataCard >> DUMMYSTR >> LOG10MIN;  
  std::cout << DUMMYSTR << LOG10MIN << std::endl; 
  fileDataCard >> DUMMYSTR >> LOG10MAX;  
  std::cout << DUMMYSTR << LOG10MAX << std::endl; 


  //init AIDA for Histo/Tuple
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cerr  << " AIDA not found." << std::endl;
    return 0;
  }

  //ROOT tree :
  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  std::string opts = "export=root";
  AIDA::ITree* fTree = 
    treeFactory->create(ROOTFILENAME,"root",false,true,opts);
  delete treeFactory;

 //Booking Tuple
  AIDA::ITupleFactory* tf = aida->createTupleFactory(*fTree);

  int NumberOfColumn = 7;
  std::vector<std::string> column(NumberOfColumn);
  const char* c_column[] = {"theta12", "theta13", "theta23", 
			    "deltaCP", "dm21", "dm31", 
			    "chi2"};
  std::vector<std::string> coltype(NumberOfColumn);
  const char* c_coltype[] = {"double","double","double",
			     "double","double","double",
			     "double"};
  for (int icol = 0; icol<NumberOfColumn; ++icol) {
    column[icol]  = c_column[icol];
    coltype[icol] = c_coltype[icol];
  }

  AIDA::ITuple* myTuple = 
    tf->create("SplGlb","Delta-Theta sensibility",column,coltype);
  
  //Init Globes
  glbInit(argv[0]);
  glbInitExperiment("../data/SPL.glb", 
		    &glb_experiment_list[0], 
		    &glb_num_of_exps);

  // true values (reference for future Chi2 computations) 
  glb_params true_values = glbAllocParams();
  glbDefineParams(true_values, TH12, TH13_0, TH23, DELTA_0, DMQ21, DMQ31);
  glbPrintParams(stdout,true_values);
  
  glbSetOscillationParameters(true_values);  
  glbSetRates();
  
  // set Starting Values
  glb_params start_values = glbAllocParams();
  glbDefineParams(start_values, TH12, TH13_0, TH23, DELTA_0, DMQ21, DMQ31);
  glbSetStartingValues(start_values);
  glbPrintParams(stdout,start_values);
  glbFreeParams(start_values);
  
  // init test values
  glb_params test_values = glbAllocParams();
  glbDefineParams(test_values, TH12, TH13_0, TH23, DELTA_0, DMQ21, DMQ31);
  glbPrintParams(stdout,test_values);


  // input errors
  // 5% on Solar parameters, the atmospheric parameters are 
  // better determined by disappearence channels here 30% to drive the
  // minimizer
  glb_params input_errors = glbAllocParams();
  glbDefineParams(input_errors, 
		  TH12*0.05, 0., TH23*0.30, 0., 
		  DMQ21*0.05, fabs(DMQ31)*0.30);
  glbSetDensityParams(input_errors, 0.05, GLB_ALL);
  glbSetInputErrors(input_errors);


  glb_params fit_values = glbAllocParams(); //final minimization


  std::cout << "Start to loop...." << std::endl;

  double res;
  double fit_theta12, fit_theta13,fit_theta23,fit_deltaCP,fit_dmSol,fit_dmAtm;
  double delta, log10s2, sq2th, th;

  for(int j = 0; j < ND; j++)
  {
    //scan de -Pi a +Pi pour delta_CP
    delta = -M_PI + 2.0 * M_PI * double(j) / (ND-1);
    
    glbSetOscParams(test_values, delta, GLB_DELTA_CP);

    for(int k = 0; k < NTH; k++)
    {      
      log10s2 = LOG10MIN + (LOG10MAX-LOG10MIN) * double(k) / (NTH-1);
      sq2th = pow(10.,log10s2);
      th = 0.5 * asin(sqrt(sq2th));
      glbSetOscParams(test_values, th, GLB_THETA_13);
      
      std::cout << "Consider (k,j) = (" << k << "," << j << ")" << std::endl;
      //Param correlation
      res = glbChiThetaDelta(test_values,fit_values,0);
      

      //For sensitivity plot store the outcome of the fit
      fit_theta12 = glbGetOscParams(fit_values, GLB_THETA_12);
      fit_theta13 = glbGetOscParams(fit_values, GLB_THETA_13);
      fit_theta23 = glbGetOscParams(fit_values, GLB_THETA_23);
      fit_deltaCP = glbGetOscParams(fit_values, GLB_DELTA_CP);
      fit_dmSol   = glbGetOscParams(fit_values, GLB_DM_SOL);
      fit_dmAtm   = glbGetOscParams(fit_values, GLB_DM_ATM);
      
      myTuple->fill(0,fit_theta12);
      myTuple->fill(1,fit_theta13);
      myTuple->fill(2,fit_theta23);
      myTuple->fill(3,fit_deltaCP);
      myTuple->fill(4,fit_dmSol);
      myTuple->fill(5,fit_dmAtm);
      myTuple->fill(6,res);
      myTuple->addRow();
      
      //       std::cout << "Theta_12(rad) " <<  fit_theta12 << " "
      //  		<< "Theta_13(rad) " <<  fit_theta13 << " "
      // 		<< "Theta_23(deg) " <<  fit_theta23*180./M_PI << " "
      // 		<< "Delta_CP(deg) " <<  fit_deltaCP*180./M_PI << " "
      // 		<< "DM_21    " <<  fit_dmSol   << " "
      // 		<< "DM_31    " <<  fit_dmAtm   << " "
      // 		<< "Chi2 (fin) " << res
      // 		<< std::endl;       
      
    }//Loop on Theta13
  }//Loop on DeltaCP
  
  glbFreeParams(true_values);
  glbFreeParams(test_values);
  glbFreeParams(fit_values);


  //save Tuple
  fTree->commit();
  delete fTree;
  
  delete aida;
  return 0;
}
    




