{

  Int_t nLogSin22q13 = 21;
  Double_t logSin2Min = -4;
  Double_t logSin2Max = -2;
  Double_t logSin2BinWidth = 
    (logSin2Max - logSin2Min)/double(nLogSin22q13-1.);
  Double_t logSin2EdgeMax = logSin2Max + logSin2BinWidth/2.;
  Double_t logSin2EdgeMin = logSin2Min - logSin2BinWidth/2.;

  Int_t nDeltaCP  = 31;
  Double_t deltaMin = -180.; //degree
  Double_t deltaMax =  180.;
  Double_t deltaBinWidth = (deltaMax - deltaMin)/double(nDeltaCP-1.);
  Double_t deltaEdgeMax = deltaMax + deltaBinWidth/2.;
  Double_t deltaEdgeMin = deltaMin - deltaBinWidth/2.;

  TLegend* leg = new TLegend(0.6,0.7,0.9,0.9);
  leg->SetTextFont(gStyle->GetTextFont());
  leg->SetTextSize(0.07);
  leg->SetFillColor(10);
  

  TCanvas* c1 = new TCanvas("c1","Contour",100,100,600,600);
  //  c1->SetGridx();
  // c1->SetGridy();
  c1->SetLogy();

  TH2D* hdum = new TH2D("hdum","",
			nDeltaCP,deltaMin,deltaMax,
			nLogSin22q13,TMath::Power(10.,logSin2Min),
			TMath::Power(10.,logSin2Max)
			);
  hdum->SetXTitle("#delta_{CP} (deg.)");
  hdum->SetYTitle("sin^{2}(2#theta_{13})");
  hdum->Draw();

  TPad *overlay = new TPad("overlay","",
			   gStyle->GetPadLeftMargin(),
			   gStyle->GetPadBottomMargin(),
			   1-gStyle->GetPadRightMargin(),
			   1-gStyle->GetPadTopMargin());
  overlay->SetFillStyle(4000);
  overlay->Draw();
  overlay->Range(deltaMin,logSin2Min,deltaMax,logSin2Max);

  TFile f1("./SPLSensi440kT.root");
  TTree* tree1 = (TTree*)f1.Get("SplGlb");
  TH2D* histo1 = new TH2D("histo1"," Theta vs Delta",
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax,
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax
			  );

  tree1->Project(histo1->GetName(),"TMath::Log10(pow(sin(2*theta13),2)):deltaCP/pi*180.","chi2");
  histo1->SetContour(1);
  histo1->SetContourLevel(0,4.605); //Chi2 for 2 dof and 90% CL
  histo1->SetLineColor(2); //red
  overlay->cd();
  histo1->Draw("CONT3 SAME");
  leg->AddEntry(histo1,"440kT","l");


  TFile f2("./SPLSensi330kT.root");
  TTree* tree2 = (TTree*)f2.Get("SplGlb");
  TH2D* histo2 = new TH2D("histo2"," Theta vs Delta",
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax,
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax
			  );

  tree2->Project(histo2->GetName(),"TMath::Log10(pow(sin(2*theta13),2)):deltaCP/pi*180.","chi2");
  histo2->SetContour(1);
  histo2->SetContourLevel(0,4.605); //Chi2 for 2 dof and 90% CL
  histo2->SetLineStyle(2); //dashed
  histo2->SetLineColor(2); //red
  overlay->cd();
  histo2->Draw("CONT3 SAME");
  leg->AddEntry(histo2,"330kT","l");


  TFile f3("./SPLSensi220kT.root");
  TTree* tree3 = (TTree*)f3.Get("SplGlb");
  TH2D* histo3 = new TH2D("histo3"," Theta vs Delta",
			  nDeltaCP,deltaEdgeMin,deltaEdgeMax,
			  nLogSin22q13,logSin2EdgeMin,logSin2EdgeMax
			  );

  tree3->Project(histo3->GetName(),"TMath::Log10(pow(sin(2*theta13),2)):deltaCP/pi*180.","chi2");
  histo3->SetContour(1);
  histo3->SetContourLevel(0,4.605); //Chi2 for 2 dof and 90% CL
  histo3->SetLineStyle(3); //dotted
  histo3->SetLineColor(2); //red
  overlay->cd();
  histo3->Draw("CONT3 SAME");
  leg->AddEntry(histo3,"220kT","l");





  //Add text

  TLatex* txt1 = new TLatex(-150,-3.7,"90% CL");
  txt1->SetTextSize(0.07);
  txt1->Draw();

  TLatex* txt2 = new TLatex(-150,-2.3,"2y(+) & 8y(-)");
  txt2->SetTextSize(0.07);
  txt2->Draw();


  TLatex* txt3 = new TLatex(60,-3.7,"#delta^{tr}_{CP}=#theta^{tr}_{13}=0");
  txt3->SetTextSize(0.07);
  txt3->Draw();



  leg->Draw("SAME");
  overlay->Update();

}
