/*
 * AIDA analysis program over MEMPHYS.root file.
 */

// AIDA :
#include <AIDA/AIDA.h>

// std :
#include <iostream>

//////////////////////////////////////////////////////////////////////////////
int main(
 int //aArgc
,char** //aArgv
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //std::string arg1 = aArgc>=2?aArgv[1]:"";

  std::string program = "MEMPHYS_analysis";
  std::string header = program + " : ";

  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cout << header << "AIDA not found." << std::endl;
    return 1;
  }

  AIDA::ITreeFactory* treeFactory = aida->createTreeFactory();
  if(!treeFactory) {
    std::cout << header << "can't get a TreeFactory." << std::endl;
    return 1;
  }

  AIDA::ITree* tree = treeFactory->create("MEMPHYS.root","root",true,false);
  if(!tree) {
    std::cout << header << "can't open data file." << std::endl;
    return 1;
  }

  AIDA::IManagedObject* object = tree->find("Event");
  if(!object) {
    std::cout << header 
              << "object Event not found in tree." 
              << std::endl;
    return 1;
  }
  AIDA::ITuple* tuple = dynamic_cast<AIDA::ITuple*>(object);
  if(!tuple) {
    std::cout << header << "object not an AIDA::ITuple." << std::endl;
    return 1;
  }

  int coln = tuple->columns();
  for(int index=0;index<coln;index++) {
    std::cout << header 
              << " icol = " << index
              << ", label = " << tuple->columnName(index) 
              << ", type = " << tuple->columnType(index) 
              << std::endl;
  }

  std::cout << header << "rows = " << tuple->rows() << std::endl;

  //int nentries = tuple->rows();
  int nentries = 100000;
  std::cout << header 
            << "traitements de " << nentries << " entrees" 
            << std::endl;

  int irow = 0;
  tuple->start();
  while(tuple->next() && (irow<nentries)) {

    int eventId = tuple->getInt(0);
    int inputEvtId = tuple->getInt(1);
    int interMode = tuple->getInt(2);
    int vtxVol = tuple->getInt(3);

    int nPart = tuple->getInt(5);
    int leptonIndex = tuple->getInt(6);
    int protonIndex = tuple->getInt(7);

    int nHits = tuple->getInt(9);
    int nDigits = tuple->getInt(11);
    double sumPE = tuple->getDouble(12);

    std::cout << ">>>>>>>>>>>>> Event{" << irow << "}: "
    	      << " evt Id " << eventId 
    //	      << " evt Input Id " << inputEvtId
    //	      << "\n interaction mode " << interMode
    //	      << " start in volume " << vtxVol << "\n"
    	      <<" #tracks: " << nPart
    	      <<" #hits: " << nHits
              <<" #digits: " << nDigits
              <<" sumPE " << sumPE
    	      << std::endl;

    irow++;
  }

  delete treeFactory;
  delete tree;
  delete aida;

  return 0;
}
