#ifndef ELYSEDetectorConstruction_H
#define ELYSEDetectorConstruction_H 1

//Geant4
#include "G4ThreeVector.hh"
#include "G4VUserDetectorConstruction.hh"
#include "globals.hh"



class G4VPhysicalVolume;
class G4OpticalSurface;

namespace ELYSE {

class DetectorMessenger;
class TrappingVolume;

class DetectorConstruction : public G4VUserDetectorConstruction {
 public:
  //Ctor & Dtor
  DetectorConstruction();
  virtual ~DetectorConstruction();
  
  //inherited method
  G4VPhysicalVolume* Construct();

  //assecors
  void SetWaterDimensions(G4ThreeVector dim);
  void SetTyvekThickness(G4double thick);

  //rebuild the geometry based on changes. must be called
  void UpdateGeometry();
  G4bool GetUpdated(){return updated;}

private:

  // The Construction routines
  void   ConstructMaterials();



  //Sensitive volume to trap all particles passing through it
  TrappingVolume* aTrappingVolume;

  //Water, Tyvek surface
  G4OpticalSurface* OpWaterTyvekSurface;
  //Water, Air surface
  G4OpticalSurface* OpWaterAirSurface;
  //Tyvek - Air surface
  //  G4OpticalSurface* OpTyvekAirSurface;
  //Tyvek - Glass surface (kill the particle)
  G4OpticalSurface* OpTyvekGlassSurface;
  // The messenger we use to change the geometry.
  DetectorMessenger* messenger;

  //Sign if the geometry has been modified
  G4bool updated;

  //---Volume lengths
  
  //Experimental Hall
  G4double expHall_x;
  G4double expHall_y;
  G4double expHall_z;
  
  //Water box volume
  G4double water_x;
  G4double water_y;
  G4double water_z;


  //Thickness of the tyvek sheet
  G4double tyvek_thickness;

  
};

}


#endif

