#ifndef ELYSETrappVolHit_h
#define ELYSETrappVolHit_h 1

//Geant4
#include "G4VHit.hh"
#include "G4THitsCollection.hh"
#include "G4Allocator.hh"
#include "G4ThreeVector.hh"
#include "G4ios.hh"

class G4VSolid;

namespace ELYSE {

class TrappVolHit : public G4VHit {
 public:
  
  TrappVolHit();
  virtual ~TrappVolHit();
  
  inline void* operator new(size_t);
  inline void  operator delete(void*);
  
  //dump
  void Print();

  //Used by GB for visualisation
  virtual const std::map<G4String,G4AttDef>* GetAttDefs() const;
  virtual std::vector<G4AttValue>* CreateAttValues() const;
  
 public:
  
  void SetTime(G4double hitTime)          { time = hitTime; }
  void SetEtot(G4double hitEnergy)        { eTot = hitEnergy; }
  void SetCoordinates(const G4ThreeVector& hitPosition) { position = hitPosition;}
  void SetTrkId(G4int trackID)            { trkId = trackID; }
  void SetParentId(G4int trackParentID)   { parentId = trackParentID; }
  void SetPDGEncoding(G4int trackPDGcode) { pdg = trackPDGcode; }
  void SetEdep(G4double energyDeposition) { edep = energyDeposition; }

  G4double GetTime() const                    { return time; }
  G4double GetEtot() const                    { return eTot; }
  const G4ThreeVector& GetCoordinates() const { return position; }
  G4int GetTrkId() const                      { return trkId; }
  G4int GetParentId() const                   { return parentId; }
  G4int GetPDGEncoding() const                { return pdg; }
  G4double GetEdep() const                    { return edep; }
  
 private:
  //forbid copy & assignment
  TrappVolHit(const TrappVolHit&);
  const TrappVolHit& operator=(const TrappVolHit&);

 private:

  //for visualisation
  G4VSolid*     virtualSolid; //a Box to represent the hit
  //data
  G4double      time;      //time of hit creation
  G4double      eTot;      //Total energy of the particle creating the hit
  G4ThreeVector position;  //position of the hit
  G4int         trkId;     //Id of the particle
  G4int         parentId;  //Id of the parent of the particle
  G4int         pdg;       //PDG code of the particle
  G4double      edep;      //Energy deposit
  

};
}

//----------------------------------------------------------------

//JEC 10/1/06 introduce ELYSE
namespace ELYSE {
  typedef G4THitsCollection<TrappVolHit> TrappVolHitsCollection;
  extern G4Allocator<TrappVolHit> TrappVolHitAllocator;
}

inline void* ELYSE::TrappVolHit::operator new(size_t) {
  void *aHit;
  aHit = (void *) ELYSE::TrappVolHitAllocator.MallocSingle();
  return aHit;
}

inline void ELYSE::TrappVolHit::operator delete(void *aHit) {
  ELYSE::TrappVolHitAllocator.FreeSingle((ELYSE::TrappVolHit*) aHit);
}

#endif
