#ifndef ELYSETrappingVolume_h
#define ELYSETrappingVolume_h 1

//Geant4
#include "G4VSensitiveDetector.hh"

//ELYSE
#include "ELYSE/TrappVolHit.hh"

class G4Step;
class G4HCofThisEvent;

namespace ELYSE {

class DetectorConstruction;


class TrappingVolume : public G4VSensitiveDetector {
 public:
  TrappingVolume(G4String, DetectorConstruction*); //JEC 25/1/06
  virtual ~TrappingVolume();
  
  void   Initialize(G4HCofThisEvent*);
  G4bool ProcessHits(G4Step*, G4TouchableHistory*);
  G4bool ProcessHits_constStep(const G4Step*, G4TouchableHistory*);
  void   EndOfEvent(G4HCofThisEvent*);
  
 private:

  TrappVolHitsCollection* hitsCollection;
  G4int HCID;
  
  DetectorConstruction* ELYSEDetConstruction;

};

}
#endif

