//
//  All functions here should be OnX callbacks, that is to say
// functions with signature :
//   extern "C" {
//     void callback_without_arguments(Slash::UI::IUI&);
//     void callback_with_arguments(Slash::UI::IUI&,const std::vector<std::string>&);
//   }
//

#include <OnX/Helpers/OnX.h>
#include <OnX/Helpers/Inventor.h>

// Slash :
#include <Slash/Core/ISession.h>
#include <Slash/UI/IUI.h>

// Lib :
#include <Lib/Manager.h>
#include <Lib/Out.h>

// BatchLab :
#include <BatchLab/Helpers/AIDA.h>

// OnXLab :
#include <OnXLab/Helpers/OnXLab.h>

// G4Lab :
#include <G4Lab/Interfaces/IGeant4Manager.h>

// ELYSE :
#include <ELYSE/IAppManager.hh>

extern "C" {

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void ELYSE_Initialize(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
// Should be executed (in a widget create callback) 
// when the GUI is constructed 
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  aUI.setCallback("OnX_File_exit","activate","DLD","G4Lab G4Lab_exit");
  //StoreTrajectory customized in TrackingAction.
  //aUI.executeScript("G4","/tracking/storeTrajectory 1");

  Slash::UI::ISoViewer* soViewer = ui_SoViewer(aUI);
  if(soViewer) {
    soViewer->setDecoration(true);
    soViewer->setViewing(true);
  }

  Slash::Core::ISession& session = aUI.session();

  session.setParameter("event.scan","yes");//Used in ELYSE_eventEnd callback.
    
  IGeant4Manager* g4Manager = 
    Lib_findManager(session,"Geant4Manager",IGeant4Manager);
  if(!g4Manager) {
    Lib::Out out(session.printer());
    out << "ELYSE_Initialize :"
        << " Geant4Manager not found."
        << Lib::endl;
  } else {
    // Declare a callback executed at each end of event :
    g4Manager->setEventEndScript("DLD","ELYSE ELYSE_eventEnd");
  }  
    
  ELYSE::IAppManager* appManager = 
    Lib_findManager(session,"ELYSE::AppManager",ELYSE::IAppManager);
  if(!appManager) {
    Lib::Out out(session.printer());
    out << "ELYSE_Initialize :"
        << " ELYSE::AppManager not found."
        << Lib::endl;
  } else {
    // Create the Types. Initialize G4Lab SoNodes.
    appManager->initialize();
  }
}
//////////////////////////////////////////////////////////////////////////////
void ELYSE_Finalize(
 Slash::UI::IUI&
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void ELYSE_Geant4_detector(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();
  
  data_collect(session,"PV","name==\"waterTank\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"TyvekSheet\"");
  data_visualize(session);

  data_collect(session,"PV","name==\"SensiVol\"");
  data_visualize(session);



}
//////////////////////////////////////////////////////////////////////////////
void ELYSE_analysis_closeTree(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();
  
  ELYSE::IAppManager* appManager = 
    Lib_findManager(session,"ELYSE::AppManager",ELYSE::IAppManager);
  if(!appManager) {
    Lib::Out out(session.printer());
    out << "ELYSE_analysis_closeTree :"
        << " ELYSE::AnalysisManager not found."
        << Lib::endl;
    return;
  }

  appManager->closeTree();
}

//////////////////////////////////////////////////////////////////////////////
void ELYSE_plot_hits_times(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  AIDA::IAnalysisFactory* aida = find_aida(session);
  if(!aida) return;

  AIDA::ITree* memoryTree = find_memoryTree(*aida);
  if(!memoryTree) return;

  std::string hname = "h_hits_times";
  if(memoryTree->find(hname)) memoryTree->rm(hname);

  AIDA::IHistogram1D* h = 
    create_histogram1D(*aida,*memoryTree,hname,"Hits times.",100,0,3000);
  if(!h) return;

  // Fill histogram with a data_collect :
  data_collect(session,"WCPMT","");
  data_number(session);

  data_fill1D(session,hname,"Times");

  // Get current plotter :
  AIDA::IPlotter* plotter = create_plotter(*aida);
  if(plotter) {
    AIDA::IPlotterRegion& region = plotter->currentRegion();
    region.plot(*h);
    delete plotter;
  }
}
#define MINIMUM(a,b) ((a)<(b)?a:b)
#define MAXIMUM(a,b) ((a)>(b)?a:b)
//////////////////////////////////////////////////////////////////////////////
void ELYSE_vis_bins(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  Slash::UI::IWidget* cw = aUI.currentWidget();
  Slash::UI::IWidget* widget = aUI.findWidget("Viewer_2");
  if(!widget) return;
  aUI.setCurrentWidget(widget);

  //FIXME : check that current region is a plotter.
  data_collect(session,"SceneGraph","highlight==true");
  data_filter(session,"name");

  std::vector<double> mins;
  Lib::smanip::todoubles(data_values(session,"lowerEdge"),mins);
  std::vector<double> maxs;
  Lib::smanip::todoubles(data_values(session,"upperEdge"),maxs);
  if(maxs.size()!=mins.size()) return;
  if(!mins.size()) {
    Lib::Out out(session.printer());
    out << "ELYSE_vis_bins :"
        << " no highlighted bins."
        << Lib::endl;
    return;
  }
  double mn = mins[0];
  double mx = maxs[0];
  for(unsigned int index=1;index<mins.size();index++) {
    mn = MINIMUM(mn,mins[index]);
    mx = MAXIMUM(mx,maxs[index]);
  }

  Lib::Out out(session.printer());
  out << "ELYSE_vis_bins :"
      << " min " << mn
      << " max " << mx
      << Lib::endl;

  aUI.setCurrentWidget(cw);

  std::string filter;
  Lib::smanip::printf(filter,128,"(!(Times<%g))&&(!(Times>=%g))",mn,mx);
  data_collect(session,"WCPMT",filter);
  data_visualize(session);
}


} // extern "C"
