#include "ELYSE/TrackingActionMessenger.hh"

//Geant4
#include "G4UIdirectory.hh"
#include "G4ios.hh"
#include "globals.hh"
#include "G4UIcmdWithABool.hh"

//ELYSE
#include "ELYSE/TrackingAction.hh"


ELYSE::TrackingActionMessenger::TrackingActionMessenger(ELYSE::TrackingAction* ELYSETrackAction)
:ELYSETrackingAction(ELYSETrackAction) {
  
  ELYSEDir = new G4UIdirectory("/ELYSE/tracking/drawing/");
  ELYSEDir->SetGuidance("Commands to define particle drawing option");

  drawOpticalPhotonCmd = new G4UIcmdWithABool("/ELYSE/tracking/drawing/optical",this);
  drawOpticalPhotonCmd->SetGuidance("Available options: true false");
  drawOpticalPhotonCmd->SetGuidance("Description:");
  drawOpticalPhotonCmd->SetGuidance("true  = optical photons are stored to be drawn");
  drawOpticalPhotonCmd->SetGuidance("false = no optical photons stored");
  drawOpticalPhotonCmd->SetParameterName("drawOpticalPhoton",true);
  drawOpticalPhotonCmd->SetDefaultValue(false);
}//Ctor

//---------------------------------------------------------------------------------

ELYSE::TrackingActionMessenger::~TrackingActionMessenger() {
  delete drawOpticalPhotonCmd;
  delete ELYSEDir;
}//Dtor

//---------------------------------------------------------------------------------

void ELYSE::TrackingActionMessenger::SetNewValue(G4UIcommand* command, G4String newValue) {
  if (command == drawOpticalPhotonCmd) {
    G4cout << "(JEC) TrackingActionMessenger Draw Optical Photon" << G4endl;
    ELYSETrackingAction->SetDrawOpticalPhoton(StoB(newValue));
  }
}//SetNewValue
