#include "ELYSE/TrappVolHit.hh"

//Geant4
#include "G4Box.hh"
#include "G4AttDefStore.hh"
#include "G4AttDef.hh"
#include "G4AttValue.hh"
#include "G4UnitsTable.hh"
#include "G4VVisManager.hh"
#include "G4ParticleTypes.hh"
#include "G4Circle.hh"
#include "G4VisAttributes.hh"
#include "G4RotationMatrix.hh"

//std
#include <sstream>
#include <iomanip>


//JEC 10/1/06 introduce ELYSE
namespace ELYSE {
  G4Allocator<TrappVolHit> TrappVolHitAllocator;
}

ELYSE::TrappVolHit::TrappVolHit() :
  time(0.),
  eTot(0.),
  position(),
  trkId(0),
  parentId(0),
  pdg(0),
  edep(0)
{
  //JEC very preliminary 15/2/07 for visualisation
  virtualSolid = (G4CSGSolid*)(new G4Box("VolHit",0.1*mm,0.1*mm,0.1*mm));
}//Ctor


//-----------------------------------------------------------------------------------------

ELYSE::TrappVolHit::~TrappVolHit() {
  delete virtualSolid;
}

//-----------------------------------------------------------------------------------------

const std::map<G4String,G4AttDef>* ELYSE::TrappVolHit::GetAttDefs() const {
  G4bool isNew;
  std::map<G4String,G4AttDef>* store = G4AttDefStore::GetInstance("TrappVolHit",isNew);

  if (isNew) {    
    
    G4String VSolid("VSolid");
    (*store)[VSolid] = G4AttDef(VSolid,"Virtual Solid attached to the Hit","Display","","G4VSolid*");
    
    G4String Position("Position");
    (*store)[Position] = G4AttDef(Position,"3D Position","Physics","","G4ThreeVector");

    G4String Time("Time");
    (*store)[Time] = G4AttDef(Time,"Arrival Time","Physics","","G4double");

    G4String TrkID("TrkID");
    (*store)[TrkID] = G4AttDef(TrkID,"Track Id","Physics","","G4int");

    G4String ParentID("ParentID");
    (*store)[ParentID] = G4AttDef(ParentID,"Parent Track Id","Physics","","G4int");
    
    G4String PDG("PDG");
    (*store)[PDG] = G4AttDef(PDG,"Track PDG Code","Physics","","G4int");

    G4String Etot("Etot");
    (*store)[Etot] = G4AttDef(Etot,"Track total energy","Physics","","G4double");

    G4String Edep("Edep");
    (*store)[Edep] = G4AttDef(Edep,"Deposit energy by the track","Physics","","G4double");
    
  }
  return store;
}//GetAttDefs

//----------------------------------------------------------------------------------------------------

std::vector<G4AttValue>* ELYSE::TrappVolHit::CreateAttValues() const {

  std::ostringstream s;
  
  std::vector<G4AttValue>* values = new std::vector<G4AttValue>;

  s.str("");
  s << virtualSolid;
  values->push_back(G4AttValue("VSolid",s.str(),""));
  
  s.str("");
  s << &position;
  values->push_back(G4AttValue("Position",s.str(),""));
    
  s.str("");
  s << time;
  values->push_back(G4AttValue("Time",s.str(),""));

  s.str("");
  s << trkId;
  values->push_back(G4AttValue("TrkID",s.str(),""));

  s.str("");
  s << parentId;
  values->push_back(G4AttValue("ParentID",s.str(),""));

  s.str("");
  s << pdg;
  values->push_back(G4AttValue("PDG",s.str(),""));

  s.str("");
  s << eTot;
  values->push_back(G4AttValue("Etot",s.str(),""));

  s.str("");
  s << edep;
  values->push_back(G4AttValue("Edep",s.str(),""));

  return values;
}//CreateAttValues

//-----------------------------------------------------------------------------------------

void ELYSE::TrappVolHit::Print() {

  G4cout.setf(std::ios::fixed);
  G4cout.precision(2);

  G4cout << " -------> Track ["  << trkId << "]"
	 << " PDG: "      << pdg
	 << " Parent: "   << parentId
	 << " Time: "     << time
	 << " Etot "      << eTot
	 << " Edep: "     << edep
	 << " \n Position (" 
	 <<  position.x() << " , "
	 <<  position.y() << " , "
	 <<  position.z() << ")\n "
	 << G4endl;
  }//Print



