#include "ELYSE/TrappingVolume.hh"

//Geant4
#include "G4ParticleTypes.hh"
#include "G4HCofThisEvent.hh"
#include "G4TouchableHistory.hh"
#include "G4Step.hh"
#include "G4ThreeVector.hh"
#include "G4SDManager.hh"
#include "G4ios.hh"

//std
#include <sstream>
#include <stdio.h>

//ELYSE
#include "ELYSE/DetectorConstruction.hh"

ELYSE::TrappingVolume::TrappingVolume(G4String name, 
				      DetectorConstruction* aDetConstruction) 
:G4VSensitiveDetector(name),ELYSEDetConstruction(aDetConstruction) {
  
  G4String HCname;
  collectionName.insert(HCname="TrappingVolume");

  HCID = -1;
  
}//Ctor

//-----------------------------------------------------------------------------------------

ELYSE::TrappingVolume::~TrappingVolume() {
}//Dtor

//-----------------------------------------------------------------------------------------


void ELYSE::TrappingVolume::Initialize(G4HCofThisEvent* HCE) {
  // Make a new hits collection.  With the name we set in the constructor
  hitsCollection = new TrappVolHitsCollection(SensitiveDetectorName,collectionName[0]); 
    
  // Get the Id of the "0th" collection
  if (HCID<0) HCID =  GetCollectionID(0); //JEC FIXME: is it necessary?
  
  // Add it to the Hit collection of this event.
  HCE->AddHitsCollection( HCID, hitsCollection );  //JEC FIXME: is it necessary?

}//Initialize

//-----------------------------------------------------------------------------------------
G4bool ELYSE::TrappingVolume::ProcessHits(G4Step* aStep, G4TouchableHistory* aTH) {
  return ProcessHits_constStep(aStep,aTH);
}
//-----------------------------------------------------------------------------------------

G4bool ELYSE::TrappingVolume::ProcessHits_constStep(const G4Step* aStep, G4TouchableHistory*) {

  //  G4ParticleDefinition *particleDefinition = aStep->GetTrack()->GetDefinition();

//   if ( particleDefinition != G4OpticalPhoton::OpticalPhotonDefinition()) return false;
//   if ( aStep->GetTrack()->GetTrackStatus() == fAlive ) return false;


  TrappVolHit* newHit = new TrappVolHit();
  
  G4StepPoint* preStepPoint = aStep->GetPreStepPoint();
  G4Track*     theTrack     = aStep->GetTrack();


  //related to the StepPoint or the Track????
  newHit->SetTime(preStepPoint->GetGlobalTime());
  newHit->SetEtot(preStepPoint->GetTotalEnergy());
  newHit->SetCoordinates(preStepPoint->GetPosition());
  newHit->SetTrkId(theTrack->GetTrackID());
  newHit->SetParentId(theTrack->GetParentID());
  newHit->SetPDGEncoding(theTrack->GetDefinition()->GetPDGEncoding()); 
  newHit->SetEdep(aStep->GetTotalEnergyDeposit());

  
  G4cout << "New Hit \n"  
	 << "Global Time: " << preStepPoint->GetGlobalTime() << " =?= " 
	 << theTrack->GetGlobalTime() 
	 << "\n"
	 << "TotalEnergy: " << preStepPoint->GetTotalEnergy()  << " =?= " 
	 << theTrack->GetTotalEnergy()
	 << "\n"
	 << "Position: " << preStepPoint->GetPosition() << " =?= " 
	 <<  theTrack->GetPosition() 
	 << G4endl;


  //store the hit
  hitsCollection->insert( newHit ); 

  return true;
}//ProcessHits

//-----------------------------------------------------------------------------------------

void ELYSE::TrappingVolume::EndOfEvent(G4HCofThisEvent*) {
  if (verboseLevel>0) { 
    G4int numHits = hitsCollection->entries();

    G4cout << "There are " << numHits << " hits in the WC: " << G4endl;
    for (G4int i=0; i < numHits; i++) 
      (*hitsCollection)[i]->Print();
  } 
}//EndOfEvent

