#ifndef ELYSEEventAction_h
#define ELYSEEventAction_h 1

//Geant4
#include "G4UserEventAction.hh"
#include "G4ThreeVector.hh"
#include "G4Types.hh"
#include "G4ios.hh"

//ELYSE
#include "ELYSE/DetectorConstruction.hh"



class G4Event;

namespace AIDA {
  class ITuple;
}

namespace ELYSE {

class Analysis; 
class RunAction;
class PrimaryGeneratorAction;

class EventAction : public G4UserEventAction {
  
 public:
  EventAction(Analysis&,
	      RunAction*, 
	      DetectorConstruction*,
	      PrimaryGeneratorAction*);
  virtual ~EventAction();
  
 public:
  void BeginOfEventAction(const G4Event*);
  void EndOfEventAction(const G4Event*);
  
  RunAction* GetRunAction(){return runAction;}
  
 private:
  G4int EventFindStartingVolume(G4ThreeVector vtx);
  G4int EventFindStoppingVolume(G4String stopVolumeName);
  G4int FindVolume(G4String volumeName);

 private:
  //JEC FIXME is it necessary to maintain fAnalysis?
  Analysis&               fAnalysis;            //the Analysis
  RunAction*              runAction;            //the Run
  PrimaryGeneratorAction* generatorAction;      //the Generator 
  DetectorConstruction*   detectorConstructor;  //the Detector

  AIDA::ITuple*           eventTuple;           //the Event tuple

};

}

#endif

    
