#ifndef ELYSEPhysicsList_h
#define ELYSEPhysicsList_h 1

#include "G4VModularPhysicsList.hh"
#include "globals.hh"

class G4VPhysicsConstructor;

class G4Cerenkov;
class G4Scintillation;
class G4OpAbsorption;
class G4OpRayleigh;
class G4OpBoundaryProcess;

namespace ELYSE {

class PhysicsListMessenger;


class PhysicsList: public G4VModularPhysicsList {
 public:
  PhysicsList();
  virtual ~PhysicsList();
  
  void ConstructParticle();

  void ConstructProcess();
  void ConstructGeneral();
  void ConstructOp();
  //JEC not useful but keep it  void ConstructHad();
  
  //for the Messenger 
  void AddPhysicsList(const G4String& name);
  
  void SetCuts();
  void SetCutForGamma(G4double);
  void SetCutForElectron(G4double);
  void SetCutForPositron(G4double);

  void SetVerbose(G4int verbose);
  void SetNbOfPhotonsCerenkov(G4int MaxNumber);
  
 private:
  G4double cutForGamma;
  G4double cutForElectron;
  G4double cutForPositron;
  G4double currentDefaultCut;
  
  G4VPhysicsConstructor*  emPhysicsList;
  G4String emName;
  
  
  PhysicsListMessenger* pMessenger;

 //the processes
  G4Cerenkov*          theCerenkovProcess;
  G4Scintillation*     theScintillationProcess;
  G4OpAbsorption*      theAbsorptionProcess;
  G4OpRayleigh*        theRayleighScatteringProcess;
  G4OpBoundaryProcess* theBoundaryProcess;


};
}


#endif

