#ifndef ELYSEPhysicsListMessenger_h
#define ELYSEPhysicsListMessenger_h 1

#include "globals.hh"
#include "G4UImessenger.hh"

class G4UIdirectory;
class G4UIcmdWithADoubleAndUnit;
class G4UIcmdWithAString;
class G4UIcmdWithAnInteger;

namespace ELYSE {

class PhysicsList;

class PhysicsListMessenger: public G4UImessenger {
 public:
  
  PhysicsListMessenger(PhysicsList* );
  virtual ~PhysicsListMessenger();
  
  void SetNewValue(G4UIcommand*, G4String);
  
 private:
  
  PhysicsList*               pPhysicsList;
  
  G4UIdirectory*             physDir;    
  G4UIcmdWithADoubleAndUnit* gammaCutCmd;
  G4UIcmdWithADoubleAndUnit* electCutCmd;
  G4UIcmdWithADoubleAndUnit* protoCutCmd;    
  G4UIcmdWithADoubleAndUnit* allCutCmd;    
  G4UIcmdWithAString*        pListCmd;
  G4UIcmdWithAnInteger*      verboseCmd;
  G4UIcmdWithAnInteger*      cerenkovCmd;
};
}


#endif

