#include "ELYSE/Analysis.hh"

//AIDA
#include <AIDA/IAnalysisFactory.h>
#include <AIDA/ITreeFactory.h>
#include <AIDA/ITree.h>
#include <AIDA/ITupleFactory.h>

//Std
#include <iostream>
#include <vector>
#include <string>

ELYSE::Analysis::Analysis(
 AIDA::IAnalysisFactory* aAIDA
,const std::string& aFormat
,bool aBatch)
:fAIDA(aAIDA)
,fBatch(aBatch)
,fTree(0)
{
  if(!fAIDA) return;

  AIDA::ITreeFactory* treeFactory = fAIDA->createTreeFactory();
  if(fBatch) {
    if( (aFormat=="root") || (aFormat==""))  {
      //ROOT tree :
      std::string opts = "export=root";
      fTree = treeFactory->create("ELYSE.root","root",false,true,opts);
    } else if(aFormat=="hdf5") {
      //HDF5 tree :
      std::string opts = "";
      fTree = treeFactory->create("ELYSE.hdf5","hdf5",false,true,opts);
    } else if(aFormat=="xml") {
      // AIDA XML tree :
      std::string opts = "compress=yes";
      fTree = treeFactory->create("ELYSE.xml","xml",false,true,opts);
    } else {
      std::cout << "Analysis :"
                << " file format \"" << aFormat << "\""
                << " not handled."  
                << std::endl;
    }
  } else {
    // Memory tree :
    fTree = treeFactory->create();
  }
  delete treeFactory;
  if(!fTree) {
    std::cout << "Analysis : FATAL"
              << " tree not created." << std::endl;
    return;
  }

  //Booking Event Tuple
  AIDA::ITupleFactory* tf = fAIDA->createTupleFactory(*fTree);
  if(fBatch) {
    std::string column = "int eventId, vtxvol, "; 
    column += "ITuple vtxPos = { double x, y, z }, ";
    column += "int nPart, ";
    column += "ITuple track = { int pId, parent, float timeStart, ";
    column +=                  "ITuple direction = { double dx, dy, dz }, ";
    column +=                  "double  mass, pTot, ETot, ";
    column +=                  "ITuple momentum  = { double px, py, pz }, ";
    column +=                  "ITuple startPos  = { double  x,  y,  z }, ";
    column +=                  "ITuple stopPos   = { double  x,  y,  z } ";
    column +=                  "int startVol, stopVol ";
    column +=                "}, ";
    column += "int nHits,";
    column += "ITuple hit = { double  time, eTot, x,  y,  z, trkId, parentId, pdg, edep } ";
    
    tf->create("Event","ELYSE Event",column,"");     
  }//batch mode
  

  //release the TupleFactory
  delete tf;

}//Ctor

//----------------------------------------------------------------------
ELYSE::Analysis::~Analysis(){
  //Not to be changed
  if(!fTree) return;
  if(fBatch) {
    fTree->commit();
    delete fTree;
    fTree = 0;
  }
}//Dtor

//----------------------------------------------------------------------

void ELYSE::Analysis::closeTree(){
  if(!fTree) return;
  if(!fBatch) return;
  fTree->commit();
  delete fTree;
  fTree = 0;
}
