#include "ELYSE/DetectorMessenger.hh"

//Geant 4
#include "G4UIdirectory.hh"
#include "G4UIcommand.hh"
#include "G4UIparameter.hh"
#include "G4UIcmdWith3VectorAndUnit.hh"
#include "G4UIcmdWithADoubleAndUnit.hh"

//ELYSE
#include "ELYSE/DetectorConstruction.hh"

ELYSE::DetectorMessenger::DetectorMessenger(ELYSE::DetectorConstruction* ELYSEDet)
: ELYSEDetector(ELYSEDet) { 

  ELYSEDir = new G4UIdirectory("/ELYSE/Geometry/");
  ELYSEDir->SetGuidance("Geometry control");
  
  waterDimensionsCmd = 
    new G4UIcmdWith3VectorAndUnit("/ELYSE/Geometry/Water",this);
  waterDimensionsCmd->SetGuidance("Set the dimensions of the Water volume.");
  waterDimensionsCmd->SetParameterName("water_x","water_y","water_z",false);
  waterDimensionsCmd->SetDefaultUnit("cm");

  tyvekThicknessCmd =
    new G4UIcmdWithADoubleAndUnit
    ("/ELYSE/Geometry/TyvekThickness",this);
  tyvekThicknessCmd->SetGuidance("Set the thickness of the tyvek.");
  tyvekThicknessCmd->SetParameterName("tyvek_thickness",false);
  tyvekThicknessCmd->SetDefaultUnit("cm");

} //ELYSEDetectorMessenger

ELYSE::DetectorMessenger::~DetectorMessenger()
{
  
  delete waterDimensionsCmd;
  delete tyvekThicknessCmd;

} //ELYSEDetectorMessenger

void ELYSE::DetectorMessenger::SetNewValue(G4UIcommand* command,G4String newValue) {    

  if( command ==  waterDimensionsCmd ){ 
    ELYSEDetector->SetWaterDimensions(waterDimensionsCmd->GetNew3VectorValue(newValue));
  }
  else if (command == tyvekThicknessCmd){
    ELYSEDetector->SetTyvekThickness(tyvekThicknessCmd->GetNewDoubleValue(newValue));
  }
 
}//SetNewValue
