//this
#include "ELYSE/PhysicsListMessenger.hh"

//Geant 4
#include "G4UIdirectory.hh"
#include "G4UIcmdWithADoubleAndUnit.hh"
#include "G4UIcmdWithAString.hh"
#include "G4UIcmdWithAnInteger.hh"

//ELYSE
#include "ELYSE/PhysicsList.hh"


//----------------------------------------------------------------------

ELYSE::PhysicsListMessenger::PhysicsListMessenger(PhysicsList* pPhys)
:pPhysicsList(pPhys) {

  physDir = new G4UIdirectory("/ELYSE/phys/");
  physDir->SetGuidance("physics list commands");
   
  gammaCutCmd = new G4UIcmdWithADoubleAndUnit("/ELYSE/phys/setGCut",this);  
  gammaCutCmd->SetGuidance("Set gamma cut.");
  gammaCutCmd->SetParameterName("Gcut",false);
  gammaCutCmd->SetUnitCategory("Length");
  gammaCutCmd->SetRange("Gcut>0.0");
  gammaCutCmd->AvailableForStates(G4State_PreInit,G4State_Idle);

  electCutCmd = new G4UIcmdWithADoubleAndUnit("/ELYSE/phys/setECut",this);  
  electCutCmd->SetGuidance("Set electron cut.");
  electCutCmd->SetParameterName("Ecut",false);
  electCutCmd->SetUnitCategory("Length");
  electCutCmd->SetRange("Ecut>0.0");
  electCutCmd->AvailableForStates(G4State_PreInit,G4State_Idle);
  
  protoCutCmd = new G4UIcmdWithADoubleAndUnit("/ELYSE/phys/setPCut",this);  
  protoCutCmd->SetGuidance("Set positron cut.");
  protoCutCmd->SetParameterName("Pcut",false);
  protoCutCmd->SetUnitCategory("Length");
  protoCutCmd->SetRange("Pcut>0.0");
  protoCutCmd->AvailableForStates(G4State_PreInit,G4State_Idle);  

  allCutCmd = new G4UIcmdWithADoubleAndUnit("/ELYSE/phys/setCuts",this);  
  allCutCmd->SetGuidance("Set cut for all.");
  allCutCmd->SetParameterName("cut",false);
  allCutCmd->SetUnitCategory("Length");
  allCutCmd->SetRange("cut>0.0");
  allCutCmd->AvailableForStates(G4State_PreInit,G4State_Idle);  

  pListCmd = new G4UIcmdWithAString("/ELYSE/phys/addPhysics",this);  
  pListCmd->SetGuidance("Add modula physics list.");
  pListCmd->SetParameterName("PList",false);
  pListCmd->AvailableForStates(G4State_PreInit);  


  verboseCmd = new G4UIcmdWithAnInteger("/ELYSE/phys/verbose",this);  
  verboseCmd->SetGuidance("set verbose for physics processes");
  verboseCmd->SetParameterName("verbose",true);
  verboseCmd->SetDefaultValue(1);
  verboseCmd->SetRange("verbose>=0");
  verboseCmd->AvailableForStates(G4State_Idle);

  cerenkovCmd = new G4UIcmdWithAnInteger("/ELYSE/phys/cerenkovMaxPhotons",this);  
  cerenkovCmd->SetGuidance("set max nb of photons per step");
  cerenkovCmd->SetParameterName("MaxNumber",false);
  cerenkovCmd->SetRange("MaxNumber>=0");
  cerenkovCmd->AvailableForStates(G4State_Idle);  
}

//----------------------------------------------------------------------

ELYSE::PhysicsListMessenger::~PhysicsListMessenger() {
  delete gammaCutCmd;
  delete electCutCmd;
  delete protoCutCmd;
  delete allCutCmd;
  delete pListCmd;
  delete verboseCmd;
  delete cerenkovCmd;  
  delete physDir;      
  
}

//----------------------------------------------------------------------

void ELYSE::PhysicsListMessenger::SetNewValue(G4UIcommand* command,
					      G4String newValue) {       
  if( command == gammaCutCmd ) { 
    pPhysicsList->SetCutForGamma(gammaCutCmd->GetNewDoubleValue(newValue));
  }
     
  if( command == electCutCmd ) { 
    pPhysicsList->SetCutForElectron(electCutCmd->GetNewDoubleValue(newValue));
  }
     
  if( command == protoCutCmd ) { 
    pPhysicsList->SetCutForPositron(protoCutCmd->GetNewDoubleValue(newValue));
  }

  if( command == allCutCmd ) {
    G4double cut = allCutCmd->GetNewDoubleValue(newValue);
    pPhysicsList->SetCutForGamma(cut);
    pPhysicsList->SetCutForElectron(cut);
    pPhysicsList->SetCutForPositron(cut);
  } 
  
  if( command == pListCmd ) { 
    pPhysicsList->AddPhysicsList(newValue);
  }


  if( command == verboseCmd ) { 
   pPhysicsList->SetVerbose(verboseCmd->GetNewIntValue(newValue));
  }
   
  if( command == cerenkovCmd ) {
   pPhysicsList->SetNbOfPhotonsCerenkov(cerenkovCmd->GetNewIntValue(newValue));
  }

}//SetNewValue

//----------------------------------------------------------------------
