#ifndef ELYSEPrimaryGeneratorAction_h
#define ELYSEPrimaryGeneratorAction_h

//Geant4
#include "G4VUserPrimaryGeneratorAction.hh"
#include "G4ThreeVector.hh"
#include "globals.hh"

//std
#include <fstream>

class G4ParticleGun;
class G4ParticleTable;

namespace ELYSE {

class PrimaryGeneratorMessenger;

class PrimaryGeneratorAction : public G4VUserPrimaryGeneratorAction {
 public:
  PrimaryGeneratorAction();
  virtual ~PrimaryGeneratorAction();
  
public:
  void GeneratePrimaries(G4Event* anEvent);

  //Accessors for the Messenger
  void SetBeamPDG(G4int i);
  void SetBeamName(G4String i);
  void SetBeamEnergy(G4double i);
  void SetVtx(G4ThreeVector i);
  void SetBeamDir(G4ThreeVector i);
  void SetOptPhotonPolar(G4ThreeVector i);

  G4int GetBeamPDG()         {return beampdg;};
  G4double GetBeamEnergy()   {return beamenergy;};
  G4ThreeVector GetVtx()     {return vtx;}
  G4ThreeVector GetBeamDir() {return beamdir;};
  G4ThreeVector GetOpPhotonPolar() {return polar;}

private:

  G4ParticleGun*             particleGun;
  PrimaryGeneratorMessenger* messenger;
  G4ParticleTable*           particleTable;

 
  G4int beampdg;           //code PDG du faisceau
  G4double beamenergy;     //energy du faisceau
  G4ThreeVector vtx;       //vertex de l'interaction du faisceau
  G4ThreeVector beamdir;   //direction du faisceau
  G4ThreeVector polar;     //optical photon polarization

public:
};


}

#endif


