#ifndef ELYSEPrimaryGeneratorMessenger_h
#define ELYSEPrimaryGeneratorMessenger_h 1

//Geant4
#include "G4UImessenger.hh"
#include "globals.hh"

class G4UIdirectory;
class G4UIcmdWithAString;
class G4UIcmdWithADoubleAndUnit;
class G4UIcmdWith3Vector;
class G4UIcmdWith3VectorAndUnit;

namespace ELYSE {

class PrimaryGeneratorAction;


class PrimaryGeneratorMessenger: public G4UImessenger {
 public:
  PrimaryGeneratorMessenger(PrimaryGeneratorAction* mpga);
  virtual ~PrimaryGeneratorMessenger();
  
 public:
  void     SetNewValue(G4UIcommand* command, G4String newValues);
  
 private:
  PrimaryGeneratorAction* myAction;
  
 private: //commands
  G4UIdirectory*      ELYSEDir;
  G4UIcmdWithAString*          particleTypeCmd;
  G4UIcmdWithADoubleAndUnit*   energyCmd;
  G4UIcmdWith3Vector*          beamDirectionCmd;
  G4UIcmdWith3VectorAndUnit*   beamVertexCmd;
  G4UIcmdWith3Vector*   polarCmd;
};
}
#endif


