#ifndef ELYSETrackInformation_h
#define ELYSETrackInformation_h 1


#include "globals.hh"
#include "G4Track.hh"
#include "G4Allocator.hh"
#include "G4VUserTrackInformation.hh"

namespace ELYSE {

enum TrackStatus { active=1, hitProduced=2, absorbed=4, boundaryAbsorbed=8,
		    inactive=14};

/*
  TrackStatus:
  active: still being tracked
  hitProduced: being detected in the Tyvek
  absorbed: stopped by being absorbed with G4OpAbsorbtion
  boundaryAbsorbed: stopped by being aborbed with G4OpAbsorbtion
  inactive: track is stopped for some reason
   -This is the sum of all stopped flags so can be used to remove stopped flags  
 
   JEC 13/2/07: see if "absorbed" and "boundaryAbsorbed" are similar? see LXe example
*/

class TrackInformation : public G4VUserTrackInformation {

public:
  TrackInformation(): saveit(false), drawit(false), status(active) {}
  TrackInformation(const G4Track*);
  virtual ~TrackInformation() {}
  
  inline void *operator new(size_t);
  inline void operator delete(void *aTrackInfo);
  inline int operator ==(const TrackInformation& right) const
  {return (this==&right);}

  
  //Sets the track status to s (does not check validity of flags)
  void SetTrackStatusFlags(G4int s){status=s;}
  //Does a smart add of track status flags (disabling old flags that conflict)
  //If s conflicts with itself it will not be detected
  void AddTrackStatusFlag(G4int s);
  int GetTrackStatus()  {return status;}

  void SetDrawOption(G4bool b) {drawit = b;}
  G4bool GetDrawOption() {return drawit;}

  void SetSaveOption(G4bool b) {saveit = b;}
  G4bool GetSaveOption() {return saveit;}

  void Print() const;


private:
  G4bool saveit; 
  G4bool drawit;
  G4int  status; 

};
}

namespace ELYSE {
  extern G4Allocator<TrackInformation> aTrackInfoAllocator;
}

inline void* ELYSE::TrackInformation::operator new(size_t) { 
  void* aTrackInfo;
  aTrackInfo = (void*)ELYSE::aTrackInfoAllocator.MallocSingle();
  return aTrackInfo;
}

inline void ELYSE::TrackInformation::operator delete(void *aTrackInfo){ 
  ELYSE::aTrackInfoAllocator.FreeSingle((ELYSE::TrackInformation*)aTrackInfo);
}


#endif
