#ifndef ELYSETrackingAction_h
#define ELYSETrackingAction_h

//Geant4
#include "G4UserTrackingAction.hh"
#include "globals.hh"

//std
#include <set>


class G4Track;


namespace ELYSE {

class TrackingActionMessenger;

class TrackingAction : public G4UserTrackingAction {
 public:
  TrackingAction();
  virtual ~TrackingAction();

  void PreUserTrackingAction (const G4Track* aTrack);
  void PostUserTrackingAction(const G4Track* aTrack);

  
  void SetDrawOpticalPhoton(bool value) {drawOpticalPhoton = value;}

private:
  
  std::set<G4String> ProcessList;  //a list of process one want to keep track
  std::set<G4int>    ParticleList; //a list of particle to keep anyway

  TrackingActionMessenger* messenger; 
  G4bool drawOpticalPhoton;
  
};
}

#endif


