// Geant4:
#include "G4ios.hh"
#include "G4RunManager.hh"
#include "G4UImanager.hh"

//ELYSE:
#include "ELYSE/Analysis.hh"
#include "ELYSE/SteppingVerbose.hh"
#include "ELYSE/DetectorConstruction.hh"
#include "ELYSE/PhysicsList.hh"
#include "ELYSE/PrimaryGeneratorAction.hh"
#include "ELYSE/EventAction.hh"
#include "ELYSE/RunAction.hh"
#include "ELYSE/StackingAction.hh"
#include "ELYSE/TrackingAction.hh"
#include "ELYSE/SteppingAction.hh"


//JEC AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

//JEC Lib :
#include <Lib/System.h>

//////////////////////////////////////////////////////////////////////////////
int main(
 int aArgc 
,char** aArgv
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::string arg1 = (aArgc>=2?aArgv[1]:"");

  //AIDA Analysis factory
  AIDA::IAnalysisFactory* aida = AIDA_createAnalysisFactory();
  if(!aida) {
    std::cout << "ELYSE_batch :"
              << " AIDA not found." << std::endl;
  }
  //Book all the histo, tuple 
  ELYSE::Analysis* analysis = new ELYSE::Analysis(aida,arg1);
 
  // User Verbose output class
  //
  G4VSteppingVerbose* verbosity = new ELYSE::SteppingVerbose;
  G4VSteppingVerbose::SetInstance(verbosity);
 
  // Construct the default run manager
  G4RunManager* runManager = new G4RunManager;
  

  // UserInitialization classes (mandatory)


  ELYSE::DetectorConstruction* ELYSEdetector =  new ELYSE::DetectorConstruction(); 

  runManager->SetUserInitialization(ELYSEdetector);

  runManager->SetUserInitialization(new ELYSE::PhysicsList);

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("ELYSEROOT")+"/scripts/Geant4/jobOptions.mac"; //JEC FIXME this comes from JHF
    UI->ApplyCommand("/control/execute "+file);  
  }


  // Set user action classes
  ELYSE::PrimaryGeneratorAction* myGeneratorAction = new ELYSE::PrimaryGeneratorAction();
  runManager->SetUserAction(myGeneratorAction);

  ELYSE::RunAction* myRunAction = new ELYSE::RunAction();
  runManager->SetUserAction(myRunAction);

  runManager->SetUserAction(new ELYSE::EventAction(*analysis,
						   myRunAction, 
						   ELYSEdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new ELYSE::TrackingAction);

  runManager->SetUserAction(new ELYSE::StackingAction);
  runManager->SetUserAction(new ELYSE::SteppingAction);

  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("ELYSEROOT")+"/scripts/Geant4/init.g4m";
    UI->ApplyCommand("/control/execute "+file);  
  }


  runManager->BeamOn(1);


  delete runManager;
  delete analysis;
  delete aida;
  return 0;
}


