
// Geant4:
#include <G4ios.hh>
#include <G4RunManager.hh>
#include <G4UImanager.hh>
#include <G4SDManager.hh>

//AIDA :
#include <AIDA/IAnalysisFactory.h>

// std::
#include <iostream>

// Slash :
#include <Slash/Core/IManager.h>
#include <Slash/Core/ISession.h>
#include <Slash/Data/IProcessor.h>

// Lib :
#include <Lib/Manager.h>
#include <Lib/System.h>
#include <Lib/Out.h>
#include <Lib/Cast.h>

// G4Lab :
#include <G4Lab/UIOnX.h>
#include <G4Lab/TrackingAction.h>
#include <G4Lab/Interfaces/IGeant4Manager.h>
//#include <G4Lab/DigitsCollectionAccessor.h>

//ELYSE:
#include "ELYSE/Analysis.hh"
#include "ELYSE/SteppingVerbose.hh"
#include "ELYSE/DetectorConstruction.hh"
#include "ELYSE/PhysicsList.hh"
#include "ELYSE/PrimaryGeneratorAction.hh"
#include "ELYSE/EventAction.hh"
#include "ELYSE/RunAction.hh"
#include "ELYSE/StackingAction.hh"
#include "ELYSE/TrackingAction.hh"
#include "ELYSE/SteppingAction.hh"
#include <ELYSE/HitsCollectionAccessor.h>

// Create a manager to access the ELYSEAnalysis from the callbacks :

//JEC 10/1/06 introduce ELYSE namespace
namespace ELYSE {

class AppManager 
  :public virtual Slash::Core::IManager
  ,public Analysis  {
 public: //Slash::Core::IManager
  virtual std::string name() const { return fName;}
  virtual void* cast(const std::string& aClass) const {
    if_Lib_SCast(ELYSE::AppManager)
    else if_Lib_SCast(ELYSE::IAppManager)
    else if_Lib_SCast(ELYSE::Analysis)
    else if_Lib_SCast(Slash::Core::IManager)
    else return 0;
  }
 public://IAppManager
  virtual bool initialize() {
    //GB :
    // Used in the ELYSE_Initialize callback.
    // Do all the below here because of platforms having 
    // not Geant4 shared libs.
    IGeant4Manager* g4Manager = 
      Lib_findManager(fSession,"Geant4Manager",IGeant4Manager);
    if(!g4Manager) {
      Lib::Out out(fSession.printer());
      out << "ELYSE_Initialize :"
          << " Geant4Manager not found."
          << Lib::endl;
      return false;
    }

    // To initialize G4Lab Types (PV, Trajectory, HitsCollection, etc.. types).
    // To initialize G4Lab SoNodes.
    g4Manager->initialize();

    // Overload the HitsCollectionAccessor of G4Lab :
    Slash::Data::IProcessor* accessorManager = 
      Lib_findManager(fSession,"AccessorManager",Slash::Data::IProcessor);
    if(accessorManager) {
      G4SDManager* sdManager = g4Manager->sdManager();
      if(sdManager) {
        G4HCtable* hcTable  = sdManager->GetHCtable();
        if(hcTable) {
          int number = hcTable->entries();
          for(int index=0;index<number;index++) {
            G4String hcName = hcTable->GetHCname(index);
            accessorManager->removeAccessor(hcName);
            accessorManager->addAccessor
              (new ELYSE::HitsCollectionAccessor(fSession,hcName));
          }
        }
      }
    }
    return true;
  }
 public:
  AppManager(Slash::Core::ISession& aSession,AIDA::IAnalysisFactory* aAIDA,bool aBatch)
    :Analysis(aAIDA,"",aBatch)
    ,fSession(aSession)
    ,fName("ELYSE::AppManager") {}
  virtual ~AppManager(){}
 private:
  Slash::Core::ISession& fSession;
  std::string fName;
};
}

//////////////////////////////////////////////////////////////////////////////
int main(
 int aArgc
,char** aArgv
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //Lib::Debug::checkByClass(true);


  // User Verbose output class
  //
  G4VSteppingVerbose* verbosity = new ELYSE::SteppingVerbose;
  G4VSteppingVerbose::SetInstance(verbosity);


  G4RunManager* runManager = new G4RunManager;

  // Need to pass the G4RunManager at UIOnX creation
  std::string gui = "$ELYSEROOT/scripts/OnX/ELYSE_session.onx";
  G4Lab::UIOnX* session = new G4Lab::UIOnX(*runManager,gui,aArgc,aArgv);
  if(!session->isValid()) {
    std::cout << "ELYSE_session : problem starting OnX." << std::endl;
    return EXIT_FAILURE;
  }

  ELYSE::AppManager* appManager = 0;

  AIDA::IAnalysisFactory* aida = session->findAIDA();
  if(!aida) {
    std::cout << "ELYSE_session : AIDA not found." << std::endl;
  } 

  appManager = new ELYSE::AppManager(*session->session(),aida,false);
  session->addManager(appManager);

  ELYSE::DetectorConstruction* ELYSEdetector =  new ELYSE::DetectorConstruction(); 

  runManager->SetUserInitialization(ELYSEdetector);

  runManager->SetUserInitialization(new ELYSE::PhysicsList);

  G4UImanager* UI = G4UImanager::GetUIpointer();
  if (UI) {
    std::string file = 
      Lib::System::getenv("ELYSEROOT")+"/scripts/Geant4/jobOptions.mac";
    UI->ApplyCommand("/control/execute "+file);  
  }

  
  // Set user action classes
  ELYSE::PrimaryGeneratorAction* myGeneratorAction = new ELYSE::PrimaryGeneratorAction();
  runManager->SetUserAction(myGeneratorAction);

  ELYSE::RunAction* myRunAction = new ELYSE::RunAction();

  runManager->SetUserAction(myRunAction);


  runManager->SetUserAction(new ELYSE::EventAction(*appManager,
						   myRunAction, 
						   ELYSEdetector,
						   myGeneratorAction));
  runManager->SetUserAction(new ELYSE::TrackingAction);

  runManager->SetUserAction(new ELYSE::StackingAction);

  runManager->SetUserAction(new ELYSE::SteppingAction);

  // Initialize G4 kernel
  runManager->Initialize();

  if (UI) {
    std::string file = 
      Lib::System::getenv("ELYSEROOT")+"/scripts/Geant4/init.g4m";
    UI->ApplyCommand("/control/execute "+file);  
  }


  // Main UI loop :
  // GUI is really constructed here. 
  // Create callbacks are executed here too.
  session->SessionStart();

  delete session; //It will delete the appManager.

  delete runManager;

  return EXIT_SUCCESS;
}

