#include "ELYSE/PrimaryGeneratorAction.hh"

//Geant4
#include "G4Event.hh"
#include "G4ParticleGun.hh"
#include "G4ParticleTable.hh"
#include "G4ParticleDefinition.hh"
#include "G4ThreeVector.hh"
#include "globals.hh"
#include "Randomize.hh"
#include "G4Navigator.hh"
#include "G4TransportationManager.hh"
#include "G4ProcessManager.hh"

//ELYSE
#include "ELYSE/DetectorConstruction.hh"
#include "ELYSE/PrimaryGeneratorMessenger.hh"


ELYSE::PrimaryGeneratorAction::PrimaryGeneratorAction() {
  // Initialize to zero
  vtx = G4ThreeVector(0.,0.,0.);
  beamenergy = 0.;
  beamdir = G4ThreeVector(0.,0.,0.);
  
  
  //---Set defaults. Do once at beginning of session.
  
  G4int n_particle = 1;
  particleGun = new G4ParticleGun(n_particle);
    
  particleTable = G4ParticleTable::GetParticleTable();
  particleGun->SetParticleDefinition(particleTable->FindParticle("e-"));


  particleGun->SetParticleTime(0.0*ns);
  particleGun->SetParticlePosition(G4ThreeVector(0.0*cm,0.0*cm,0.0*cm));
  particleGun->SetParticleMomentumDirection(G4ThreeVector(0.,0.,1.));
  particleGun->SetParticleEnergy(8.2*MeV);

    
  //link to the messanger
  messenger = new PrimaryGeneratorMessenger(this);
}//Ctor

//-------------------------------------------------------------------------------------------------

ELYSE::PrimaryGeneratorAction::~PrimaryGeneratorAction() {
  delete particleGun;
  delete messenger;
}//Dtor

//-------------------------------------------------------------------------------------------------

void ELYSE::PrimaryGeneratorAction::GeneratePrimaries(G4Event* anEvent) {


  //use the Gun used by default or in the Messenger
  particleGun->GeneratePrimaryVertex(anEvent);
  
  //This code suppose 1 particle in the gun.
//   G4ThreeVector P   = anEvent->GetPrimaryVertex()->GetPrimary()->GetMomentum();
//   G4ThreeVector vtx = anEvent->GetPrimaryVertex()->GetPosition();
//   G4double m        = anEvent->GetPrimaryVertex()->GetPrimary()->GetMass();
//   G4int pdg         = anEvent->GetPrimaryVertex()->GetPrimary()->GetPDGcode());
      
//   G4ThreeVector dir  = P.unit();
//   G4double E         = std::sqrt((P.dot(P))+(m*m));
      
//   SetBeamPDG(pdg);
//   SetBeamEnergy(E);
//   SetVtx(vtx);
//   SetBeamDir(dir);
    
}//GeneratePrimaries

//-------------------------------------------------------------------------------------------------
void ELYSE::PrimaryGeneratorAction::SetBeamPDG(G4int i) {

  //  G4cout << "(JEC): SetBeamPDG(" << i << ")" << G4endl;

  beampdg = i;
  particleGun->
    SetParticleDefinition(particleTable->FindParticle(i));
}//SetBeamPDG
//-------------------------------------------------------------------------------------------------

void ELYSE::PrimaryGeneratorAction::SetBeamName(G4String i) {

  //  G4cout << "(JEC): SetBeamName(" << i << ")" << G4endl;

  beampdg = particleTable->FindParticle(i)->GetPDGEncoding();

  particleGun->
      SetParticleDefinition(particleTable->FindParticle(i));
}//SetBeamPDG

//-----------------------------------------------------------------------

void ELYSE::PrimaryGeneratorAction::SetBeamEnergy(G4double i) {
  //  G4cout << "(JEC): SetBeamEnergy(" << i << ")" << G4endl;
  beamenergy = i;
  particleGun->SetParticleEnergy(i);
}//SetBeamEnergy

//-----------------------------------------------------------------------

void ELYSE::PrimaryGeneratorAction::SetVtx(G4ThreeVector i) {
  //  G4cout << "(JEC): SetVtx(" << i << ")" << G4endl;
  vtx = i;
  particleGun->SetParticlePosition(i);
}//SetVtx

//-----------------------------------------------------------------------

void ELYSE::PrimaryGeneratorAction::SetBeamDir(G4ThreeVector i) {
  //  G4cout << "(JEC): SetBeamDir(" << i << ")" << G4endl;
  beamdir = i;
  particleGun->SetParticleMomentumDirection(i);
}//SetBeamDir

//-----------------------------------------------------------------------
void ELYSE::PrimaryGeneratorAction::SetOptPhotonPolar(G4ThreeVector i) {
  polar = i;  
  //  G4cout << "(JEC): SetOptPhotonPolar(" << polar << ")" << G4endl;
  particleGun->SetParticlePolarization(i);
}
