#include "ELYSE/PrimaryGeneratorMessenger.hh"

//Geant4
#include "G4UIdirectory.hh"
#include "G4UIcmdWithAString.hh"
#include "G4UIcmdWith3Vector.hh"
#include "G4UIcmdWithADoubleAndUnit.hh"
#include "G4UIcmdWith3VectorAndUnit.hh"
#include "G4ios.hh"

//ELYSE
#include "ELYSE/PrimaryGeneratorAction.hh"


ELYSE::PrimaryGeneratorMessenger::PrimaryGeneratorMessenger(ELYSE::PrimaryGeneratorAction* pointerToAction)
:myAction(pointerToAction) {

  ELYSEDir = new G4UIdirectory("/ELYSE/gun/");
  ELYSEDir->SetGuidance("ELYSE gun control commands.");

  particleTypeCmd = new G4UIcmdWithAString("/ELYSE/gun/partName",this);
  particleTypeCmd->SetGuidance("Particle Name of the beam");
  particleTypeCmd->SetParameterName("beampdg",false);

  energyCmd = new G4UIcmdWithADoubleAndUnit("/ELYSE/gun/energy",this);
  energyCmd->SetGuidance("The Energy of the beam");
  energyCmd->SetParameterName("beamenergy",false);
  energyCmd->SetDefaultUnit("MeV");

  beamDirectionCmd = new G4UIcmdWith3Vector("/ELYSE/gun/BeamDir",this);
  beamDirectionCmd->SetGuidance("Set the direction of the beam.");
  beamDirectionCmd->SetParameterName("beamdir_x","beamdir_y","beamdir_z",false);

  beamVertexCmd = new G4UIcmdWith3VectorAndUnit("/ELYSE/gun/vertex",this);
  beamVertexCmd->SetGuidance("Set the vertex of the beam.");
  beamVertexCmd->SetParameterName("vertex_x","vertex_y","vertex_z",false);
  beamVertexCmd->SetDefaultUnit("cm");

  polarCmd = new G4UIcmdWith3Vector("/ELYSE/gun/OpPhotonPolarisation",this);
  polarCmd->SetGuidance("Set polarization direction");
  polarCmd->SetParameterName("polar_x","polar_y","polar_z",false);
 
}//Ctor

//--------------------------------------------------------------------------------------------

ELYSE::PrimaryGeneratorMessenger::~PrimaryGeneratorMessenger() {
  delete particleTypeCmd;
  delete energyCmd;
  delete beamDirectionCmd;
  delete beamVertexCmd;
  delete polarCmd;

  delete ELYSEDir;
}//Dtor

//--------------------------------------------------------------------------------------------

void ELYSE::PrimaryGeneratorMessenger::SetNewValue(G4UIcommand * command,G4String newValue) {

  if( command == particleTypeCmd ) {
    myAction->SetBeamName(newValue);

  } else if ( command == energyCmd ) {
    myAction->SetBeamEnergy(energyCmd->GetNewDoubleValue(newValue));
    
  } else if ( command == beamDirectionCmd ) {
    myAction->SetBeamDir(beamDirectionCmd->GetNew3VectorValue(newValue));
  
  } else if ( command == beamVertexCmd ) {
    myAction->SetVtx(beamVertexCmd->GetNew3VectorValue(newValue));

  } else if ( command == polarCmd ) {
    myAction->SetOptPhotonPolar(polarCmd->GetNew3VectorValue(newValue));

  }

}//SetNewValue

//--------------------------------------------------------------------------------------------

