#include "ELYSE/RunAction.hh"

//Geant4
#include "G4Run.hh"
#include "G4Timer.hh"
#include "G4ios.hh"

//ELYSE
#include "ELYSE/RunActionMessenger.hh"

ELYSE::RunAction::RunAction() {
  // Messenger to allow IO options
  messenger = new RunActionMessenger(this);
  
  //Timer
  timer = new G4Timer();
  
}//Ctor

//----------------------------------------------------------------------------------

ELYSE::RunAction::~RunAction() {
  delete timer;

}//Dtor

//----------------------------------------------------------------------------------
void ELYSE::RunAction::BeginOfRunAction(const G4Run* aRun) {
  G4cout << "### Run " << aRun->GetRunID() << " start." << G4endl; 
  timer->Start();
}//BeginOfRunAction

//----------------------------------------------------------------------------------

void ELYSE::RunAction::EndOfRunAction(const G4Run* aRun) {
  timer->Stop();
  G4cout << "Total number of events = " << aRun->GetNumberOfEvent() 
         << " " << *timer << G4endl;
}//EndOfRunAction


