#include "ELYSE/StackingAction.hh"

//Geant4
#include "G4Track.hh"
#include "G4TrackStatus.hh"
#include "G4VPhysicalVolume.hh"
#include "Randomize.hh"
#include "G4Navigator.hh"
#include "G4TransportationManager.hh"
#include "G4ParticleDefinition.hh"
#include "G4ParticleTypes.hh"
//#include "G4VProcess.hh"

//ELYSE
#include "ELYSE/DetectorConstruction.hh"

ELYSE::StackingAction::StackingAction() : gammaCounter(0), stage(0) {}
ELYSE::StackingAction::~StackingAction() {}

G4ClassificationOfNewTrack ELYSE::StackingAction::ClassifyNewTrack (const G4Track* aTrack) {
  //JEC unused varaible 22/2/07  G4ClassificationOfNewTrack classification    = fWaiting;
  G4ParticleDefinition*      particleType      = aTrack->GetDefinition();
  G4String                   particleName      = particleType->GetParticleName();
  
//   G4cout << "(JEC):StackingAction::ClassifyNewTrack stage (" << stage << ")" << particleName
// 	<< G4endl;

  //Not to track neutrinos
  if(particleName == "nu_e"   || particleName == "anti_nu_e" || 
     particleName == "nu_mu"  || particleName == "anti_nu_mu" || 
     particleName == "nu_tau" || particleName == "anti_nu_tau"  ) return fKill;

  //count number of secondary Optical Photons
  if( particleName == "opticalphoton" ) {
    if(aTrack->GetParentID()>0)
    { // particle is secondary
      gammaCounter++;
    }
  }
  
  return fUrgent;
}//ClassifyNewTrack

//-------------------------------------------------------------------------
void ELYSE::StackingAction::NewStage() {
  stage++;
  G4cout << "Number of optical photons produces in this event : "
         << gammaCounter << G4endl;

}//NewStage

//-------------------------------------------------------------------------

void ELYSE::StackingAction::PrepareNewEvent() {
  gammaCounter = 0;
  stage = 0;
}//PrepareNewEvent




